/*
 * Decompiled with CFR 0.152.
 */
package db.dynamo.manage.conf;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProperties {
    private static final Logger logger = LoggerFactory.getLogger(TableProperties.class);
    public static final String TABLE_NAME = "tables.properties";
    public static final String RANGE_KEY_ATTR_NAME = "TABLE";
    public static final String INIT_READ_CAPACITY = "INIT_READ_CAP";
    public static final String INIT_WRITE_CAPACITY = "INIT_WRITE_CAP";
    public static final String MAX_READ_CAPACITY = "MAX_READ_CAP";
    public static final String MAX_WRITE_CAPACITY = "MAX_WRITE_CAP";
    private String env;
    private String tableName;
    private Long initialReadCap;
    private Long initialWriteCap;
    private Long maxReadCap;
    private Long maxWriteCap;

    public TableProperties(String env, String tableName, Long initialReadCap, Long initialWriteCap, Long maxReadCap, Long maxWriteCap) {
        this.env = env;
        this.tableName = tableName;
        this.initialReadCap = initialReadCap;
        this.initialWriteCap = initialWriteCap;
        this.maxReadCap = maxReadCap;
        this.maxWriteCap = maxWriteCap;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.env));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(this.tableName));
        if (this.initialReadCap != null) {
            this.initialReadCap = this.initialReadCap.intValue() > 0 ? this.initialReadCap : Long.valueOf(1L);
            map.put(INIT_READ_CAPACITY, new AttributeValue().withN(this.initialReadCap.toString()));
        }
        if (this.initialWriteCap != null) {
            this.initialWriteCap = this.initialWriteCap.intValue() > 0 ? this.initialWriteCap : Long.valueOf(1L);
            map.put(INIT_WRITE_CAPACITY, new AttributeValue().withN(this.initialWriteCap.toString()));
        }
        if (this.maxReadCap != null) {
            this.maxReadCap = this.maxReadCap.intValue() > 0 ? this.maxReadCap : Long.valueOf(1L);
            map.put(MAX_READ_CAPACITY, new AttributeValue().withN(this.maxReadCap.toString()));
        }
        if (this.maxWriteCap != null) {
            this.maxWriteCap = this.maxWriteCap.intValue() > 0 ? this.maxWriteCap : Long.valueOf(1L);
            map.put(MAX_WRITE_CAPACITY, new AttributeValue().withN(this.maxWriteCap.toString()));
        }
        return map;
    }

    public static TableProperties fromAttributeMap(Map<String, AttributeValue> map) {
        String env = map.get("ID").getS();
        String tableName = map.get(RANGE_KEY_ATTR_NAME) != null ? map.get(RANGE_KEY_ATTR_NAME).getS() : null;
        Long initialReadCap = map.get(INIT_READ_CAPACITY) != null ? Long.valueOf(map.get(INIT_READ_CAPACITY).getN()) : null;
        Long initialWriteCap = map.get(INIT_WRITE_CAPACITY) != null ? Long.valueOf(map.get(INIT_WRITE_CAPACITY).getN()) : null;
        Long maxReadCap = map.get(MAX_READ_CAPACITY) != null ? Long.valueOf(map.get(MAX_READ_CAPACITY).getN()) : null;
        Long maxWriteCap = map.get(MAX_WRITE_CAPACITY) != null ? Long.valueOf(map.get(MAX_WRITE_CAPACITY).getN()) : null;
        return new TableProperties(env, tableName, initialReadCap, initialWriteCap, maxReadCap, maxWriteCap);
    }

    public String getEnv() {
        return this.env;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Long getInitialReadCap() {
        return this.initialReadCap;
    }

    public Long getInitialWriteCap() {
        return this.initialWriteCap;
    }

    public Long getMaxReadCap() {
        return this.maxReadCap;
    }

    public Long getMaxWriteCap() {
        return this.maxWriteCap;
    }

    public static List<TableProperties> findAllTablePropertiesForCurrentEnv(String env, Token token) {
        logger.debug("findAllTablePropertiesForCurrentEnv");
        String finalTableName = TABLE_NAME;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<TableProperties> result = new ArrayList<TableProperties>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(env)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(TABLE_NAME, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(TableProperties.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }
}

