/*
 * Decompiled with CFR 0.152.
 */
package db.dynamo.manage.conf;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableApplications {
    private static final Logger logger = LoggerFactory.getLogger(TableApplications.class);
    public static final String TABLE_NAME = "table.applications";
    public static final String RANGE_KEY_ATTR_NAME = "APP";
    public static final String SECRET_ATTR_NAME = "SECRET";
    private String env;
    private String application;
    private String secret;

    public TableApplications(String env, String application, String secret) {
        this.env = env;
        this.application = application;
        this.secret = secret;
    }

    public String getEnv() {
        return this.env;
    }

    public String getApplication() {
        return this.application;
    }

    public String getSecret() {
        return this.secret;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.env));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(this.application));
        if (this.secret != null && !this.secret.isEmpty()) {
            map.put(SECRET_ATTR_NAME, new AttributeValue().withS(this.secret));
        }
        return map;
    }

    public static TableApplications fromAttributeMap(Map<String, AttributeValue> map) {
        String env = map.get("ID").getS();
        String application = map.get(RANGE_KEY_ATTR_NAME).getS();
        String secret = map.get(SECRET_ATTR_NAME) != null ? map.get(SECRET_ATTR_NAME).getS() : null;
        return new TableApplications(env, application, secret);
    }

    public static TableApplications fetchByEnvAndApp(String env, String appName, Token token) {
        logger.debug("fetchByEnvAndApp");
        String finalTableName = TABLE_NAME;
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(env));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(appName));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(TABLE_NAME, key, token);
        if (item == null) {
            return null;
        }
        return TableApplications.fromAttributeMap(item);
    }

    public static List<TableApplications> findAllTableApplicationsForCurrentEnv(String env, Token token) {
        logger.debug("findAllTablePropertiesForCurrentEnv");
        String finalTableName = TABLE_NAME;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<TableApplications> result = new ArrayList<TableApplications>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(env)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(TABLE_NAME, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(TableApplications.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }
}

