/*
 * Decompiled with CFR 0.152.
 */
package db.model.fb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.base.BaseToken;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="facebook.token", rangeKeyName="APPLICATION")
public class FacebookTokenEntity
extends BaseToken {
    private static final Logger logger = LoggerFactory.getLogger(FacebookTokenEntity.class);

    public FacebookTokenEntity(String fbAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, LocalDateTime timeWhenTokenWasUpdated, String application) {
        super(fbAccountId, accessToken, timeWhenTokenWillBeExpired, refreshDateTime, timeWhenTokenWasUpdated, application);
    }

    public static FacebookTokenEntity createCopy(FacebookTokenEntity facebookTokenEntity) {
        return new FacebookTokenEntity(facebookTokenEntity.getAccountId(), facebookTokenEntity.getAccessToken(), facebookTokenEntity.getTimeWhenTokenWillBeExpired(), facebookTokenEntity.getRefreshDateTime(), facebookTokenEntity.getTimeWhenTokenWasUpdated(), facebookTokenEntity.getApplication());
    }

    public static FacebookTokenEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String fbAccountId = map.get("ID").getS();
        String application = map.get("APPLICATION").getS();
        String accessToken = map.get("ACCESS_TOKEN") != null ? map.get("ACCESS_TOKEN").getS() : null;
        String timeWhenTokenWillBeExpiredMillisAsString = map.get("EXPIRE_TIME") != null ? map.get("EXPIRE_TIME").getS() : null;
        String refreshDateAsString = map.get("REFRESH_DATE") != null ? map.get("REFRESH_DATE").getS() : null;
        String timeWhenTokenWasUpdatedAsString = map.get("WAS_UPDATED_AT") != null ? map.get("WAS_UPDATED_AT").getS() : null;
        LocalDateTime timeWhenTokenWillBeExpiredMillis = timeWhenTokenWillBeExpiredMillisAsString != null ? LocalDateTime.parse((String)timeWhenTokenWillBeExpiredMillisAsString) : null;
        LocalDateTime refreshDate = refreshDateAsString != null ? LocalDateTime.parse((String)refreshDateAsString) : null;
        LocalDateTime timeWhenTokenWasUpdated = timeWhenTokenWasUpdatedAsString != null ? LocalDateTime.parse((String)timeWhenTokenWasUpdatedAsString) : null;
        return new FacebookTokenEntity(fbAccountId, accessToken, timeWhenTokenWillBeExpiredMillis, refreshDate, timeWhenTokenWasUpdated, application);
    }

    public static FacebookTokenEntity create(String fbAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, Token token) {
        logger.debug("create fbAccountId : " + fbAccountId);
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        FacebookTokenEntity facebookTokenEntity = new FacebookTokenEntity(fbAccountId, accessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now(), token.getSourceApplication());
        Map<String, AttributeValue> attributeValueMap = facebookTokenEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, attributeValueMap, token);
        return facebookTokenEntity;
    }

    public static FacebookTokenEntity fetchById(String fbAccountId, Token token) {
        logger.debug("fetchById fbAccountId : " + fbAccountId);
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(fbAccountId));
        key.put("APPLICATION", new AttributeValue().withS(token.getSourceApplication()));
        Map<String, AttributeValue> attributeValueMap = DynamoCommon.fetchItem(finalTableName, key, token);
        if (attributeValueMap == null) {
            return null;
        }
        return FacebookTokenEntity.fromAttributeMap(attributeValueMap);
    }

    public static FacebookTokenEntity updateToken(String fbAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, Token token) {
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        HashMap<String, AttributeValue> updatedItems = new HashMap<String, AttributeValue>();
        updatedItems.put("ACCESS_TOKEN", new AttributeValue().withS(accessToken));
        if (timeWhenTokenWillBeExpired != null) {
            updatedItems.put("EXPIRE_TIME", new AttributeValue().withS(timeWhenTokenWillBeExpired.toString()));
        }
        if (refreshDateTime != null) {
            updatedItems.put("REFRESH_DATE", new AttributeValue().withS(refreshDateTime.toString()));
        }
        updatedItems.put("WAS_UPDATED_AT", new AttributeValue().withS(LocalDateTime.now().toString()));
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(fbAccountId));
        key.put("APPLICATION", new AttributeValue().withS(token.getSourceApplication()));
        Map<String, AttributeValue> entity = DynamoCommon.updateMultipleAttributes(finalTableName, key, updatedItems, token);
        if (entity == null) {
            return null;
        }
        return FacebookTokenEntity.fromAttributeMap(entity);
    }

    public static void deleteItems(List<FacebookTokenEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (FacebookTokenEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            key.put("APPLICATION", new AttributeValue().withS(eachItem.getApplication()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    public static List<FacebookTokenEntity> fetchByIdList(List<String> idList, Token token) {
        List items;
        logger.debug("fetchByIdList");
        ArrayList<FacebookTokenEntity> result = new ArrayList<FacebookTokenEntity>();
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        HashMap<String, List<Map<String, Object>>> keyMap = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList keys = new ArrayList();
        keyMap.put(finalTableName, keys);
        HashMap finalResponse = new HashMap();
        int itemCounter = 0;
        for (String eachId : idList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachId));
            key.put("APPLICATION", new AttributeValue().withS(token.getSourceApplication()));
            keys.add(key);
            if (++itemCounter < 24) continue;
            itemCounter = 0;
            Map<String, List<Map<String, AttributeValue>>> response = DynamoCommon.batchGet(keyMap, token);
            keyMap = new HashMap();
            keys = new ArrayList();
            keyMap.put(finalTableName, keys);
            ArrayList existingItems = (ArrayList)finalResponse.get(finalTableName);
            if (existingItems == null) {
                existingItems = new ArrayList();
                finalResponse.put(finalTableName, existingItems);
            }
            existingItems.addAll(response.get(finalTableName));
        }
        if (itemCounter > 0) {
            Map<String, List<Map<String, AttributeValue>>> response = DynamoCommon.batchGet(keyMap, token);
            keyMap = new HashMap();
            keys = new ArrayList();
            keyMap.put(finalTableName, keys);
            ArrayList existingItems = (ArrayList)finalResponse.get(finalTableName);
            if (existingItems == null) {
                existingItems = new ArrayList();
                finalResponse.put(finalTableName, existingItems);
            }
            existingItems.addAll(response.get(finalTableName));
        }
        if ((items = (List)finalResponse.get(finalTableName)) != null && !items.isEmpty()) {
            for (Map eachItem : items) {
                result.add(FacebookTokenEntity.fromAttributeMap(eachItem));
            }
        }
        return result;
    }

    @Deprecated
    public static List<FacebookTokenEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(FacebookTokenEntity.class);
        ArrayList<FacebookTokenEntity> level1AccountEntityList = new ArrayList<FacebookTokenEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", "ACCESS_TOKEN", "EXPIRE_TIME", "REFRESH_DATE", "WAS_UPDATED_AT", "APPLICATION"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(FacebookTokenEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }
}

