/*
 * Decompiled with CFR 0.152.
 */
package db.model.base;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProfileMetaInfo {
    public static final String NUMBER_OF_FRIENDS_ATTR_NAME = "FRIENDS";
    public static final String NUMBER_OF_SUBSCRIBERS_ATTR_NAME = "SUBSCRIBERS";
    public static final String NUMBER_OF_POST_ATTR_NAME = "POSTS";
    public static final String OTHERS_COMMENT_ON_USER_POST_ATTR_NAME = "OTHER_COMMENTS_ON_USER_POSTS";
    public static final String OTHERS_LIKES_ON_USER_POST_ATTR_NAME = "OTHER_LIKES_ON_USER_POSTS";
    public static final String OTHERS_LIKES_ON_USER_COMMENT_ATTR_NAME = "OTHER_LIKES_ON_USER_COMMENTS";
    public static final String UPDATE_DATE_TIME_ATTR_NAME = "UPDATE_TIME";
    private String accountId;
    private Integer numberOfFriends;
    private Integer numberOfSubscribers;
    private Integer numberOfPost;
    private Integer othersCommentOnUserPost;
    private Integer othersLikesOnUserPost;
    private Integer othersLikesOnUserComment;
    private LocalDateTime updateDateTime;
    private String application;

    public BaseProfileMetaInfo(String accountId, Integer numberOfFriends, Integer numberOfSubscribers, Integer numberOfPost, Integer othersCommentOnUserPost, Integer othersLikesOnUserPost, Integer othersLikesOnUserComment, LocalDateTime updateDateTime, String application) {
        this.accountId = accountId;
        this.numberOfFriends = numberOfFriends;
        this.numberOfSubscribers = numberOfSubscribers;
        this.numberOfPost = numberOfPost;
        this.othersCommentOnUserPost = othersCommentOnUserPost;
        this.othersLikesOnUserPost = othersLikesOnUserPost;
        this.othersLikesOnUserComment = othersLikesOnUserComment;
        this.updateDateTime = updateDateTime;
        this.application = application;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Integer getNumberOfFriends() {
        return this.numberOfFriends;
    }

    public Integer getNumberOfSubscribers() {
        return this.numberOfSubscribers;
    }

    public Integer getNumberOfPost() {
        return this.numberOfPost;
    }

    public Integer getOthersCommentOnUserPost() {
        return this.othersCommentOnUserPost;
    }

    public Integer getOthersLikesOnUserPost() {
        return this.othersLikesOnUserPost;
    }

    public Integer getOthersLikesOnUserComment() {
        return this.othersLikesOnUserComment;
    }

    public LocalDateTime getUpdateDateTime() {
        return this.updateDateTime;
    }

    public String getApplication() {
        return this.application;
    }

    public Map<String, AttributeValue> keyMap() {
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(this.accountId));
        keyMap.put("APPLICATION", new AttributeValue().withS(this.application));
        return keyMap;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.accountId));
        map.put("APPLICATION", new AttributeValue().withS(this.application));
        if (this.numberOfFriends != null) {
            map.put(NUMBER_OF_FRIENDS_ATTR_NAME, new AttributeValue().withN(this.numberOfFriends.toString()));
        }
        if (this.numberOfSubscribers != null) {
            map.put(NUMBER_OF_SUBSCRIBERS_ATTR_NAME, new AttributeValue().withN(this.numberOfSubscribers.toString()));
        }
        if (this.numberOfPost != null) {
            map.put(NUMBER_OF_POST_ATTR_NAME, new AttributeValue().withN(this.numberOfPost.toString()));
        }
        if (this.othersCommentOnUserPost != null) {
            map.put(OTHERS_COMMENT_ON_USER_POST_ATTR_NAME, new AttributeValue().withN(this.othersCommentOnUserPost.toString()));
        }
        if (this.othersLikesOnUserPost != null) {
            map.put(OTHERS_LIKES_ON_USER_POST_ATTR_NAME, new AttributeValue().withN(this.othersLikesOnUserPost.toString()));
        }
        if (this.othersLikesOnUserComment != null) {
            map.put(OTHERS_LIKES_ON_USER_COMMENT_ATTR_NAME, new AttributeValue().withN(this.othersLikesOnUserComment.toString()));
        }
        if (this.updateDateTime != null) {
            map.put(UPDATE_DATE_TIME_ATTR_NAME, new AttributeValue().withS(this.updateDateTime.toString()));
        }
        return map;
    }
}

