/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.standart.event", rangeKeyName="INDEX", rangeKeyType="RANGE_KEY_TYPE_NUMBER")
public class StandartEventEntity {
    private static final Logger logger = LoggerFactory.getLogger(StandartEventEntity.class);
    public static final String RANGE_KEY_ATTR_NAME = "INDEX";
    public static final String EVENT_TIME_ATTR_NAME = "EVENT_TIME";
    public static final String EVENT_CODE_ATTR_NAME = "CODE";
    public static final String EVENT_ARG_ATTR_NAME = "ARG";
    private String dnaId;
    private Long eventIndex;
    private LocalDateTime eventDateTime;
    private String eventCode;
    private String eventArg;

    public StandartEventEntity(String dnaId, Long eventIndex, LocalDateTime eventDateTime, String eventCode, String eventArg) {
        this.dnaId = dnaId;
        this.eventIndex = eventIndex;
        this.eventDateTime = eventDateTime;
        this.eventCode = eventCode;
        this.eventArg = eventArg;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.dnaId));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(this.eventIndex.toString()));
        if (this.eventDateTime != null) {
            map.put(EVENT_TIME_ATTR_NAME, new AttributeValue().withS(this.eventDateTime.toString()));
        }
        if (this.eventCode != null && !this.eventCode.isEmpty()) {
            map.put(EVENT_CODE_ATTR_NAME, new AttributeValue().withS(this.eventCode));
        }
        if (this.eventArg != null && !this.eventArg.isEmpty()) {
            map.put(EVENT_ARG_ATTR_NAME, new AttributeValue().withS(this.eventArg));
        }
        return map;
    }

    public static StandartEventEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String dnaId = map.get("ID").getS();
        Long eventIndex = Long.parseLong(map.get(RANGE_KEY_ATTR_NAME).getN());
        LocalDateTime eventDateTime = LocalDateTime.parse((String)map.get(EVENT_TIME_ATTR_NAME).getS());
        String eventCode = map.get(EVENT_CODE_ATTR_NAME) != null ? map.get(EVENT_CODE_ATTR_NAME).getS() : null;
        String eventArg = map.get(EVENT_ARG_ATTR_NAME) != null ? map.get(EVENT_ARG_ATTR_NAME).getS() : null;
        return new StandartEventEntity(dnaId, eventIndex, eventDateTime, eventCode, eventArg);
    }

    public String getDnaId() {
        return this.dnaId;
    }

    public Long getEventIndex() {
        return this.eventIndex;
    }

    public LocalDateTime getEventDateTime() {
        return this.eventDateTime;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public String getEventArg() {
        return this.eventArg;
    }

    public static void saveList(List<StandartEventEntity> eventList, Token token) {
        logger.debug("saveList()");
        String finalTableName = Dynamo.getFinalTableName(StandartEventEntity.class);
        HashMap<String, List<Map<String, Object>>> items = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map<String, AttributeValue>> itemList = new ArrayList<Map<String, AttributeValue>>();
        items.put(finalTableName, itemList);
        int counter = 0;
        for (StandartEventEntity eachEntity : eventList) {
            itemList.add(eachEntity.toAttributeMap());
            if (++counter < 24) continue;
            DynamoCommon.batchWrite(items, token);
            counter = 0;
            items = new HashMap();
            itemList = new ArrayList();
            items.put(finalTableName, itemList);
        }
        if (counter > 0) {
            DynamoCommon.batchWrite(items, token);
        }
    }

    public static List<StandartEventEntity> findAllEventsSortedByIndexInDescOrder(String dnaId, Token token) {
        logger.debug("findAllEventsSortedByIndexInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(StandartEventEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<StandartEventEntity> result = new ArrayList<StandartEventEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, false, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(StandartEventEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<StandartEventEntity> findAllEventsSortedByIndexInDescOrder(String dnaId, Long startFromIndex, int count, Token token) {
        logger.debug("findAllEventsSortedByTimeInDescOrder start from : " + startFromIndex + " count : " + count);
        String finalTableName = Dynamo.getFinalTableName(StandartEventEntity.class);
        ArrayList<StandartEventEntity> result = new ArrayList<StandartEventEntity>();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        conditionMap.put("ID", hashKeyCondition);
        if (startFromIndex != null) {
            Condition rangeKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.LT.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withN(startFromIndex.toString())});
            conditionMap.put(RANGE_KEY_ATTR_NAME, rangeKeyCondition);
        }
        Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, count, null, false, token);
        List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
        for (Map<String, AttributeValue> eachItem : itemsList) {
            result.add(StandartEventEntity.fromAttributeMap(eachItem));
        }
        return result;
    }

    @Deprecated
    public static List<StandartEventEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(StandartEventEntity.class);
        ArrayList<StandartEventEntity> socialFriends = new ArrayList<StandartEventEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", RANGE_KEY_ATTR_NAME, EVENT_TIME_ATTR_NAME, EVENT_CODE_ATTR_NAME, EVENT_ARG_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(StandartEventEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<StandartEventEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(StandartEventEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (StandartEventEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getDnaId()));
            key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(eachItem.getEventIndex().toString()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }
}

