/*
 * Decompiled with CFR 0.152.
 */
package db.dynamo.manage.conf;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="table.segment.locker", rangeKeyName="SEGMENT", rangeKeyType="RANGE_KEY_TYPE_NUMBER")
public class TableSegmentLocker {
    private static final Logger logger = LoggerFactory.getLogger(TableSegmentLocker.class);
    public static final String RANGE_KEY_ATTR_NAME = "SEGMENT";
    public static final String TOTAL_SEGMENT_ATTR_NAME = "TOTAL_SEGMENTS";
    public static final String LOCK_UNLOCK_TIME_ATTR_NAME = "LOCK_UNLOCK_TIME";
    public static final String LOCK_ATTR_NAME = "LOCK";
    private String tableName;
    private Integer segment;
    private Integer totalSegment;
    private Boolean lock;
    private LocalDateTime lockTime;

    public TableSegmentLocker(String tableName, Integer segment, Integer totalSegment, Boolean lock, LocalDateTime lockTime) {
        this.tableName = tableName;
        this.segment = segment;
        this.totalSegment = totalSegment;
        this.lock = lock;
        this.lockTime = lockTime;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.tableName));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(this.segment.toString()));
        if (this.totalSegment != null) {
            map.put(TOTAL_SEGMENT_ATTR_NAME, new AttributeValue().withN(this.totalSegment.toString()));
        }
        if (this.lock != null) {
            map.put(LOCK_ATTR_NAME, new AttributeValue().withS(this.lock.toString()));
        }
        if (this.lockTime != null) {
            map.put(LOCK_UNLOCK_TIME_ATTR_NAME, new AttributeValue().withS(this.lockTime.toString()));
        }
        return map;
    }

    public static TableSegmentLocker fromAttributeMap(Map<String, AttributeValue> map) {
        String tableName = map.get("ID").getS();
        Integer segment = Integer.valueOf(map.get(RANGE_KEY_ATTR_NAME).getN());
        Integer totalSegment = map.get(TOTAL_SEGMENT_ATTR_NAME) != null ? Integer.valueOf(map.get(TOTAL_SEGMENT_ATTR_NAME).getN()) : null;
        Boolean lock = map.get(LOCK_ATTR_NAME) != null ? Boolean.valueOf(map.get(LOCK_ATTR_NAME).getS()) : null;
        LocalDateTime lockTime = map.get(LOCK_UNLOCK_TIME_ATTR_NAME) != null ? LocalDateTime.parse((String)map.get(LOCK_UNLOCK_TIME_ATTR_NAME).getS()) : null;
        return new TableSegmentLocker(tableName, segment, totalSegment, lock, lockTime);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public Integer getTotalSegment() {
        return this.totalSegment;
    }

    public Boolean getLock() {
        return this.lock;
    }

    public LocalDateTime getLockTime() {
        return this.lockTime;
    }

    public static void create(String tableName, Integer segment, Integer totalSegment, Token token) {
        logger.debug("create");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        TableSegmentLocker segmentLocker = new TableSegmentLocker(tableName, segment, totalSegment, Boolean.FALSE, null);
        Map<String, AttributeValue> item = segmentLocker.toAttributeMap();
        DynamoCommon.putItem(finalTableName, item, token);
    }

    public static boolean lock(String tableName, Integer segment, Token token) {
        logger.debug("lock");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(tableName));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(segment.toString()));
        HashMap<String, AttributeValue> updatedItems = new HashMap<String, AttributeValue>();
        updatedItems.put(LOCK_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        updatedItems.put(LOCK_UNLOCK_TIME_ATTR_NAME, new AttributeValue().withS(LocalDateTime.now().toString()));
        HashMap<String, AttributeValue> expectedAttributeValueMap = new HashMap<String, AttributeValue>();
        expectedAttributeValueMap.put(LOCK_ATTR_NAME, new AttributeValue().withS(Boolean.FALSE.toString()));
        boolean result = DynamoCommon.updateMultipleAttributesConditionally(finalTableName, key, updatedItems, expectedAttributeValueMap, token);
        return result;
    }

    public static boolean release(String tableName, Integer segment, Token token) {
        logger.debug("release");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(tableName));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(segment.toString()));
        HashMap<String, AttributeValue> updatedItems = new HashMap<String, AttributeValue>();
        updatedItems.put(LOCK_ATTR_NAME, new AttributeValue().withS(Boolean.FALSE.toString()));
        updatedItems.put(LOCK_UNLOCK_TIME_ATTR_NAME, new AttributeValue().withS(LocalDateTime.now().toString()));
        HashMap<String, AttributeValue> expectedAttributeValueMap = new HashMap<String, AttributeValue>();
        expectedAttributeValueMap.put(LOCK_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        boolean result = DynamoCommon.updateMultipleAttributesConditionally(finalTableName, key, updatedItems, expectedAttributeValueMap, token);
        return result;
    }

    public static TableSegmentLocker fetchById(String tableName, Integer segment, Token token) {
        logger.debug("fetchById");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(tableName));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(segment.toString()));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, key, token);
        if (item == null) {
            return null;
        }
        return TableSegmentLocker.fromAttributeMap(item);
    }

    public static List<TableSegmentLocker> findAllTableSegmentLockerSortedBySegment(String tableName, Token token) {
        logger.debug("findAllTableSegmentLockerSortedBySegment");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<TableSegmentLocker> result = new ArrayList<TableSegmentLocker>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(tableName)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(TableSegmentLocker.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    @Deprecated
    public static List<TableSegmentLocker> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        ArrayList<TableSegmentLocker> socialFriends = new ArrayList<TableSegmentLocker>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", RANGE_KEY_ATTR_NAME, TOTAL_SEGMENT_ATTR_NAME, LOCK_ATTR_NAME, LOCK_UNLOCK_TIME_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(TableSegmentLocker.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<TableSegmentLocker> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(TableSegmentLocker.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (TableSegmentLocker eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getTableName()));
            key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withN(eachItem.getSegment().toString()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }
}

