/*
 * Decompiled with CFR 0.152.
 */
package db.model.vk;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.base.BaseSocialNetworkUserProfile;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="vkontakte.user.profile")
public class VkontakteUserProfileEntity
extends BaseSocialNetworkUserProfile {
    private static final Logger logger = LoggerFactory.getLogger(VkontakteUserProfileEntity.class);

    public VkontakteUserProfileEntity(String accountId, String name, String gender, String locale, String email, String pictureUrl, String dnaId) {
        super(accountId, name, gender, locale, email, pictureUrl, dnaId);
    }

    public static VkontakteUserProfileEntity createCopy(VkontakteUserProfileEntity vkontakteUserProfileEntity) {
        return new VkontakteUserProfileEntity(vkontakteUserProfileEntity.getAccountId(), vkontakteUserProfileEntity.getName(), vkontakteUserProfileEntity.getGender(), vkontakteUserProfileEntity.getLocale(), vkontakteUserProfileEntity.getEmail(), vkontakteUserProfileEntity.getPictureUrl(), vkontakteUserProfileEntity.getDnaId());
    }

    public static VkontakteUserProfileEntity createCopyMappedToDifferentDnaAccount(VkontakteUserProfileEntity vkontakteUserProfileEntity, String newDnaId) {
        return new VkontakteUserProfileEntity(vkontakteUserProfileEntity.getAccountId(), vkontakteUserProfileEntity.getName(), vkontakteUserProfileEntity.getGender(), vkontakteUserProfileEntity.getLocale(), vkontakteUserProfileEntity.getEmail(), vkontakteUserProfileEntity.getPictureUrl(), newDnaId);
    }

    public static VkontakteUserProfileEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String fbAccountId = map.get("ID").getS();
        String name = map.get("NAME") != null ? map.get("NAME").getS() : null;
        String gender = map.get("GENDER") != null ? map.get("GENDER").getS() : null;
        String locale = map.get("LOCALE") != null ? map.get("LOCALE").getS() : null;
        String email = map.get("EMAIL") != null ? map.get("EMAIL").getS() : null;
        String picture = map.get("PICTURE") != null ? map.get("PICTURE").getS() : null;
        String dnaId = map.get("DNA_ID") != null ? map.get("DNA_ID").getS() : null;
        return new VkontakteUserProfileEntity(fbAccountId, name, gender, locale, email, picture, dnaId);
    }

    public static VkontakteUserProfileEntity createOrUpdate(String fbAccountId, String name, String gender, String locale, String email, String pictureUrl, String dnaId, Token token) {
        logger.debug("createOrUpdate accountId : " + fbAccountId);
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        VkontakteUserProfileEntity facebookUserProfileEntity = new VkontakteUserProfileEntity(fbAccountId, name, gender, locale, email, pictureUrl, dnaId);
        Map<String, AttributeValue> attributeValueMap = facebookUserProfileEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, attributeValueMap, token);
        return facebookUserProfileEntity;
    }

    public static VkontakteUserProfileEntity fetchById(String fbAccountId, Token token) {
        logger.debug("fetchById accountId : " + fbAccountId);
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(fbAccountId));
        Map<String, AttributeValue> attributeValueMap = DynamoCommon.fetchItem(finalTableName, key, token);
        if (attributeValueMap == null) {
            return null;
        }
        return VkontakteUserProfileEntity.fromAttributeMap(attributeValueMap);
    }

    public static List<VkontakteUserProfileEntity> fetchAllById(List<String> allIdList, Token token) {
        logger.debug("fetchAllById");
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        HashMap<String, List<Map<String, Object>>> keys = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList keyList = new ArrayList();
        keys.put(finalTableName, keyList);
        HashMap<String, ArrayList<Map<String, AttributeValue>>> result = new HashMap<String, ArrayList<Map<String, AttributeValue>>>();
        int counter = 0;
        for (String eachId : allIdList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachId));
            keyList.add(key);
            if (++counter < 24) continue;
            counter = 0;
            Map<String, List<Map<String, AttributeValue>>> tempResult = DynamoCommon.batchGet(keys, token);
            for (String eachTable : tempResult.keySet()) {
                List<Map<String, AttributeValue>> tempList = tempResult.get(eachTable);
                if (tempList == null) continue;
                ArrayList<Map<String, AttributeValue>> finalList = (ArrayList<Map<String, AttributeValue>>)result.get(eachTable);
                if (finalList == null) {
                    finalList = new ArrayList<Map<String, AttributeValue>>();
                    result.put(eachTable, finalList);
                }
                finalList.addAll(tempList);
            }
            keys = new HashMap();
            keyList = new ArrayList();
            keys.put(finalTableName, keyList);
        }
        if (counter > 0) {
            Map<String, List<Map<String, AttributeValue>>> tempResult = DynamoCommon.batchGet(keys, token);
            for (String eachTable : tempResult.keySet()) {
                List<Map<String, AttributeValue>> tempList = tempResult.get(eachTable);
                if (tempList == null) continue;
                ArrayList<Map<String, AttributeValue>> finalList = (ArrayList<Map<String, AttributeValue>>)result.get(eachTable);
                if (finalList == null) {
                    finalList = new ArrayList<Map<String, AttributeValue>>();
                    result.put(eachTable, finalList);
                }
                finalList.addAll(tempList);
            }
        }
        ArrayList<VkontakteUserProfileEntity> finalResult = new ArrayList<VkontakteUserProfileEntity>();
        List resultForCurTable = (List)result.get(finalTableName);
        for (Map eachItem : resultForCurTable) {
            finalResult.add(VkontakteUserProfileEntity.fromAttributeMap(eachItem));
        }
        return finalResult;
    }

    public static void saveList(List<VkontakteUserProfileEntity> entities, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>();
        map.put(finalTableName, items);
        int counter = 0;
        for (VkontakteUserProfileEntity eachAccount : entities) {
            items.add(eachAccount.toAttributeMap());
            if (++counter < 24) continue;
            DynamoCommon.batchWrite(map, token);
            counter = 0;
            map = new HashMap();
            items = new ArrayList();
            map.put(finalTableName, items);
        }
        if (counter > 0) {
            DynamoCommon.batchWrite(map, token);
        }
    }

    public static void deleteItems(List<VkontakteUserProfileEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (VkontakteUserProfileEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<VkontakteUserProfileEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(VkontakteUserProfileEntity.class);
        ArrayList<VkontakteUserProfileEntity> level1AccountEntityList = new ArrayList<VkontakteUserProfileEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", "NAME", "GENDER", "LOCALE", "EMAIL", "PICTURE"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(VkontakteUserProfileEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }
}

