/*
 * Decompiled with CFR 0.152.
 */
package db.model.vk;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.base.BaseToken;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="vkontakte.token")
public class VkontakteTokenEntity
extends BaseToken {
    private static final Logger logger = LoggerFactory.getLogger(VkontakteTokenEntity.class);

    public VkontakteTokenEntity(String vkAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, LocalDateTime timeWhenTokenWasUpdated) {
        super(vkAccountId, accessToken, timeWhenTokenWillBeExpired, refreshDateTime, timeWhenTokenWasUpdated);
    }

    public static VkontakteTokenEntity createCopy(VkontakteTokenEntity vkontakteTokenEntity) {
        return new VkontakteTokenEntity(vkontakteTokenEntity.getAccountId(), vkontakteTokenEntity.getAccessToken(), vkontakteTokenEntity.getTimeWhenTokenWillBeExpired(), vkontakteTokenEntity.getRefreshDateTime(), vkontakteTokenEntity.getTimeWhenTokenWasUpdated());
    }

    public static VkontakteTokenEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String vkAccountId = map.get("ID").getS();
        String accessToken = map.get("ACCESS_TOKEN") != null ? map.get("ACCESS_TOKEN").getS() : null;
        String timeWhenTokenWillBeExpiredMillisAsString = map.get("EXPIRE_TIME") != null ? map.get("EXPIRE_TIME").getS() : null;
        String refreshDateAsString = map.get("REFRESH_DATE") != null ? map.get("REFRESH_DATE").getS() : null;
        String timeWhenTokenWasUpdatedAsString = map.get("WAS_UPDATED_AT") != null ? map.get("WAS_UPDATED_AT").getS() : null;
        LocalDateTime timeWhenTokenWillBeExpiredMillis = timeWhenTokenWillBeExpiredMillisAsString != null ? LocalDateTime.parse((String)timeWhenTokenWillBeExpiredMillisAsString) : null;
        LocalDateTime refreshDate = refreshDateAsString != null ? LocalDateTime.parse((String)refreshDateAsString) : null;
        LocalDateTime timeWhenTokenWasUpdated = timeWhenTokenWasUpdatedAsString != null ? LocalDateTime.parse((String)timeWhenTokenWasUpdatedAsString) : null;
        return new VkontakteTokenEntity(vkAccountId, accessToken, timeWhenTokenWillBeExpiredMillis, refreshDate, timeWhenTokenWasUpdated);
    }

    public static VkontakteTokenEntity create(String vkAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, Token token) {
        logger.debug("create fbAccountId : " + vkAccountId);
        String finalTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        VkontakteTokenEntity facebookTokenEntity = new VkontakteTokenEntity(vkAccountId, accessToken, timeWhenTokenWillBeExpired, refreshDateTime, LocalDateTime.now());
        Map<String, AttributeValue> attributeValueMap = facebookTokenEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, attributeValueMap, token);
        return facebookTokenEntity;
    }

    public static VkontakteTokenEntity fetchById(String vkAccountId, Token token) {
        logger.debug("fetchById fbAccountId : " + vkAccountId);
        String finalTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(vkAccountId));
        Map<String, AttributeValue> attributeValueMap = DynamoCommon.fetchItem(finalTableName, key, token);
        if (attributeValueMap == null) {
            return null;
        }
        return VkontakteTokenEntity.fromAttributeMap(attributeValueMap);
    }

    public static VkontakteTokenEntity updateToken(String vkAccountId, String accessToken, LocalDateTime timeWhenTokenWillBeExpired, LocalDateTime refreshDateTime, Token token) {
        String finalTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        HashMap<String, AttributeValue> updatedItems = new HashMap<String, AttributeValue>();
        updatedItems.put("ACCESS_TOKEN", new AttributeValue().withS(accessToken));
        if (timeWhenTokenWillBeExpired != null) {
            updatedItems.put("EXPIRE_TIME", new AttributeValue().withS(timeWhenTokenWillBeExpired.toString()));
        }
        if (refreshDateTime != null) {
            updatedItems.put("REFRESH_DATE", new AttributeValue().withS(refreshDateTime.toString()));
        }
        updatedItems.put("WAS_UPDATED_AT", new AttributeValue().withS(LocalDateTime.now().toString()));
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(vkAccountId));
        Map<String, AttributeValue> entity = DynamoCommon.updateMultipleAttributes(finalTableName, key, updatedItems, token);
        if (entity == null) {
            return null;
        }
        return VkontakteTokenEntity.fromAttributeMap(entity);
    }

    public static void deleteItems(List<VkontakteTokenEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (VkontakteTokenEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<VkontakteTokenEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(VkontakteTokenEntity.class);
        ArrayList<VkontakteTokenEntity> level1AccountEntityList = new ArrayList<VkontakteTokenEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", "ACCESS_TOKEN", "EXPIRE_TIME", "REFRESH_DATE", "WAS_UPDATED_AT"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(VkontakteTokenEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }
}

