/*
 * Decompiled with CFR 0.152.
 */
package db.model.vk;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.base.BaseInfluence;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="vkontakte.influence")
public class VkontakteInfluenceEntity
extends BaseInfluence {
    private static final Logger logger = LoggerFactory.getLogger(VkontakteInfluenceEntity.class);

    public VkontakteInfluenceEntity(String accountId, Double friendsCumulativeProbability, Double subscribersCumulativeProbability, Double breadthSubScore, Double activitySubScore, Double othersCommentOnUserPostCumulativeProbability, Double othersLikesOnUserPostCumulativeProbability, Double othersLikesOnUserCommentCumulativeProbability, Double authoritySubScore, Double dnaInfluence) {
        super(accountId, friendsCumulativeProbability, subscribersCumulativeProbability, breadthSubScore, activitySubScore, othersCommentOnUserPostCumulativeProbability, othersLikesOnUserPostCumulativeProbability, othersLikesOnUserCommentCumulativeProbability, authoritySubScore, dnaInfluence);
    }

    public static VkontakteInfluenceEntity createCopy(VkontakteInfluenceEntity vkontakteInfluenceEntity) {
        return new VkontakteInfluenceEntity(vkontakteInfluenceEntity.getAccountId(), vkontakteInfluenceEntity.getFriendsCumulativeProbability(), vkontakteInfluenceEntity.getSubscribersCumulativeProbability(), vkontakteInfluenceEntity.getBreadthSubScore(), vkontakteInfluenceEntity.getActivitySubScore(), vkontakteInfluenceEntity.getOthersCommentOnUserPostCumulativeProbability(), vkontakteInfluenceEntity.getOthersLikesOnUserPostCumulativeProbability(), vkontakteInfluenceEntity.getOthersLikesOnUserCommentCumulativeProbability(), vkontakteInfluenceEntity.getAuthoritySubScore(), vkontakteInfluenceEntity.getDnaInfluence());
    }

    public static VkontakteInfluenceEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String fbAccountId = map.get("ID").getS();
        double friendsCumulativeProbability = map.get("FRIENDS_PROB") != null ? Double.parseDouble(map.get("FRIENDS_PROB").getN()) : 0.0;
        double subscribersCumulativeProbability = map.get("SUB_PROB") != null ? Double.parseDouble(map.get("SUB_PROB").getN()) : 0.0;
        double breadthSubScore = map.get("BREADTH_SUB_SCORE") != null ? Double.parseDouble(map.get("BREADTH_SUB_SCORE").getN()) : 0.0;
        double activitySubScore = map.get("ACTIVITY_SUB_SCORE") != null ? Double.parseDouble(map.get("ACTIVITY_SUB_SCORE").getN()) : 0.0;
        double othersCommentOnUserPostCumulativeProbability = map.get("OT_COMM_ON_US_POST_PROB") != null ? Double.parseDouble(map.get("OT_COMM_ON_US_POST_PROB").getN()) : 0.0;
        double othersLikesOnUserPostCumulativeProbability = map.get("OT_LIKES_ON_US_POST_PROB") != null ? Double.parseDouble(map.get("OT_LIKES_ON_US_POST_PROB").getN()) : 0.0;
        double othersLikesOnUserCommentCumulativeProbability = map.get("OT_LIKES_ON_US_COMM_PROB") != null ? Double.parseDouble(map.get("OT_LIKES_ON_US_COMM_PROB").getN()) : 0.0;
        double authoritySubScore = map.get("AUTHORITY_SUB_SCORE") != null ? Double.parseDouble(map.get("AUTHORITY_SUB_SCORE").getN()) : 0.0;
        double dnaInfluence = map.get("DNA_SCORES") != null ? Double.parseDouble(map.get("DNA_SCORES").getN()) : 0.0;
        return new VkontakteInfluenceEntity(fbAccountId, friendsCumulativeProbability, subscribersCumulativeProbability, breadthSubScore, activitySubScore, othersCommentOnUserPostCumulativeProbability, othersLikesOnUserPostCumulativeProbability, othersLikesOnUserCommentCumulativeProbability, authoritySubScore, dnaInfluence);
    }

    public static VkontakteInfluenceEntity save(VkontakteInfluenceEntity entity, Token token) {
        logger.debug("save");
        String finalTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        Map<String, AttributeValue> item = entity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, item, token);
        return entity;
    }

    public static VkontakteInfluenceEntity fetchById(String fbAccountId, Token token) {
        logger.debug("fetchById");
        String finalTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(fbAccountId));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, key, token);
        if (item == null) {
            return null;
        }
        return VkontakteInfluenceEntity.fromAttributeMap(item);
    }

    public static void deleteItems(List<VkontakteInfluenceEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (VkontakteInfluenceEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<VkontakteInfluenceEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(VkontakteInfluenceEntity.class);
        ArrayList<VkontakteInfluenceEntity> level1AccountEntityList = new ArrayList<VkontakteInfluenceEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", "FRIENDS_PROB", "SUB_PROB", "BREADTH_SUB_SCORE", "ACTIVITY_SUB_SCORE", "OT_COMM_ON_US_POST_PROB", "OT_LIKES_ON_US_POST_PROB", "OT_LIKES_ON_US_COMM_PROB", "AUTHORITY_SUB_SCORE", "DNA_SCORES"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(VkontakteInfluenceEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }
}

