/*
 * Decompiled with CFR 0.152.
 */
package db.model.vk;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="vkontakte.formula.arguments")
public class VkontakteFormulaArgumentsEntity {
    private static final Logger logger = LoggerFactory.getLogger(VkontakteFormulaArgumentsEntity.class);
    public static final String KEY = "unique.id";
    public static final String FRIENDS_MEAN_ATTR_NAME = "FRIENDS_MEAN";
    public static final String FRIENDS_STANDART_DEVIATION_ATTR_NAME = "FRIENDS_ST_DV";
    public static final String SUBSCRIBERS_MEAN_ATTR_NAME = "SUB_MEAN";
    public static final String SUBSCRIBERS_STANDART_DEVIATION_ATTR_NAME = "SUB_ST_DV";
    public static final String POST_MEAN_ATTR_NAME = "POSTS_MEAN";
    public static final String POST_STANDART_DEVIATION_ATTR_NAME = "POSTS_ST_DV";
    public static final String OTHER_COMMENTS_USER_POSTS_MEAN_ATTR_NAME = "OTH_COM_US_POSTS_MEAN";
    public static final String OTHER_COMMENTS_USER_POSTS_DEVIATION_ATTR_NAME = "OTH_COM_US_POSTS_ST_DV";
    public static final String OTHER_LIKES_USER_POSTS_MEAN_ATTR_NAME = "OTH_LIKES_US_POSTS_MEAN";
    public static final String OTHER_LIKES_USER_POSTS_DEVIATION_ATTR_NAME = "OTH_LIKES_US_POSTS_ST_DV";
    public static final String OTHER_LIKES_USER_COMMENTS_MEAN_ATTR_NAME = "OTH_LIKES_US_COM_MEAN";
    public static final String OTHER_LIKES_USER_COMMENTS_DEVIATION_ATTR_NAME = "OTH_LIKES_US_COM_ST_DV";
    public static final String FRIENDS_INSTEAD_ZERO = "FR_ZERO";
    public static final String SUBSCRIBERS_INSTEAD_ZERO = "SUB_ZERO";
    public static final String POSTS_INSTEAD_ZERO = "POSTS_ZERO";
    public static final String OTHER_COMMENTS_USER_POSTS_INSTEAD_ZERO = "OCUP_ZERO";
    public static final String OTHER_LIKES_USER_POSTS_INSTEAD_ZERO = "OLUP_ZERO";
    public static final String OTHER_LIKES_USER_COMMENTS_INSTEAD_ZERO = "OLUC_ZERO";
    public static final String KF_BREADTH_SUB_SCORE_FRIENDS = "KF_BREADTH_FR";
    public static final String KF_BREADTH_SUB_SCORE_SUBSCRIBERS = "KF_BREADTH_SUB";
    public static final String KF_AUTHORITY_SUB_SCORE_OTHERS_COMMENTS_ON_USER_POST = "KF_AUTH_OCUP";
    public static final String KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_POST = "KF_AUTH_OLUP";
    public static final String KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_COMMENTS = "KF_AUTH_OLUC";
    public static final String KF_FINAL_BREADTH_SUB_SCORE = "KF_FINAL_BREADTH";
    public static final String KF_FINAL_ACTIVITY_SUB_SCORE = "KF_FINAL_ACTIVITY";
    public static final String KF_FINAL_AUTHORITY_SUB_SCORE = "KF_FINAL_AUTH";
    private String id = "unique.id";
    private Double friendsMean;
    private Double friendsStandartDeviation;
    private Double subscribersMean;
    private Double subscribersStandartDeviation;
    private Double postsMean;
    private Double postsStandartDeviation;
    private Double otherCommentsOnUserPostMean;
    private Double otherCommentsOnUserPostStandartDeviation;
    private Double otherLikesOnUserPostMean;
    private Double otherLikesOnUserPostStandartDeviation;
    private Double otherLikesOnUserCommentsMean;
    private Double otherLikesOnUserCommentsStandartDeviation;
    private Double friendsInsteadZero;
    private Double subscribersInsteadZero;
    private Double postsInsteadZero;
    private Double otherCommentsUserPostsInsteadZero;
    private Double otherLikesUserPostsInsteadZero;
    private Double otherLikesUsersCommentsInsteadZero;
    private final Double kfBreadthSubScoreFriends;
    private final Double kfBreadthSubScoreSubscribers;
    private final Double kfAuthoritySubScoreOthersCommentOnUserPost;
    private final Double kfAuthoritySubScoreOthersLikesOnUserPost;
    private final Double kfAuthoritySubScoreOthersLikesOnUserComment;
    private final Double kfFinalBreadthSubScore;
    private final Double kfFinalActivitySubScore;
    private final Double kfFinalAuthoritySubScore;

    public VkontakteFormulaArgumentsEntity(Double friendsMean, Double friendsStandartDeviation, Double subscribersMean, Double subscribersStandartDeviation, Double postsMean, Double postsStandartDeviation, Double otherCommentsOnUserPostMean, Double otherCommentsOnUserPostStandartDeviation, Double otherLikesOnUserPostMean, Double otherLikesOnUserPostStandartDeviation, Double otherLikesOnUserCommentsMean, Double otherLikesOnUserCommentsStandartDeviation, Double friendsInsteadZero, Double subscribersInsteadZero, Double postsInsteadZero, Double otherCommentsUserPostsInsteadZero, Double otherLikesUserPostsInsteadZero, Double otherLikesUsersCommentsInsteadZero, Double kfBreadthSubScoreFriends, Double kfBreadthSubScoreSubscribers, Double kfAuthoritySubScoreOthersCommentOnUserPost, Double kfAuthoritySubScoreOthersLikesOnUserPost, Double kfAuthoritySubScoreOthersLikesOnUserComment, Double kfFinalBreadthSubScore, Double kfFinalActivitySubScore, Double kfFinalAuthoritySubScore) {
        this.friendsMean = friendsMean;
        this.friendsStandartDeviation = friendsStandartDeviation;
        this.subscribersMean = subscribersMean;
        this.subscribersStandartDeviation = subscribersStandartDeviation;
        this.postsMean = postsMean;
        this.postsStandartDeviation = postsStandartDeviation;
        this.otherCommentsOnUserPostMean = otherCommentsOnUserPostMean;
        this.otherCommentsOnUserPostStandartDeviation = otherCommentsOnUserPostStandartDeviation;
        this.otherLikesOnUserPostMean = otherLikesOnUserPostMean;
        this.otherLikesOnUserPostStandartDeviation = otherLikesOnUserPostStandartDeviation;
        this.otherLikesOnUserCommentsMean = otherLikesOnUserCommentsMean;
        this.otherLikesOnUserCommentsStandartDeviation = otherLikesOnUserCommentsStandartDeviation;
        this.friendsInsteadZero = friendsInsteadZero;
        this.subscribersInsteadZero = subscribersInsteadZero;
        this.postsInsteadZero = postsInsteadZero;
        this.otherCommentsUserPostsInsteadZero = otherCommentsUserPostsInsteadZero;
        this.otherLikesUserPostsInsteadZero = otherLikesUserPostsInsteadZero;
        this.otherLikesUsersCommentsInsteadZero = otherLikesUsersCommentsInsteadZero;
        this.kfBreadthSubScoreFriends = kfBreadthSubScoreFriends;
        this.kfBreadthSubScoreSubscribers = kfBreadthSubScoreSubscribers;
        this.kfAuthoritySubScoreOthersCommentOnUserPost = kfAuthoritySubScoreOthersCommentOnUserPost;
        this.kfAuthoritySubScoreOthersLikesOnUserPost = kfAuthoritySubScoreOthersLikesOnUserPost;
        this.kfAuthoritySubScoreOthersLikesOnUserComment = kfAuthoritySubScoreOthersLikesOnUserComment;
        this.kfFinalBreadthSubScore = kfFinalBreadthSubScore;
        this.kfFinalActivitySubScore = kfFinalActivitySubScore;
        this.kfFinalAuthoritySubScore = kfFinalAuthoritySubScore;
    }

    public static VkontakteFormulaArgumentsEntity createCopy(VkontakteFormulaArgumentsEntity formulaArgumentsEntity) {
        return new VkontakteFormulaArgumentsEntity(formulaArgumentsEntity.friendsMean, formulaArgumentsEntity.friendsStandartDeviation, formulaArgumentsEntity.subscribersMean, formulaArgumentsEntity.subscribersStandartDeviation, formulaArgumentsEntity.postsMean, formulaArgumentsEntity.postsStandartDeviation, formulaArgumentsEntity.otherCommentsOnUserPostMean, formulaArgumentsEntity.otherCommentsOnUserPostStandartDeviation, formulaArgumentsEntity.otherLikesOnUserPostMean, formulaArgumentsEntity.otherLikesOnUserPostStandartDeviation, formulaArgumentsEntity.otherLikesOnUserCommentsMean, formulaArgumentsEntity.otherLikesOnUserCommentsStandartDeviation, formulaArgumentsEntity.friendsInsteadZero, formulaArgumentsEntity.subscribersInsteadZero, formulaArgumentsEntity.postsInsteadZero, formulaArgumentsEntity.otherCommentsUserPostsInsteadZero, formulaArgumentsEntity.otherLikesUserPostsInsteadZero, formulaArgumentsEntity.otherLikesUsersCommentsInsteadZero, formulaArgumentsEntity.kfBreadthSubScoreFriends, formulaArgumentsEntity.kfBreadthSubScoreSubscribers, formulaArgumentsEntity.kfAuthoritySubScoreOthersCommentOnUserPost, formulaArgumentsEntity.kfAuthoritySubScoreOthersLikesOnUserPost, formulaArgumentsEntity.kfAuthoritySubScoreOthersLikesOnUserComment, formulaArgumentsEntity.kfFinalBreadthSubScore, formulaArgumentsEntity.kfFinalActivitySubScore, formulaArgumentsEntity.kfFinalAuthoritySubScore);
    }

    public Double getFriendsMean() {
        return this.friendsMean;
    }

    public Double getFriendsStandartDeviation() {
        return this.friendsStandartDeviation;
    }

    public Double getSubscribersMean() {
        return this.subscribersMean;
    }

    public Double getSubscribersStandartDeviation() {
        return this.subscribersStandartDeviation;
    }

    public Double getPostsMean() {
        return this.postsMean;
    }

    public Double getPostsStandartDeviation() {
        return this.postsStandartDeviation;
    }

    public Double getOtherCommentsOnUserPostMean() {
        return this.otherCommentsOnUserPostMean;
    }

    public Double getOtherCommentsOnUserPostStandartDeviation() {
        return this.otherCommentsOnUserPostStandartDeviation;
    }

    public Double getOtherLikesOnUserPostMean() {
        return this.otherLikesOnUserPostMean;
    }

    public Double getOtherLikesOnUserPostStandartDeviation() {
        return this.otherLikesOnUserPostStandartDeviation;
    }

    public Double getOtherLikesOnUserCommentsMean() {
        return this.otherLikesOnUserCommentsMean;
    }

    public Double getOtherLikesOnUserCommentsStandartDeviation() {
        return this.otherLikesOnUserCommentsStandartDeviation;
    }

    public Double getFriendsInsteadZero() {
        return this.friendsInsteadZero;
    }

    public Double getSubscribersInsteadZero() {
        return this.subscribersInsteadZero;
    }

    public Double getPostsInsteadZero() {
        return this.postsInsteadZero;
    }

    public Double getOtherCommentsUserPostsInsteadZero() {
        return this.otherCommentsUserPostsInsteadZero;
    }

    public Double getOtherLikesUserPostsInsteadZero() {
        return this.otherLikesUserPostsInsteadZero;
    }

    public Double getOtherLikesUsersCommentsInsteadZero() {
        return this.otherLikesUsersCommentsInsteadZero;
    }

    public Double getKfBreadthSubScoreFriends() {
        return this.kfBreadthSubScoreFriends;
    }

    public Double getKfBreadthSubScoreSubscribers() {
        return this.kfBreadthSubScoreSubscribers;
    }

    public Double getKfAuthoritySubScoreOthersCommentOnUserPost() {
        return this.kfAuthoritySubScoreOthersCommentOnUserPost;
    }

    public Double getKfAuthoritySubScoreOthersLikesOnUserPost() {
        return this.kfAuthoritySubScoreOthersLikesOnUserPost;
    }

    public Double getKfAuthoritySubScoreOthersLikesOnUserComment() {
        return this.kfAuthoritySubScoreOthersLikesOnUserComment;
    }

    public Double getKfFinalBreadthSubScore() {
        return this.kfFinalBreadthSubScore;
    }

    public Double getKfFinalActivitySubScore() {
        return this.kfFinalActivitySubScore;
    }

    public Double getKfFinalAuthoritySubScore() {
        return this.kfFinalAuthoritySubScore;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(KEY));
        if (this.friendsMean != null) {
            map.put(FRIENDS_MEAN_ATTR_NAME, new AttributeValue().withN(this.friendsMean.toString()));
        }
        if (this.friendsStandartDeviation != null) {
            map.put(FRIENDS_STANDART_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.friendsStandartDeviation.toString()));
        }
        if (this.subscribersMean != null) {
            map.put(SUBSCRIBERS_MEAN_ATTR_NAME, new AttributeValue().withN(this.subscribersMean.toString()));
        }
        if (this.subscribersStandartDeviation != null) {
            map.put(SUBSCRIBERS_STANDART_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.subscribersStandartDeviation.toString()));
        }
        if (this.postsMean != null) {
            map.put(POST_MEAN_ATTR_NAME, new AttributeValue().withN(this.postsMean.toString()));
        }
        if (this.postsStandartDeviation != null) {
            map.put(POST_STANDART_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.postsStandartDeviation.toString()));
        }
        if (this.otherCommentsOnUserPostMean != null) {
            map.put(OTHER_COMMENTS_USER_POSTS_MEAN_ATTR_NAME, new AttributeValue().withN(this.otherCommentsOnUserPostMean.toString()));
        }
        if (this.otherCommentsOnUserPostStandartDeviation != null) {
            map.put(OTHER_COMMENTS_USER_POSTS_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.otherCommentsOnUserPostStandartDeviation.toString()));
        }
        if (this.otherLikesOnUserPostMean != null) {
            map.put(OTHER_LIKES_USER_POSTS_MEAN_ATTR_NAME, new AttributeValue().withN(this.otherLikesOnUserPostMean.toString()));
        }
        if (this.otherLikesOnUserPostStandartDeviation != null) {
            map.put(OTHER_LIKES_USER_POSTS_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.otherLikesOnUserPostStandartDeviation.toString()));
        }
        if (this.otherLikesOnUserCommentsMean != null) {
            map.put(OTHER_LIKES_USER_COMMENTS_MEAN_ATTR_NAME, new AttributeValue().withN(this.otherLikesOnUserCommentsMean.toString()));
        }
        if (this.otherLikesOnUserCommentsStandartDeviation != null) {
            map.put(OTHER_LIKES_USER_COMMENTS_DEVIATION_ATTR_NAME, new AttributeValue().withN(this.otherLikesOnUserCommentsStandartDeviation.toString()));
        }
        if (this.friendsInsteadZero != null) {
            map.put(FRIENDS_INSTEAD_ZERO, new AttributeValue().withN(this.friendsInsteadZero.toString()));
        }
        if (this.subscribersInsteadZero != null) {
            map.put(SUBSCRIBERS_INSTEAD_ZERO, new AttributeValue().withN(this.subscribersInsteadZero.toString()));
        }
        if (this.postsInsteadZero != null) {
            map.put(POSTS_INSTEAD_ZERO, new AttributeValue().withN(this.postsInsteadZero.toString()));
        }
        if (this.otherCommentsUserPostsInsteadZero != null) {
            map.put(OTHER_COMMENTS_USER_POSTS_INSTEAD_ZERO, new AttributeValue().withN(this.otherCommentsUserPostsInsteadZero.toString()));
        }
        if (this.otherLikesUserPostsInsteadZero != null) {
            map.put(OTHER_LIKES_USER_POSTS_INSTEAD_ZERO, new AttributeValue().withN(this.otherLikesUserPostsInsteadZero.toString()));
        }
        if (this.otherLikesUsersCommentsInsteadZero != null) {
            map.put(OTHER_LIKES_USER_COMMENTS_INSTEAD_ZERO, new AttributeValue().withN(this.otherLikesUsersCommentsInsteadZero.toString()));
        }
        if (this.kfBreadthSubScoreFriends != null) {
            map.put(KF_BREADTH_SUB_SCORE_FRIENDS, new AttributeValue().withN(this.kfBreadthSubScoreFriends.toString()));
        }
        if (this.kfBreadthSubScoreSubscribers != null) {
            map.put(KF_BREADTH_SUB_SCORE_SUBSCRIBERS, new AttributeValue().withN(this.kfBreadthSubScoreSubscribers.toString()));
        }
        if (this.kfAuthoritySubScoreOthersCommentOnUserPost != null) {
            map.put(KF_AUTHORITY_SUB_SCORE_OTHERS_COMMENTS_ON_USER_POST, new AttributeValue().withN(this.kfAuthoritySubScoreOthersCommentOnUserPost.toString()));
        }
        if (this.kfAuthoritySubScoreOthersLikesOnUserPost != null) {
            map.put(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_POST, new AttributeValue().withN(this.kfAuthoritySubScoreOthersLikesOnUserPost.toString()));
        }
        if (this.kfAuthoritySubScoreOthersLikesOnUserComment != null) {
            map.put(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_COMMENTS, new AttributeValue().withN(this.kfAuthoritySubScoreOthersLikesOnUserComment.toString()));
        }
        if (this.kfFinalBreadthSubScore != null) {
            map.put(KF_FINAL_BREADTH_SUB_SCORE, new AttributeValue().withN(this.kfFinalBreadthSubScore.toString()));
        }
        if (this.kfFinalActivitySubScore != null) {
            map.put(KF_FINAL_ACTIVITY_SUB_SCORE, new AttributeValue().withN(this.kfFinalActivitySubScore.toString()));
        }
        if (this.kfFinalAuthoritySubScore != null) {
            map.put(KF_FINAL_AUTHORITY_SUB_SCORE, new AttributeValue().withN(this.kfFinalAuthoritySubScore.toString()));
        }
        return map;
    }

    public static VkontakteFormulaArgumentsEntity fromAttributeMap(Map<String, AttributeValue> map) {
        double friendsMean = map.get(FRIENDS_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(FRIENDS_MEAN_ATTR_NAME).getN()) : 0.0;
        double friendsStandartDeviation = map.get(FRIENDS_STANDART_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(FRIENDS_STANDART_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double subscribersMean = map.get(SUBSCRIBERS_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(SUBSCRIBERS_MEAN_ATTR_NAME).getN()) : 0.0;
        double subscribersStandartDeviation = map.get(SUBSCRIBERS_STANDART_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(SUBSCRIBERS_STANDART_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double postsMean = map.get(POST_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(POST_MEAN_ATTR_NAME).getN()) : 0.0;
        double postsStandartDeviation = map.get(POST_STANDART_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(POST_STANDART_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double otherCommentsOnUserPostMean = map.get(OTHER_COMMENTS_USER_POSTS_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_COMMENTS_USER_POSTS_MEAN_ATTR_NAME).getN()) : 0.0;
        double otherCommentsOnUserPostStandartDeviation = map.get(OTHER_COMMENTS_USER_POSTS_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_COMMENTS_USER_POSTS_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double otherLikesOnUserPostMean = map.get(OTHER_LIKES_USER_POSTS_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_POSTS_MEAN_ATTR_NAME).getN()) : 0.0;
        double otherLikesOnUserPostStandartDeviation = map.get(OTHER_LIKES_USER_POSTS_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_POSTS_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double otherLikesOnUserCommentsMean = map.get(OTHER_LIKES_USER_COMMENTS_MEAN_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_COMMENTS_MEAN_ATTR_NAME).getN()) : 0.0;
        double otherLikesOnUserCommentsStandartDeviation = map.get(OTHER_LIKES_USER_COMMENTS_DEVIATION_ATTR_NAME) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_COMMENTS_DEVIATION_ATTR_NAME).getN()) : 0.0;
        double friendsInsteadZero = map.get(FRIENDS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(FRIENDS_INSTEAD_ZERO).getN()) : 0.01;
        double subscribersInsteadZero = map.get(SUBSCRIBERS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(SUBSCRIBERS_INSTEAD_ZERO).getN()) : 0.01;
        double postsInsteadZero = map.get(POSTS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(POSTS_INSTEAD_ZERO).getN()) : 0.01;
        double otherCommentsUserPostsInsteadZero = map.get(OTHER_COMMENTS_USER_POSTS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(OTHER_COMMENTS_USER_POSTS_INSTEAD_ZERO).getN()) : 0.01;
        double otherLikesUserPostsInsteadZero = map.get(OTHER_LIKES_USER_POSTS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_POSTS_INSTEAD_ZERO).getN()) : 0.01;
        double otherLikesUsersCommentsInsteadZero = map.get(OTHER_LIKES_USER_COMMENTS_INSTEAD_ZERO) != null ? Double.parseDouble(map.get(OTHER_LIKES_USER_COMMENTS_INSTEAD_ZERO).getN()) : 0.01;
        double kfBreadthSubScoreFriends = map.get(KF_BREADTH_SUB_SCORE_FRIENDS) != null ? Double.parseDouble(map.get(KF_BREADTH_SUB_SCORE_FRIENDS).getN()) : 0.7;
        double kfBreadthSubScoreSubscribers = map.get(KF_BREADTH_SUB_SCORE_SUBSCRIBERS) != null ? Double.parseDouble(map.get(KF_BREADTH_SUB_SCORE_SUBSCRIBERS).getN()) : 0.3;
        double kfAuthoritySubScoreOthersCommentOnUserPost = map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_COMMENTS_ON_USER_POST) != null ? Double.parseDouble(map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_COMMENTS_ON_USER_POST).getN()) : 0.6;
        double kfAuthoritySubScoreOthersLikesOnUserPost = map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_POST) != null ? Double.parseDouble(map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_POST).getN()) : 0.2;
        double kfAuthoritySubScoreOthersLikesOnUserComment = map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_COMMENTS) != null ? Double.parseDouble(map.get(KF_AUTHORITY_SUB_SCORE_OTHERS_LIKES_ON_USER_COMMENTS).getN()) : 0.2;
        double kfFinalBreadthSubScore = map.get(KF_FINAL_BREADTH_SUB_SCORE) != null ? Double.parseDouble(map.get(KF_FINAL_BREADTH_SUB_SCORE).getN()) : 0.3;
        double kfFinalActivitySubScore = map.get(KF_FINAL_ACTIVITY_SUB_SCORE) != null ? Double.parseDouble(map.get(KF_FINAL_ACTIVITY_SUB_SCORE).getN()) : 0.3;
        double kfFinalAuthoritySubScore = map.get(KF_FINAL_AUTHORITY_SUB_SCORE) != null ? Double.parseDouble(map.get(KF_FINAL_AUTHORITY_SUB_SCORE).getN()) : 0.4;
        return new VkontakteFormulaArgumentsEntity(friendsMean, friendsStandartDeviation, subscribersMean, subscribersStandartDeviation, postsMean, postsStandartDeviation, otherCommentsOnUserPostMean, otherCommentsOnUserPostStandartDeviation, otherLikesOnUserPostMean, otherLikesOnUserPostStandartDeviation, otherLikesOnUserCommentsMean, otherLikesOnUserCommentsStandartDeviation, friendsInsteadZero, subscribersInsteadZero, postsInsteadZero, otherCommentsUserPostsInsteadZero, otherLikesUserPostsInsteadZero, otherLikesUsersCommentsInsteadZero, kfBreadthSubScoreFriends, kfBreadthSubScoreSubscribers, kfAuthoritySubScoreOthersCommentOnUserPost, kfAuthoritySubScoreOthersLikesOnUserPost, kfAuthoritySubScoreOthersLikesOnUserComment, kfFinalBreadthSubScore, kfFinalActivitySubScore, kfFinalAuthoritySubScore);
    }

    public static VkontakteFormulaArgumentsEntity defaultArgs() {
        return new VkontakteFormulaArgumentsEntity(Math.log(194.9268292682927), Math.log(215.35978933973314), Math.log(1.5365853658536586), Math.log(5.123543668215579), Math.log(33.27642276422764), Math.log(61.06490779611212), Math.log(14.682926829268293), Math.log(28.714912180387902), Math.log(70.5691056910569), Math.log(240.80766018059458), Math.log(1.2195121951219512), Math.log(3.3401103971297106), 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.7, 0.3, 0.6, 0.2, 0.2, 0.3, 0.3, 0.4);
    }

    public static VkontakteFormulaArgumentsEntity update(VkontakteFormulaArgumentsEntity vkontakteFormulaArgumentsEntity, Token token) {
        logger.debug("update");
        String finalTableName = Dynamo.getFinalTableName(VkontakteFormulaArgumentsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(KEY));
        Map<String, AttributeValue> item = vkontakteFormulaArgumentsEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, item, token);
        return vkontakteFormulaArgumentsEntity;
    }

    public static VkontakteFormulaArgumentsEntity fetch(Token token) {
        logger.debug("fetch");
        String finalTableName = Dynamo.getFinalTableName(VkontakteFormulaArgumentsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(KEY));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, key, token);
        if (item == null) {
            return VkontakteFormulaArgumentsEntity.update(VkontakteFormulaArgumentsEntity.defaultArgs(), token);
        }
        return VkontakteFormulaArgumentsEntity.fromAttributeMap(item);
    }

    public static void delete(Token token) {
        logger.debug("delete");
        String finalTableName = Dynamo.getFinalTableName(VkontakteFormulaArgumentsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(KEY));
        DynamoCommon.deleteItem(finalTableName, key, token);
    }
}

