/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="social.friends", rangeKeyName="FRIEND_ID", localSecondaryIndex="NAME")
public class SocialFriendsEntity {
    private static final Logger logger = LoggerFactory.getLogger(SocialFriendsEntity.class);
    public static final String RANGE_KEY_ATTR_NAME = "FRIEND_ID";
    public static final String LOCAL_SECONDARY_INDEX_ATTR_NAME = "NAME";
    public static final String GENDER_ATTR_NAME = "GENDER";
    public static final String LOCALE_ATTR_NAME = "LOCALE";
    public static final String EMAIL_ATTR_NAME = "EMAIL";
    public static final String PICTURE_ATTR_NAME = "PICTURE";
    public static final String NETWORK_ATTR_NAME = "NETWORK";
    public static final String INVITED_AT_ATTR_NAME = "INVITED_AT";
    private String dnaId;
    private String friendId;
    private String name;
    private String gender;
    private String locale;
    private String email;
    private String pictureUrl;
    private String network;
    private long invitedAt;

    public SocialFriendsEntity(String dnaId, String friendId, String name, String gender, String locale, String email, String pictureUrl, String network, long invitedAt) {
        this.dnaId = dnaId;
        this.friendId = friendId;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.network = network;
        this.invitedAt = invitedAt;
    }

    public static SocialFriendsEntity createCopy(SocialFriendsEntity socialFriendsEntity) {
        return new SocialFriendsEntity(socialFriendsEntity.dnaId, socialFriendsEntity.friendId, socialFriendsEntity.name, socialFriendsEntity.gender, socialFriendsEntity.locale, socialFriendsEntity.email, socialFriendsEntity.pictureUrl, socialFriendsEntity.network, socialFriendsEntity.invitedAt);
    }

    public static SocialFriendsEntity createCopyMappedToDifferentDnaAccount(SocialFriendsEntity socialFriendsEntity, String newDnaId) {
        return new SocialFriendsEntity(newDnaId, socialFriendsEntity.friendId, socialFriendsEntity.name, socialFriendsEntity.gender, socialFriendsEntity.locale, socialFriendsEntity.email, socialFriendsEntity.pictureUrl, socialFriendsEntity.network, 0L);
    }

    public String getDnaId() {
        return this.dnaId;
    }

    public String getFriendId() {
        return this.friendId;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getNetwork() {
        return this.network;
    }

    public long getInvitedAt() {
        return this.invitedAt;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.dnaId));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(this.friendId));
        if (this.name != null && !this.name.isEmpty()) {
            map.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withS(this.name));
        }
        if (this.gender != null && !this.gender.isEmpty()) {
            map.put(GENDER_ATTR_NAME, new AttributeValue().withS(this.gender));
        }
        if (this.locale != null && !this.locale.isEmpty()) {
            map.put(LOCALE_ATTR_NAME, new AttributeValue().withS(this.locale));
        }
        if (this.email != null && !this.email.isEmpty()) {
            map.put(EMAIL_ATTR_NAME, new AttributeValue().withS(this.email));
        }
        if (this.pictureUrl != null && !this.pictureUrl.isEmpty()) {
            map.put(PICTURE_ATTR_NAME, new AttributeValue().withS(this.pictureUrl));
        }
        if (this.network != null && !this.network.isEmpty()) {
            map.put(NETWORK_ATTR_NAME, new AttributeValue().withS(this.network));
        }
        map.put(INVITED_AT_ATTR_NAME, new AttributeValue().withN(Long.toString(this.invitedAt)));
        return map;
    }

    public static SocialFriendsEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String dnaId = map.get("ID").getS();
        String friendId = map.get(RANGE_KEY_ATTR_NAME).getS();
        String name = map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME) != null ? map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME).getS() : null;
        String gender = map.get(GENDER_ATTR_NAME) != null ? map.get(GENDER_ATTR_NAME).getS() : null;
        String locale = map.get(LOCALE_ATTR_NAME) != null ? map.get(LOCALE_ATTR_NAME).getS() : null;
        String email = map.get(EMAIL_ATTR_NAME) != null ? map.get(EMAIL_ATTR_NAME).getS() : null;
        String pictureUrl = map.get(PICTURE_ATTR_NAME) != null ? map.get(PICTURE_ATTR_NAME).getS() : null;
        String network = map.get(NETWORK_ATTR_NAME) != null ? map.get(NETWORK_ATTR_NAME).getS() : null;
        long invitedAt = map.get(INVITED_AT_ATTR_NAME) != null ? Long.parseLong(map.get(INVITED_AT_ATTR_NAME).getN()) : 0L;
        return new SocialFriendsEntity(dnaId, friendId, name, gender, locale, email, pictureUrl, network, invitedAt);
    }

    public static SocialFriendsEntity fetchById(String dnaId, String friendId, Token token) {
        logger.debug("fetchById()");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaId));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(friendId));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, key, token);
        if (item == null) {
            return null;
        }
        return SocialFriendsEntity.fromAttributeMap(item);
    }

    public static void saveList(List<SocialFriendsEntity> friendList, Token token) {
        logger.debug("saveList()");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        HashMap<String, List<Map<String, Object>>> items = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map<String, AttributeValue>> itemList = new ArrayList<Map<String, AttributeValue>>();
        items.put(finalTableName, itemList);
        int counter = 0;
        for (SocialFriendsEntity eachEntity : friendList) {
            itemList.add(eachEntity.toAttributeMap());
            if (++counter < 24) continue;
            DynamoCommon.batchWrite(items, token);
            counter = 0;
            items = new HashMap();
            itemList = new ArrayList();
            items.put(finalTableName, itemList);
        }
        if (counter > 0) {
            DynamoCommon.batchWrite(items, token);
        }
    }

    public static List<SocialFriendsEntity> findAllFriendsSortedByFriendId(String dnaId, Token token) {
        logger.debug("findAllFriends");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<SocialFriendsEntity> result = new ArrayList<SocialFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(SocialFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<SocialFriendsEntity> findAllFriendsSortedByFriendId(String dnaId, String startFromFriendId, int count, Token token) {
        logger.debug("findAllFriends start from : " + startFromFriendId + " count : " + count);
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        ArrayList<SocialFriendsEntity> result = new ArrayList<SocialFriendsEntity>();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        conditionMap.put("ID", hashKeyCondition);
        if (startFromFriendId != null) {
            Condition rangeKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.GT.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(startFromFriendId)});
            conditionMap.put(RANGE_KEY_ATTR_NAME, rangeKeyCondition);
        }
        Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, count, null, true, token);
        List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
        for (Map<String, AttributeValue> eachItem : itemsList) {
            result.add(SocialFriendsEntity.fromAttributeMap(eachItem));
        }
        return result;
    }

    public static List<SocialFriendsEntity> findAllFriendsSortedByFriendIdForSocialNetwork(String dnaId, SocialNetworks network, Token token) {
        logger.debug("findAllFriendsSortedByFriendIdForSocialNetwork : " + network.name());
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        ArrayList<SocialFriendsEntity> result = new ArrayList<SocialFriendsEntity>();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        conditionMap.put("ID", hashKeyCondition);
        Condition rangeKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.BEGINS_WITH.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(network.getTableIdPrefix())});
        conditionMap.put(RANGE_KEY_ATTR_NAME, rangeKeyCondition);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(SocialFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<SocialFriendsEntity> findAllFriendsSortedByFriendName(String dnaId, Token token) {
        logger.debug("findAllFriendsSortedByFriendName");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<SocialFriendsEntity> result = new ArrayList<SocialFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, 50, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(SocialFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static void inviteFriend(String ownDnaId, String friendId, Token token) {
        logger.debug("inviteFriend : friendId : " + friendId);
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(ownDnaId));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(friendId));
        Date date = new Date();
        long invitedAt = date.getTime();
        HashMap<String, AttributeValue> attributeValueMap = new HashMap<String, AttributeValue>();
        attributeValueMap.put(INVITED_AT_ATTR_NAME, new AttributeValue().withN(Long.toString(invitedAt)));
        DynamoCommon.updateMultipleAttributes(finalTableName, key, attributeValueMap, Token.backGroundAccessToke());
    }

    public static List<SocialFriendsEntity> findAllFriendsSortedByFriendName(String dnaId, String startFromFriendId, String startFromName, int count, Token token) {
        logger.debug("findAllFriendsSortedByFriendName startFromFriendId : " + startFromFriendId + " count : " + count);
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        ArrayList<SocialFriendsEntity> result = new ArrayList<SocialFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        HashMap<String, AttributeValue> lastEvaluatedKey = null;
        if (startFromFriendId != null && startFromName != null) {
            lastEvaluatedKey = new HashMap<String, AttributeValue>();
            lastEvaluatedKey.put("ID", new AttributeValue().withS(dnaId));
            lastEvaluatedKey.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(startFromFriendId));
            lastEvaluatedKey.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withS(startFromName));
        }
        Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, count, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, true, token);
        List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
        for (Map<String, AttributeValue> eachItem : itemsList) {
            result.add(SocialFriendsEntity.fromAttributeMap(eachItem));
        }
        return result;
    }

    @Deprecated
    public static List<SocialFriendsEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        ArrayList<SocialFriendsEntity> socialFriends = new ArrayList<SocialFriendsEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", RANGE_KEY_ATTR_NAME, LOCAL_SECONDARY_INDEX_ATTR_NAME, GENDER_ATTR_NAME, LOCALE_ATTR_NAME, EMAIL_ATTR_NAME, PICTURE_ATTR_NAME, NETWORK_ATTR_NAME, INVITED_AT_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(SocialFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<SocialFriendsEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(SocialFriendsEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (SocialFriendsEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getDnaId()));
            key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(eachItem.getFriendId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialFriendsEntity that = (SocialFriendsEntity)o;
        if (this.dnaId != null ? !this.dnaId.equals(that.dnaId) : that.dnaId != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.friendId != null ? !this.friendId.equals(that.friendId) : that.friendId != null) {
            return false;
        }
        if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        return !(this.pictureUrl != null ? !this.pictureUrl.equals(that.pictureUrl) : that.pictureUrl != null);
    }

    public int hashCode() {
        int result = this.dnaId != null ? this.dnaId.hashCode() : 0;
        result = 31 * result + (this.friendId != null ? this.friendId.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.pictureUrl != null ? this.pictureUrl.hashCode() : 0);
        result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SocialFriendsEntity{dnaId='" + this.dnaId + '\'' + ", friendId='" + this.friendId + '\'' + ", name='" + this.name + '\'' + ", gender='" + this.gender + '\'' + ", locale='" + this.locale + '\'' + ", email='" + this.email + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", network='" + this.network + '\'' + ", invitedAt=" + this.invitedAt + '}';
    }
}

