/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="level1.account")
public class Level1AccountEntity {
    private static final Logger logger = LoggerFactory.getLogger(Level1AccountEntity.class);
    public static final String DNA_ACCOUNT_ID_ATTR_NAME = "DNA_ACCOUNT_ID";
    private String level1accountId;
    private String dnaAccountId;

    public Level1AccountEntity(String level1accountId, String dnaAccountId) {
        this.level1accountId = level1accountId;
        this.dnaAccountId = dnaAccountId;
    }

    public static Level1AccountEntity createCopy(Level1AccountEntity level1AccountEntity) {
        return new Level1AccountEntity(level1AccountEntity.level1accountId, level1AccountEntity.dnaAccountId);
    }

    public String getLevel1accountId() {
        return this.level1accountId;
    }

    public String getDnaAccountId() {
        return this.dnaAccountId;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.level1accountId));
        if (this.dnaAccountId != null && !this.dnaAccountId.isEmpty()) {
            map.put(DNA_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(this.dnaAccountId));
        }
        return map;
    }

    public Map<String, AttributeValue> getKey() {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(this.level1accountId));
        return key;
    }

    public static Level1AccountEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String level1accountId = map.get("ID").getS();
        String dnaAccountId = map.get(DNA_ACCOUNT_ID_ATTR_NAME) != null ? map.get(DNA_ACCOUNT_ID_ATTR_NAME).getS() : null;
        return new Level1AccountEntity(level1accountId, dnaAccountId);
    }

    public static Level1AccountEntity create(Token token) {
        logger.debug("create : " + token.getAccountId());
        Level1AccountEntity level1AccountEntity = new Level1AccountEntity(token.getAccountId(), null);
        String finalTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
        Map<String, AttributeValue> entity = level1AccountEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, entity, token);
        return level1AccountEntity;
    }

    public static Level1AccountEntity fetchByToken(Token token) {
        logger.debug("fetchByToken : " + token.getAccountId());
        String finalTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(token.getAccountId()));
        Map<String, AttributeValue> entity = DynamoCommon.fetchItem(finalTableName, key, token);
        if (entity == null) {
            return null;
        }
        return Level1AccountEntity.fromAttributeMap(entity);
    }

    @Deprecated
    public static Level1AccountEntity attachAccounts(Level1AccountEntity sourceLevel1Account, String dnaAccountId, Token token) {
        logger.debug("attachAccounts : level1account : " + sourceLevel1Account.level1accountId + " dnaAccountId : " + dnaAccountId);
        String finalTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
        HashMap<String, AttributeValue> updatedItems = new HashMap<String, AttributeValue>();
        if (dnaAccountId != null && !dnaAccountId.isEmpty()) {
            updatedItems.put(DNA_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(dnaAccountId));
        } else {
            updatedItems.put(DNA_ACCOUNT_ID_ATTR_NAME, null);
        }
        Map<String, AttributeValue> entity = DynamoCommon.updateMultipleAttributes(finalTableName, sourceLevel1Account.getKey(), updatedItems, token);
        if (entity == null) {
            return null;
        }
        return Level1AccountEntity.fromAttributeMap(entity);
    }

    public static void deleteItems(List<Level1AccountEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (Level1AccountEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.level1accountId));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<Level1AccountEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(Level1AccountEntity.class);
        ArrayList<Level1AccountEntity> level1AccountEntityList = new ArrayList<Level1AccountEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", DNA_ACCOUNT_ID_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                level1AccountEntityList.add(Level1AccountEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return level1AccountEntityList;
    }

    public String toString() {
        return "Level1AccountEntity{level1accountId='" + this.level1accountId + '\'' + ", dnaAccountId='" + this.dnaAccountId + '\'' + '}';
    }
}

