/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import db.model.DnaUserProfileEntity;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.account.history", rangeKeyName="SNAPSHOT_TIME", localSecondaryIndex="SCORES", localSecondaryIndexType="LOCAL_SECONDARY_INDEX_TYPE_NUMBER")
public class DnaUserProfileHistoryEntity {
    private static final Logger logger = LoggerFactory.getLogger(DnaUserProfileHistoryEntity.class);
    public static final String RANGE_KEY_ATTR_NAME = "SNAPSHOT_TIME";
    public static final String LOCAL_SECONDARY_INDEX_ATTR_NAME = "SCORES";
    public static final String NAME_ATTR_NAME = "NAME";
    public static final String GENDER_ATTR_NAME = "GENDER";
    public static final String LOCALE_ATTR_NAME = "LOCALE";
    public static final String EMAIL_ATTR_NAME = "EMAIL";
    public static final String PICTURE_ATTR_NAME = "PICTURE";
    public static final String FB_ACCOUNT_ID_ATTR_NAME = "FB_ID";
    public static final String VK_ACCOUNT_ID_ATTR_NAME = "VK_ID";
    private String accountId;
    private LocalDateTime snapshotDateTime;
    private String name;
    private String gender;
    private String locale;
    private String email;
    private String pictureUrl;
    private Long scores;
    private String fbAccountId;
    private String vkAccountId;

    private DnaUserProfileHistoryEntity(String accountId, String name, String gender, String locale, String email, String pictureUrl, Long scores, String fbAccountId, String vkAccountId, LocalDateTime snapshotDateTime) {
        this.accountId = accountId;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.scores = scores;
        this.fbAccountId = fbAccountId;
        this.vkAccountId = vkAccountId;
        this.snapshotDateTime = snapshotDateTime;
    }

    public DnaUserProfileHistoryEntity(DnaUserProfileEntity dnaUserProfileEntity) {
        this.accountId = dnaUserProfileEntity.getAccountId();
        this.name = dnaUserProfileEntity.getName();
        this.gender = dnaUserProfileEntity.getGender();
        this.locale = dnaUserProfileEntity.getLocale();
        this.email = dnaUserProfileEntity.getEmail();
        this.pictureUrl = dnaUserProfileEntity.getPictureUrl();
        this.scores = dnaUserProfileEntity.getScores();
        this.fbAccountId = dnaUserProfileEntity.getFbAccountId();
        this.vkAccountId = dnaUserProfileEntity.getVkAccountId();
        this.snapshotDateTime = LocalDateTime.now();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LocalDateTime getSnapshotDateTime() {
        return this.snapshotDateTime;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public Long getScores() {
        return this.scores;
    }

    public String getFbAccountId() {
        return this.fbAccountId;
    }

    public String getVkAccountId() {
        return this.vkAccountId;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.accountId));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(this.snapshotDateTime.toString()));
        if (this.scores != null) {
            map.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withN(this.scores.toString()));
        }
        if (this.name != null && !this.name.isEmpty()) {
            map.put(NAME_ATTR_NAME, new AttributeValue().withS(this.name));
        }
        if (this.gender != null && !this.gender.isEmpty()) {
            map.put(GENDER_ATTR_NAME, new AttributeValue().withS(this.gender));
        }
        if (this.locale != null && !this.locale.isEmpty()) {
            map.put(LOCALE_ATTR_NAME, new AttributeValue().withS(this.locale));
        }
        if (this.email != null && !this.email.isEmpty()) {
            map.put(EMAIL_ATTR_NAME, new AttributeValue().withS(this.email));
        }
        if (this.pictureUrl != null && !this.pictureUrl.isEmpty()) {
            map.put(PICTURE_ATTR_NAME, new AttributeValue().withS(this.pictureUrl));
        }
        if (this.fbAccountId != null && !this.fbAccountId.isEmpty()) {
            map.put(FB_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(this.fbAccountId));
        }
        if (this.vkAccountId != null && !this.vkAccountId.isEmpty()) {
            map.put(VK_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(this.vkAccountId));
        }
        return map;
    }

    public static DnaUserProfileHistoryEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String accountId = map.get("ID").getS();
        LocalDateTime snapshotDateTime = LocalDateTime.parse((String)map.get(RANGE_KEY_ATTR_NAME).getS());
        Long scores = map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME) != null ? Long.valueOf(map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME).getN()) : null;
        String name = map.get(NAME_ATTR_NAME) != null ? map.get(NAME_ATTR_NAME).getS() : null;
        String gender = map.get(GENDER_ATTR_NAME) != null ? map.get(GENDER_ATTR_NAME).getS() : null;
        String locale = map.get(LOCALE_ATTR_NAME) != null ? map.get(LOCALE_ATTR_NAME).getS() : null;
        String email = map.get(EMAIL_ATTR_NAME) != null ? map.get(EMAIL_ATTR_NAME).getS() : null;
        String pictureUrl = map.get(PICTURE_ATTR_NAME) != null ? map.get(PICTURE_ATTR_NAME).getS() : null;
        String fbAccountId = map.get(FB_ACCOUNT_ID_ATTR_NAME) != null ? map.get(FB_ACCOUNT_ID_ATTR_NAME).getS() : null;
        String vkAccountId = map.get(VK_ACCOUNT_ID_ATTR_NAME) != null ? map.get(VK_ACCOUNT_ID_ATTR_NAME).getS() : null;
        return new DnaUserProfileHistoryEntity(accountId, name, gender, locale, email, pictureUrl, scores, fbAccountId, vkAccountId, snapshotDateTime);
    }

    public static List<DnaUserProfileHistoryEntity> findAllDnaUserProfileHistorySortedBySnapshotTimeStartedFromDateInDescOrder(String dnaId, LocalDateTime startDateTime, int count, Token token) {
        logger.debug("findAllDnaUserProfileHistorySortedBySnapshotTimeStartedFromDateInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        Object lastEvaluatedKey = null;
        ArrayList<DnaUserProfileHistoryEntity> result = new ArrayList<DnaUserProfileHistoryEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        Condition snapshotTimeCondition = new Condition().withComparisonOperator(ComparisonOperator.LE.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(startDateTime.toString())});
        conditionMap.put(RANGE_KEY_ATTR_NAME, snapshotTimeCondition);
        Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, count, null, false, token);
        List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
        for (Map<String, AttributeValue> eachItem : itemsList) {
            result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
        }
        return result;
    }

    public static List<DnaUserProfileHistoryEntity> findAllDnaUserProfileHistorySortedBySnapshotTimeBetweenTwoDates(String dnaId, LocalDateTime startDateTime, LocalDateTime endDateTime, Token token) {
        logger.debug("findAllDnaUserProfileHistorySortedBySnapshotTimeBetweenTwoDates");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<DnaUserProfileHistoryEntity> result = new ArrayList<DnaUserProfileHistoryEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        if (startDateTime != null && endDateTime != null && startDateTime.isBefore((ReadablePartial)endDateTime)) {
            Condition snapshotTimeCondition = new Condition().withComparisonOperator(ComparisonOperator.BETWEEN.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(startDateTime.toString()), new AttributeValue().withS(endDateTime.toString())});
            conditionMap.put(RANGE_KEY_ATTR_NAME, snapshotTimeCondition);
        }
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<DnaUserProfileHistoryEntity> findAllDnaUserProfileHistorySortedByScoresInDescOrder(String dnaId, LocalDateTime lastSnapshotTime, Long lastScores, Integer count, Token token) {
        Map<String, List<Map<String, AttributeValue>>> queryResult;
        logger.debug("findAllDnaUserProfileHistorySortedByScoresInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        Map<String, Object> lastEvaluatedKey = null;
        if (lastSnapshotTime != null && lastScores != null) {
            lastEvaluatedKey = new HashMap<String, AttributeValue>();
            lastEvaluatedKey.put("ID", new AttributeValue().withS(dnaId));
            lastEvaluatedKey.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(lastSnapshotTime.toString()));
            lastEvaluatedKey.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withN(lastScores.toString()));
        }
        ArrayList<DnaUserProfileHistoryEntity> result = new ArrayList<DnaUserProfileHistoryEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        if (lastScores != null) {
            Condition scoreCondition = new Condition().withComparisonOperator(ComparisonOperator.LE.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withN(lastScores.toString())});
            conditionMap.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, scoreCondition);
        }
        if (count == null) {
            do {
                queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, 50, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
                List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
                List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
                lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
                for (Map<String, AttributeValue> eachItem : itemsList) {
                    result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
                }
            } while (lastEvaluatedKey != null);
        } else {
            queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, count, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
            }
        }
        return result;
    }

    public static List<DnaUserProfileHistoryEntity> findAllDnaUserProfileHistorySortedByScoresInDescOrder(String dnaId, Token token) {
        logger.debug("findAllDnaUserProfileHistorySortedByScoresInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<DnaUserProfileHistoryEntity> result = new ArrayList<DnaUserProfileHistoryEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, 50, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<DnaUserProfileHistoryEntity> findAllDnaUserProfileHistorySortedBySnapshotTime(String dnaId, Token token) {
        logger.debug("findAllDnaUserProfileHistorySortedBySnapshotTime");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<DnaUserProfileHistoryEntity> result = new ArrayList<DnaUserProfileHistoryEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static void saveList(List<DnaUserProfileHistoryEntity> historyList, Token token) {
        logger.debug("saveList()");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        HashMap<String, List<Map<String, Object>>> items = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map<String, AttributeValue>> itemList = new ArrayList<Map<String, AttributeValue>>();
        items.put(finalTableName, itemList);
        int counter = 0;
        for (DnaUserProfileHistoryEntity eachEntity : historyList) {
            itemList.add(eachEntity.toAttributeMap());
            if (++counter < 24) continue;
            DynamoCommon.batchWrite(items, token);
            counter = 0;
            items = new HashMap();
            itemList = new ArrayList();
            items.put(finalTableName, itemList);
        }
        if (counter > 0) {
            DynamoCommon.batchWrite(items, token);
        }
    }

    @Deprecated
    public static List<DnaUserProfileHistoryEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        ArrayList<DnaUserProfileHistoryEntity> socialFriends = new ArrayList<DnaUserProfileHistoryEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", RANGE_KEY_ATTR_NAME, LOCAL_SECONDARY_INDEX_ATTR_NAME, NAME_ATTR_NAME, GENDER_ATTR_NAME, LOCALE_ATTR_NAME, EMAIL_ATTR_NAME, PICTURE_ATTR_NAME, FB_ACCOUNT_ID_ATTR_NAME, VK_ACCOUNT_ID_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(DnaUserProfileHistoryEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<DnaUserProfileHistoryEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileHistoryEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (DnaUserProfileHistoryEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(eachItem.getSnapshotDateTime().toString()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    public String toString() {
        return "DnaUserProfileHistoryEntity{accountId='" + this.accountId + '\'' + ", snapshotDateTime=" + this.snapshotDateTime + ", name='" + this.name + '\'' + ", gender='" + this.gender + '\'' + ", locale='" + this.locale + '\'' + ", email='" + this.email + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", scores=" + this.scores + ", fbAccountId='" + this.fbAccountId + '\'' + ", vkAccountId='" + this.vkAccountId + '\'' + '}';
    }
}

