/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import constants.SocialNetworks;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.account")
public class DnaUserProfileEntity {
    public static final String AMOUNT_OF_ALL_DNA_ACCOUNTS_COUNTER_NAME = "created-dna-accounts";
    private static final Logger logger = LoggerFactory.getLogger(DnaUserProfileEntity.class);
    public static final String NAME_ATTR_NAME = "NAME";
    public static final String GENDER_ATTR_NAME = "GENDER";
    public static final String LOCALE_ATTR_NAME = "LOCALE";
    public static final String EMAIL_ATTR_NAME = "EMAIL";
    public static final String PICTURE_ATTR_NAME = "PICTURE";
    public static final String SCORES_ATTR_NAME = "SCORES";
    public static final String FB_ACCOUNT_ID_ATTR_NAME = "FB_ID";
    public static final String TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME = "FB_ATTACHED";
    public static final String FB_ACTIVE_ATTR_NAME = "IS_FB_ACTIVE";
    public static final String VK_ACCOUNT_ID_ATTR_NAME = "VK_ID";
    public static final String TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME = "VK_ATTACHED";
    public static final String VK_ACTIVE_ATTR_NAME = "IS_VK_ACTIVE";
    public static final String TIME_WHEN_ACCOUNT_WAS_CREATED_ATTR_NAME = "CREATED_AT";
    public static final String LEVEL1_IDS_ATTR_NAME = "LEVEL1_IDS";
    public static final String MAIN_SOCIAL_NETWORK_NAME = "MAIN_NETWORK";
    private String accountId;
    private String name;
    private String gender;
    private String locale;
    private String email;
    private String pictureUrl;
    private Long scores;
    private String fbAccountId;
    private LocalDateTime timeWhenFbWasAttached;
    private Boolean fbActive;
    private String vkAccountId;
    private LocalDateTime timeWhenVkWasAttached;
    private Boolean vkActive;
    private LocalDateTime timeWhenAccountWasCreated;
    private ImmutableSet<String> level1ids;
    private SocialNetworks mainSocialNetwork;

    public DnaUserProfileEntity(String accountId, String name, String gender, String locale, String email, String pictureUrl, Long scores, String fbAccountId, LocalDateTime timeWhenFbWasAttached, Boolean fbActive, String vkAccountId, LocalDateTime timeWhenVkWasAttached, Boolean vkActive, LocalDateTime timeWhenAccountWasCreated, Set<String> level1ids, SocialNetworks mainNetwork) {
        this.accountId = accountId;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.scores = scores;
        this.fbAccountId = fbAccountId;
        this.timeWhenFbWasAttached = timeWhenFbWasAttached;
        this.fbActive = fbActive;
        this.vkAccountId = vkAccountId;
        this.timeWhenVkWasAttached = timeWhenVkWasAttached;
        this.vkActive = vkActive;
        this.timeWhenAccountWasCreated = timeWhenAccountWasCreated;
        this.level1ids = ImmutableSet.copyOf(level1ids);
        this.mainSocialNetwork = mainNetwork;
    }

    public static DnaUserProfileEntity createCopy(DnaUserProfileEntity dnaUserProfileEntity) {
        return new DnaUserProfileEntity(dnaUserProfileEntity.accountId, dnaUserProfileEntity.name, dnaUserProfileEntity.gender, dnaUserProfileEntity.locale, dnaUserProfileEntity.email, dnaUserProfileEntity.pictureUrl, dnaUserProfileEntity.scores, dnaUserProfileEntity.fbAccountId, dnaUserProfileEntity.timeWhenFbWasAttached, dnaUserProfileEntity.fbActive, dnaUserProfileEntity.vkAccountId, dnaUserProfileEntity.timeWhenVkWasAttached, dnaUserProfileEntity.vkActive, dnaUserProfileEntity.timeWhenAccountWasCreated, (Set<String>)dnaUserProfileEntity.level1ids, dnaUserProfileEntity.mainSocialNetwork);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public Long getScores() {
        return this.scores;
    }

    public String getFbAccountId() {
        return this.fbAccountId;
    }

    public String getVkAccountId() {
        return this.vkAccountId;
    }

    public Set<String> getLevel1ids() {
        return this.level1ids;
    }

    public LocalDateTime getTimeWhenFbWasAttached() {
        return this.timeWhenFbWasAttached;
    }

    public LocalDateTime getTimeWhenVkWasAttached() {
        return this.timeWhenVkWasAttached;
    }

    public Boolean isFbActive() {
        return this.fbActive;
    }

    public Boolean isVkActive() {
        return this.vkActive;
    }

    public LocalDateTime getTimeWhenAccountWasCreated() {
        return this.timeWhenAccountWasCreated;
    }

    public SocialNetworks getMainSocialNetwork() {
        return this.mainSocialNetwork;
    }

    public Set<String> getActiveNetworks() {
        logger.info("getActiveNetworks");
        HashSet<String> activeNetworks = new HashSet<String>();
        if (this.fbAccountId != null && this.fbActive.booleanValue()) {
            activeNetworks.add(SocialNetworks.Facebook.name());
        }
        if (this.vkAccountId != null && this.vkActive.booleanValue()) {
            activeNetworks.add(SocialNetworks.Vkontakte.name());
        }
        return activeNetworks;
    }

    public Set<String> getInactiveNetworks() {
        logger.info("getActiveNetworks");
        HashSet<String> inActiveNetworks = new HashSet<String>();
        if (this.fbAccountId != null && !this.fbActive.booleanValue()) {
            inActiveNetworks.add(SocialNetworks.Facebook.name());
        }
        if (this.vkAccountId != null && !this.vkActive.booleanValue()) {
            inActiveNetworks.add(SocialNetworks.Vkontakte.name());
        }
        return inActiveNetworks;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.accountId));
        if (this.name != null && !this.name.isEmpty()) {
            map.put(NAME_ATTR_NAME, new AttributeValue().withS(this.name));
        }
        if (this.gender != null && !this.gender.isEmpty()) {
            map.put(GENDER_ATTR_NAME, new AttributeValue().withS(this.gender));
        }
        if (this.locale != null && !this.locale.isEmpty()) {
            map.put(LOCALE_ATTR_NAME, new AttributeValue().withS(this.locale));
        }
        if (this.email != null && !this.email.isEmpty()) {
            map.put(EMAIL_ATTR_NAME, new AttributeValue().withS(this.email));
        }
        if (this.pictureUrl != null && !this.pictureUrl.isEmpty()) {
            map.put(PICTURE_ATTR_NAME, new AttributeValue().withS(this.pictureUrl));
        }
        if (this.scores != null) {
            map.put(SCORES_ATTR_NAME, new AttributeValue().withN(this.scores.toString()));
        }
        if (this.fbAccountId != null && !this.fbAccountId.isEmpty()) {
            map.put(FB_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(this.fbAccountId));
            map.put(TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME, new AttributeValue().withS(this.timeWhenFbWasAttached.toString()));
            map.put(FB_ACTIVE_ATTR_NAME, new AttributeValue().withS(this.fbActive.toString()));
        }
        if (this.vkAccountId != null && !this.vkAccountId.isEmpty()) {
            map.put(VK_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(this.vkAccountId));
            map.put(TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME, new AttributeValue().withS(this.timeWhenVkWasAttached.toString()));
            map.put(VK_ACTIVE_ATTR_NAME, new AttributeValue().withS(this.vkActive.toString()));
        }
        if (this.timeWhenAccountWasCreated != null) {
            map.put(TIME_WHEN_ACCOUNT_WAS_CREATED_ATTR_NAME, new AttributeValue().withS(this.timeWhenAccountWasCreated.toString()));
        }
        if (this.level1ids != null && !this.level1ids.isEmpty()) {
            map.put(LEVEL1_IDS_ATTR_NAME, new AttributeValue().withSS(this.level1ids));
        }
        if (this.mainSocialNetwork != null) {
            map.put(MAIN_SOCIAL_NETWORK_NAME, new AttributeValue().withS(this.mainSocialNetwork.name()));
        }
        return map;
    }

    public static DnaUserProfileEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String accountId = map.get("ID").getS();
        String name = map.get(NAME_ATTR_NAME) != null ? map.get(NAME_ATTR_NAME).getS() : null;
        String gender = map.get(GENDER_ATTR_NAME) != null ? map.get(GENDER_ATTR_NAME).getS() : null;
        String locale = map.get(LOCALE_ATTR_NAME) != null ? map.get(LOCALE_ATTR_NAME).getS() : null;
        String email = map.get(EMAIL_ATTR_NAME) != null ? map.get(EMAIL_ATTR_NAME).getS() : null;
        String picture = map.get(PICTURE_ATTR_NAME) != null ? map.get(PICTURE_ATTR_NAME).getS() : null;
        Long scores = map.get(SCORES_ATTR_NAME) != null ? Long.valueOf(map.get(SCORES_ATTR_NAME).getN()) : null;
        String fbAccountId = map.get(FB_ACCOUNT_ID_ATTR_NAME) != null ? map.get(FB_ACCOUNT_ID_ATTR_NAME).getS() : null;
        LocalDateTime timeWhenFbWasAttached = map.get(TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME) != null ? LocalDateTime.parse((String)map.get(TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME).getS()) : null;
        Boolean fbActive = map.get(FB_ACTIVE_ATTR_NAME) != null ? Boolean.valueOf(Boolean.parseBoolean(map.get(FB_ACTIVE_ATTR_NAME).getS())) : null;
        String vkAccountId = map.get(VK_ACCOUNT_ID_ATTR_NAME) != null ? map.get(VK_ACCOUNT_ID_ATTR_NAME).getS() : null;
        LocalDateTime timeWhenVkWasAttached = map.get(TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME) != null ? LocalDateTime.parse((String)map.get(TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME).getS()) : null;
        Boolean vkActive = map.get(VK_ACTIVE_ATTR_NAME) != null ? Boolean.valueOf(Boolean.parseBoolean(map.get(VK_ACTIVE_ATTR_NAME).getS())) : null;
        LocalDateTime timeWhenAccountWasCreated = map.get(TIME_WHEN_ACCOUNT_WAS_CREATED_ATTR_NAME) != null ? LocalDateTime.parse((String)map.get(TIME_WHEN_ACCOUNT_WAS_CREATED_ATTR_NAME).getS()) : null;
        ArrayList level1ids = map.get(LEVEL1_IDS_ATTR_NAME) != null ? map.get(LEVEL1_IDS_ATTR_NAME).getSS() : new ArrayList();
        HashSet<String> level1IdsSet = new HashSet<String>(level1ids);
        SocialNetworks mainNetwork = map.get(MAIN_SOCIAL_NETWORK_NAME) != null ? SocialNetworks.valueOf((String)map.get(MAIN_SOCIAL_NETWORK_NAME).getS()) : null;
        return new DnaUserProfileEntity(accountId, name, gender, locale, email, picture, scores, fbAccountId, timeWhenFbWasAttached, fbActive, vkAccountId, timeWhenVkWasAttached, vkActive, timeWhenAccountWasCreated, level1IdsSet, mainNetwork);
    }

    public static DnaUserProfileEntity create(DnaUserProfileEntity dnaUserProfileEntity, Token token) {
        logger.debug("create");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        Map<String, AttributeValue> attributeValueMap = dnaUserProfileEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, attributeValueMap, token);
        return dnaUserProfileEntity;
    }

    public static DnaUserProfileEntity deactivateSocialNetwork(String dnaAccountId, SocialNetworks network, Token token) {
        logger.debug("deactivateSocialNetwork : " + network.name());
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        if (network == SocialNetworks.Facebook) {
            newAttributes.put(FB_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.FALSE.toString()));
        } else if (network == SocialNetworks.Vkontakte) {
            newAttributes.put(VK_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.FALSE.toString()));
        } else {
            throw new IllegalArgumentException("There is no such network : " + network.name());
        }
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity activateSocialNetwork(String dnaAccountId, SocialNetworks network, Token token) {
        logger.debug("activateSocialNetwork : " + network.name());
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        if (network == SocialNetworks.Facebook) {
            newAttributes.put(FB_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        } else if (network == SocialNetworks.Vkontakte) {
            newAttributes.put(VK_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        } else {
            throw new IllegalArgumentException("There is no such network : " + network.name());
        }
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity fetchById(String dnaId, Token token) {
        logger.debug("fetchById");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaId));
        Map<String, AttributeValue> attributeValueMap = DynamoCommon.fetchItem(finalTableName, key, token);
        if (attributeValueMap == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(attributeValueMap);
    }

    public static List<DnaUserProfileEntity> fetchByIdList(List<String> dnaIdList, Token token) {
        List items;
        logger.debug("fetchByIdList");
        ArrayList<DnaUserProfileEntity> result = new ArrayList<DnaUserProfileEntity>();
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, List<Map<String, Object>>> keyMap = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList keys = new ArrayList();
        keyMap.put(finalTableName, keys);
        HashMap finalResponse = new HashMap();
        int itemCounter = 0;
        for (String eachId : dnaIdList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachId));
            keys.add(key);
            if (++itemCounter < 24) continue;
            itemCounter = 0;
            Map<String, List<Map<String, AttributeValue>>> response = DynamoCommon.batchGet(keyMap, token);
            keyMap = new HashMap();
            keys = new ArrayList();
            keyMap.put(finalTableName, keys);
            ArrayList existingItems = (ArrayList)finalResponse.get(finalTableName);
            if (existingItems == null) {
                existingItems = new ArrayList();
                finalResponse.put(finalTableName, existingItems);
            }
            existingItems.addAll(response.get(finalTableName));
        }
        if (itemCounter > 0) {
            Map<String, List<Map<String, AttributeValue>>> response = DynamoCommon.batchGet(keyMap, token);
            keyMap = new HashMap();
            keys = new ArrayList();
            keyMap.put(finalTableName, keys);
            ArrayList existingItems = (ArrayList)finalResponse.get(finalTableName);
            if (existingItems == null) {
                existingItems = new ArrayList();
                finalResponse.put(finalTableName, existingItems);
            }
            existingItems.addAll(response.get(finalTableName));
        }
        if ((items = (List)finalResponse.get(finalTableName)) != null && !items.isEmpty()) {
            for (Map eachItem : items) {
                result.add(DnaUserProfileEntity.fromAttributeMap(eachItem));
            }
        }
        return result;
    }

    public static DnaUserProfileEntity updateInfluence(String dnaAccountId, Long scores, Token token) {
        logger.debug("updateInfluence");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        newAttributes.put(SCORES_ATTR_NAME, new AttributeValue().withN(scores.toString()));
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity attachFbAccount(String dnaAccountId, String fbAccountId, LocalDateTime timeWhenFbWasAttached, Token token) {
        logger.debug("attachFbAccount");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        newAttributes.put(FB_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(fbAccountId));
        newAttributes.put(TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME, new AttributeValue().withS(timeWhenFbWasAttached.toString()));
        newAttributes.put(FB_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity attachVkAccount(String dnaAccountId, String vkAccountId, LocalDateTime timeWhenVkWasAttached, Token token) {
        logger.debug("attachVkAccount");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        newAttributes.put(VK_ACCOUNT_ID_ATTR_NAME, new AttributeValue().withS(vkAccountId));
        newAttributes.put(TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME, new AttributeValue().withS(timeWhenVkWasAttached.toString()));
        newAttributes.put(VK_ACTIVE_ATTR_NAME, new AttributeValue().withS(Boolean.TRUE.toString()));
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity attachLevel1Account(String dnaAccountId, String level1accountId, Token token) {
        logger.debug("attachLevel1Account");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        newAttributes.put(LEVEL1_IDS_ATTR_NAME, new AttributeValue().withSS(new String[]{level1accountId}));
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateSetAttributes(finalTableName, key, newAttributes, AttributeAction.ADD, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity dettachLevel1Account(String dnaAccountId, String level1accountId, Token token) {
        logger.debug("dettachLevel1Account");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        newAttributes.put(LEVEL1_IDS_ATTR_NAME, new AttributeValue().withSS(new String[]{level1accountId}));
        Map<String, AttributeValue> dnaProfile = DynamoCommon.updateSetAttributes(finalTableName, key, newAttributes, AttributeAction.DELETE, token);
        if (dnaProfile == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static DnaUserProfileEntity updateProfileUserInfo(String dnaAccountId, String name, String gender, String locale, String email, String pictureUrl, SocialNetworks mainSocialNetwork, Token token) {
        Map<String, AttributeValue> dnaProfile;
        logger.debug("updateProfileUserInfo");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaAccountId));
        HashMap<String, AttributeValue> newAttributes = new HashMap<String, AttributeValue>();
        if (name != null && !name.isEmpty()) {
            newAttributes.put(NAME_ATTR_NAME, new AttributeValue().withS(name));
        }
        if (gender != null && !gender.isEmpty()) {
            newAttributes.put(GENDER_ATTR_NAME, new AttributeValue().withS(gender));
        }
        if (locale != null && !locale.isEmpty()) {
            newAttributes.put(LOCALE_ATTR_NAME, new AttributeValue().withS(locale));
        }
        if (email != null && !email.isEmpty()) {
            newAttributes.put(EMAIL_ATTR_NAME, new AttributeValue().withS(email));
        }
        if (pictureUrl != null && !pictureUrl.isEmpty()) {
            newAttributes.put(PICTURE_ATTR_NAME, new AttributeValue().withS(pictureUrl));
        }
        if (mainSocialNetwork != null) {
            newAttributes.put(MAIN_SOCIAL_NETWORK_NAME, new AttributeValue().withS(mainSocialNetwork.name()));
        }
        if ((dnaProfile = DynamoCommon.updateMultipleAttributes(finalTableName, key, newAttributes, token)) == null) {
            return null;
        }
        return DnaUserProfileEntity.fromAttributeMap(dnaProfile);
    }

    public static void deleteItems(List<DnaUserProfileEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (DnaUserProfileEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getAccountId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    @Deprecated
    public static List<DnaUserProfileEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(DnaUserProfileEntity.class);
        ArrayList<DnaUserProfileEntity> socialFriends = new ArrayList<DnaUserProfileEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", NAME_ATTR_NAME, GENDER_ATTR_NAME, LOCALE_ATTR_NAME, EMAIL_ATTR_NAME, PICTURE_ATTR_NAME, SCORES_ATTR_NAME, FB_ACCOUNT_ID_ATTR_NAME, TIME_WHEN_FB_WAS_ATTACHED_ATTR_NAME, FB_ACTIVE_ATTR_NAME, VK_ACCOUNT_ID_ATTR_NAME, TIME_WHEN_VK_WAS_ATTACHED_ATTR_NAME, VK_ACTIVE_ATTR_NAME, TIME_WHEN_ACCOUNT_WAS_CREATED_ATTR_NAME, LEVEL1_IDS_ATTR_NAME, MAIN_SOCIAL_NETWORK_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(DnaUserProfileEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public String toString() {
        return "DnaUserProfileEntity{accountId='" + this.accountId + '\'' + ", name='" + this.name + '\'' + ", gender='" + this.gender + '\'' + ", locale='" + this.locale + '\'' + ", email='" + this.email + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", scores=" + this.scores + ", fbAccountId='" + this.fbAccountId + '\'' + ", timeWhenFbWasAttached=" + this.timeWhenFbWasAttached + ", fbActive=" + this.fbActive + ", vkAccountId='" + this.vkAccountId + '\'' + ", timeWhenVkWasAttached=" + this.timeWhenVkWasAttached + ", vkActive=" + this.vkActive + ", timeWhenAccountWasCreated=" + this.timeWhenAccountWasCreated + ", level1ids=" + this.level1ids + '}';
    }
}

