/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.friends", rangeKeyName="FRIEND_ID", localSecondaryIndex="SCORES", localSecondaryIndexType="LOCAL_SECONDARY_INDEX_TYPE_NUMBER")
public class DnaFriendsEntity {
    private static final Logger logger = LoggerFactory.getLogger(DnaFriendsEntity.class);
    public static final String RANGE_KEY_ATTR_NAME = "FRIEND_ID";
    public static final String LOCAL_SECONDARY_INDEX_ATTR_NAME = "SCORES";
    public static final String NAME_ATTR_NAME = "NAME";
    public static final String GENDER_ATTR_NAME = "GENDER";
    public static final String LOCALE_ATTR_NAME = "LOCALE";
    public static final String EMAIL_ATTR_NAME = "EMAIL";
    public static final String PICTURE_ATTR_NAME = "PICTURE";
    public static final String TIME_WHEN_DNA_ACCOUNT_WAS_CREATED_ATTR_NAME = "CREATED";
    private String dnaId;
    private String friendId;
    private Long scores;
    private String name;
    private String gender;
    private String locale;
    private String email;
    private String pictureUrl;
    private LocalDateTime timeWhenDnaAccountWasCreated;

    public DnaFriendsEntity(String dnaId, String friendId, Long scores, String name, String gender, String locale, String email, String pictureUrl, LocalDateTime timeWhenDnaAccountWasCreated) {
        this.dnaId = dnaId;
        this.friendId = friendId;
        this.scores = scores;
        this.name = name;
        this.gender = gender;
        this.locale = locale;
        this.email = email;
        this.pictureUrl = pictureUrl;
        this.timeWhenDnaAccountWasCreated = timeWhenDnaAccountWasCreated;
    }

    public static DnaFriendsEntity createCopy(DnaFriendsEntity dnaFriendsEntity) {
        return new DnaFriendsEntity(dnaFriendsEntity.dnaId, dnaFriendsEntity.friendId, dnaFriendsEntity.scores, dnaFriendsEntity.name, dnaFriendsEntity.gender, dnaFriendsEntity.locale, dnaFriendsEntity.email, dnaFriendsEntity.pictureUrl, dnaFriendsEntity.timeWhenDnaAccountWasCreated);
    }

    public static DnaFriendsEntity createCopyMappedToDifferentDnaAccount(DnaFriendsEntity dnaFriendsEntity, String newDnaId) {
        return new DnaFriendsEntity(newDnaId, dnaFriendsEntity.friendId, dnaFriendsEntity.scores, dnaFriendsEntity.name, dnaFriendsEntity.gender, dnaFriendsEntity.locale, dnaFriendsEntity.email, dnaFriendsEntity.pictureUrl, dnaFriendsEntity.timeWhenDnaAccountWasCreated);
    }

    public String getDnaId() {
        return this.dnaId;
    }

    public String getFriendId() {
        return this.friendId;
    }

    public Long getScores() {
        return this.scores;
    }

    public String getName() {
        return this.name;
    }

    public String getGender() {
        return this.gender;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public LocalDateTime getTimeWhenDnaAccountWasCreated() {
        return this.timeWhenDnaAccountWasCreated;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.dnaId));
        map.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(this.friendId));
        if (this.scores != null) {
            map.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withN(this.scores.toString()));
        }
        if (this.name != null && !this.name.isEmpty()) {
            map.put(NAME_ATTR_NAME, new AttributeValue().withS(this.name));
        }
        if (this.gender != null && !this.gender.isEmpty()) {
            map.put(GENDER_ATTR_NAME, new AttributeValue().withS(this.gender));
        }
        if (this.locale != null && !this.locale.isEmpty()) {
            map.put(LOCALE_ATTR_NAME, new AttributeValue().withS(this.locale));
        }
        if (this.email != null && !this.email.isEmpty()) {
            map.put(EMAIL_ATTR_NAME, new AttributeValue().withS(this.email));
        }
        if (this.pictureUrl != null && !this.pictureUrl.isEmpty()) {
            map.put(PICTURE_ATTR_NAME, new AttributeValue().withS(this.pictureUrl));
        }
        if (this.timeWhenDnaAccountWasCreated != null) {
            map.put(TIME_WHEN_DNA_ACCOUNT_WAS_CREATED_ATTR_NAME, new AttributeValue().withS(this.timeWhenDnaAccountWasCreated.toString()));
        }
        return map;
    }

    public static DnaFriendsEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String dnaId = map.get("ID").getS();
        String friendId = map.get(RANGE_KEY_ATTR_NAME).getS();
        Long scores = map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME) != null ? Long.valueOf(map.get(LOCAL_SECONDARY_INDEX_ATTR_NAME).getN()) : null;
        String name = map.get(NAME_ATTR_NAME) != null ? map.get(NAME_ATTR_NAME).getS() : null;
        String gender = map.get(GENDER_ATTR_NAME) != null ? map.get(GENDER_ATTR_NAME).getS() : null;
        String locale = map.get(LOCALE_ATTR_NAME) != null ? map.get(LOCALE_ATTR_NAME).getS() : null;
        String email = map.get(EMAIL_ATTR_NAME) != null ? map.get(EMAIL_ATTR_NAME).getS() : null;
        String pictureUrl = map.get(PICTURE_ATTR_NAME) != null ? map.get(PICTURE_ATTR_NAME).getS() : null;
        LocalDateTime timeWhenDnaAccountWasCreated = map.get(TIME_WHEN_DNA_ACCOUNT_WAS_CREATED_ATTR_NAME) != null ? LocalDateTime.parse((String)map.get(TIME_WHEN_DNA_ACCOUNT_WAS_CREATED_ATTR_NAME).getS()) : null;
        return new DnaFriendsEntity(dnaId, friendId, scores, name, gender, locale, email, pictureUrl, timeWhenDnaAccountWasCreated);
    }

    public static void saveList(List<DnaFriendsEntity> friendList, Token token) {
        logger.debug("saveList()");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        HashMap<String, List<Map<String, Object>>> items = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map<String, AttributeValue>> itemList = new ArrayList<Map<String, AttributeValue>>();
        items.put(finalTableName, itemList);
        int counter = 0;
        for (DnaFriendsEntity eachEntity : friendList) {
            itemList.add(eachEntity.toAttributeMap());
            if (++counter < 24) continue;
            DynamoCommon.batchWrite(items, token);
            counter = 0;
            items = new HashMap();
            itemList = new ArrayList();
            items.put(finalTableName, itemList);
        }
        if (counter > 0) {
            DynamoCommon.batchWrite(items, token);
        }
    }

    public static DnaFriendsEntity fetchById(String dnaId, String friendId, Token token) {
        logger.debug("fetchById");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put("ID", new AttributeValue().withS(dnaId));
        key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(friendId));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, key, token);
        if (item == null) {
            return null;
        }
        return DnaFriendsEntity.fromAttributeMap(item);
    }

    public static List<DnaFriendsEntity> findAllFriendsSortedByFriendId(String dnaId, Token token) {
        logger.debug("findAllFriendsSortedByFriendId");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<DnaFriendsEntity> result = new ArrayList<DnaFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, 50, lastEvaluatedKey, true, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    public static List<DnaFriendsEntity> findAllFriendsSortedByFriendId(String dnaId, String startFromFriendId, int count, Token token) {
        logger.debug("findAllFriendsSortedByFriendId start from : " + startFromFriendId + " count : " + count);
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        ArrayList<DnaFriendsEntity> result = new ArrayList<DnaFriendsEntity>();
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        conditionMap.put("ID", hashKeyCondition);
        if (startFromFriendId != null) {
            Condition rangeKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.GT.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(startFromFriendId)});
            conditionMap.put(RANGE_KEY_ATTR_NAME, rangeKeyCondition);
        }
        Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.query(finalTableName, conditionMap, count, null, true, token);
        List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
        for (Map<String, AttributeValue> eachItem : itemsList) {
            result.add(DnaFriendsEntity.fromAttributeMap(eachItem));
        }
        return result;
    }

    public static List<DnaFriendsEntity> findAllFriendsSortedByFriendScoresInDescOrder(String dnaId, Long startFromScore, String lastFriendId, Long lastFriendScore, Integer count, Token token) {
        Map<String, List<Map<String, AttributeValue>>> queryResult;
        logger.debug("findAllFriendsSortedByFriendScoresInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        Map<String, Object> lastEvaluatedKey = null;
        if (lastFriendId != null && lastFriendScore != null) {
            lastEvaluatedKey = new HashMap<String, AttributeValue>();
            lastEvaluatedKey.put("ID", new AttributeValue().withS(dnaId));
            lastEvaluatedKey.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(lastFriendId));
            lastEvaluatedKey.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, new AttributeValue().withN(lastFriendScore.toString()));
        }
        ArrayList<DnaFriendsEntity> result = new ArrayList<DnaFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        if (startFromScore != null) {
            Condition scoreCondition = new Condition().withComparisonOperator(ComparisonOperator.LE.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withN(startFromScore.toString())});
            conditionMap.put(LOCAL_SECONDARY_INDEX_ATTR_NAME, scoreCondition);
        }
        if (count == null) {
            do {
                queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, 50, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
                List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
                List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
                lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
                for (Map<String, AttributeValue> eachItem : itemsList) {
                    result.add(DnaFriendsEntity.fromAttributeMap(eachItem));
                }
            } while (lastEvaluatedKey != null);
        } else {
            queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, count, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaFriendsEntity.fromAttributeMap(eachItem));
            }
        }
        return result;
    }

    public static List<DnaFriendsEntity> findAllFriendsSortedByFriendScoresInDescOrder(String dnaId, Token token) {
        logger.debug("findAllFriendsSortedByFriendScoresInDescOrder");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        Map<String, AttributeValue> lastEvaluatedKey = null;
        ArrayList<DnaFriendsEntity> result = new ArrayList<DnaFriendsEntity>();
        Condition hashKeyCondition = new Condition().withComparisonOperator(ComparisonOperator.EQ.toString()).withAttributeValueList(new AttributeValue[]{new AttributeValue().withS(dnaId)});
        HashMap<String, Condition> conditionMap = new HashMap<String, Condition>();
        conditionMap.put("ID", hashKeyCondition);
        do {
            Map<String, List<Map<String, AttributeValue>>> queryResult = DynamoCommon.querySortedBySecondIndex(finalTableName, conditionMap, 50, lastEvaluatedKey, LOCAL_SECONDARY_INDEX_ATTR_NAME, false, token);
            List<Map<String, AttributeValue>> itemsList = queryResult.get("QUERY_RESULT_KEY");
            List<Map<String, AttributeValue>> lastEvaluatedKeyList = queryResult.get("QUERY_LAST_EVALUATED_KEY");
            lastEvaluatedKey = lastEvaluatedKeyList.isEmpty() ? null : lastEvaluatedKeyList.get(0);
            for (Map<String, AttributeValue> eachItem : itemsList) {
                result.add(DnaFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return result;
    }

    @Deprecated
    public static List<DnaFriendsEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        ArrayList<DnaFriendsEntity> socialFriends = new ArrayList<DnaFriendsEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", RANGE_KEY_ATTR_NAME, LOCAL_SECONDARY_INDEX_ATTR_NAME, NAME_ATTR_NAME, GENDER_ATTR_NAME, LOCALE_ATTR_NAME, EMAIL_ATTR_NAME, PICTURE_ATTR_NAME, TIME_WHEN_DNA_ACCOUNT_WAS_CREATED_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(DnaFriendsEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<DnaFriendsEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(DnaFriendsEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (DnaFriendsEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getDnaId()));
            key.put(RANGE_KEY_ATTR_NAME, new AttributeValue().withS(eachItem.getFriendId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }

    public String toString() {
        return "DnaFriendsEntity{dnaId='" + this.dnaId + '\'' + ", friendId='" + this.friendId + '\'' + ", scores=" + this.scores + ", name='" + this.name + '\'' + ", gender='" + this.gender + '\'' + ", locale='" + this.locale + '\'' + ", email='" + this.email + '\'' + ", pictureUrl='" + this.pictureUrl + '\'' + ", timeWhenDnaAccountWasCreated=" + this.timeWhenDnaAccountWasCreated + '}';
    }
}

