/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.ids.bucket")
public class DnaAccountIDBucketEntity {
    private static final Logger logger = LoggerFactory.getLogger(DnaAccountIDBucketEntity.class);
    private String dnaAccountId;

    public DnaAccountIDBucketEntity(String dnaAccountId) {
        this.dnaAccountId = dnaAccountId;
    }

    public String getDnaAccountId() {
        return this.dnaAccountId;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.dnaAccountId));
        return map;
    }

    public static DnaAccountIDBucketEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String dnaAccountId = map.get("ID").getS();
        return new DnaAccountIDBucketEntity(dnaAccountId);
    }

    public static void addToBucket(String dnaAccountId, Token token) {
        logger.info("addToBucket : dnaAccountId " + dnaAccountId);
        String finalTableName = Dynamo.getFinalTableName(DnaAccountIDBucketEntity.class);
        DnaAccountIDBucketEntity dnaAccountIDBucketEntity = new DnaAccountIDBucketEntity(dnaAccountId);
        Map<String, AttributeValue> entity = dnaAccountIDBucketEntity.toAttributeMap();
        DynamoCommon.putItem(finalTableName, entity, token);
    }

    @Deprecated
    public static List<DnaAccountIDBucketEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(DnaAccountIDBucketEntity.class);
        ArrayList<DnaAccountIDBucketEntity> dnaAccountIDBucketEntities = new ArrayList<DnaAccountIDBucketEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID"}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                dnaAccountIDBucketEntities.add(DnaAccountIDBucketEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return dnaAccountIDBucketEntities;
    }

    public static void deleteItems(List<DnaAccountIDBucketEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(DnaAccountIDBucketEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (DnaAccountIDBucketEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.dnaAccountId));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }
}

