/*
 * Decompiled with CFR 0.152.
 */
package db.model;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.google.common.collect.Lists;
import db.annotation.DynamoEntity;
import db.dynamo.manage.Dynamo;
import db.dynamo.manage.DynamoCommon;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamoEntity(tableName="dna.counters")
public class CounterEntity {
    private static final Logger logger = LoggerFactory.getLogger(CounterEntity.class);
    public static final String VALUE_ATTR_NAME = "VALUE";
    private String counterId;
    private Long value;

    public CounterEntity(String counterId, Long value) {
        this.counterId = counterId;
        this.value = value;
    }

    public String getCounterId() {
        return this.counterId;
    }

    public Long getValue() {
        return this.value;
    }

    public Map<String, AttributeValue> toAttributeMap() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put("ID", new AttributeValue().withS(this.counterId));
        if (this.value != null) {
            map.put(VALUE_ATTR_NAME, new AttributeValue().withN(this.value.toString()));
        }
        return map;
    }

    public static CounterEntity fromAttributeMap(Map<String, AttributeValue> map) {
        String counterId = map.get("ID").getS();
        Long value = map.get(VALUE_ATTR_NAME) != null ? Long.valueOf(map.get(VALUE_ATTR_NAME).getN()) : null;
        return new CounterEntity(counterId, value);
    }

    public static Long current(String counterName, String dnaId, Token token) {
        logger.info("current");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        String counterId = counterName.concat("-").concat(dnaId);
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(counterId));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, keyMap, token);
        if (item == null) {
            return null;
        }
        return CounterEntity.fromAttributeMap(item).getValue();
    }

    public static Long currentGlobalCounter(String counterName, Token token) {
        logger.info("currentGlobalCounter");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(counterName));
        Map<String, AttributeValue> item = DynamoCommon.fetchItem(finalTableName, keyMap, token);
        if (item == null) {
            return null;
        }
        return CounterEntity.fromAttributeMap(item).getValue();
    }

    public static Long next(String counterName, String dnaId, Token token) {
        logger.info("next");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        String counterId = counterName.concat("-").concat(dnaId);
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(counterId));
        HashMap<String, AttributeValue> updateAttrMap = new HashMap<String, AttributeValue>();
        updateAttrMap.put(VALUE_ATTR_NAME, new AttributeValue().withN("1"));
        AttributeAction action = AttributeAction.ADD;
        Map<String, AttributeValue> item = DynamoCommon.updateSetAttributes(finalTableName, keyMap, updateAttrMap, action, token);
        if (item != null) {
            CounterEntity entity = CounterEntity.fromAttributeMap(item);
            return entity.value;
        }
        return null;
    }

    public static Long nextGlobalCounter(String counterName, Token token) {
        logger.info("nextGlobalCounter");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put("ID", new AttributeValue().withS(counterName));
        HashMap<String, AttributeValue> updateAttrMap = new HashMap<String, AttributeValue>();
        updateAttrMap.put(VALUE_ATTR_NAME, new AttributeValue().withN("1"));
        AttributeAction action = AttributeAction.ADD;
        Map<String, AttributeValue> item = DynamoCommon.updateSetAttributes(finalTableName, keyMap, updateAttrMap, action, token);
        if (item != null) {
            CounterEntity entity = CounterEntity.fromAttributeMap(item);
            return entity.value;
        }
        return null;
    }

    @Deprecated
    public static List<CounterEntity> fetchThemAll(Token token) {
        logger.debug("fetchThemAll");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        ArrayList<CounterEntity> socialFriends = new ArrayList<CounterEntity>();
        int howMuch = 50;
        Map<String, AttributeValue> lastEvaluatedKey = null;
        do {
            Map<String, List<Map<String, AttributeValue>>> map = DynamoCommon.scanTable(finalTableName, Lists.newArrayList((Object[])new String[]{"ID", VALUE_ATTR_NAME}), howMuch, lastEvaluatedKey, token);
            List<Map<String, AttributeValue>> itemList = map.get("SCAN_RESULT_KEY");
            lastEvaluatedKey = !map.get("SCAN_LAST_EVALUATED_KEY").isEmpty() ? map.get("SCAN_LAST_EVALUATED_KEY").get(0) : null;
            for (Map<String, AttributeValue> eachItem : itemList) {
                socialFriends.add(CounterEntity.fromAttributeMap(eachItem));
            }
        } while (lastEvaluatedKey != null);
        return socialFriends;
    }

    public static void deleteItems(List<CounterEntity> itemList, Token token) {
        logger.debug("deleteItems");
        String finalTableName = Dynamo.getFinalTableName(CounterEntity.class);
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, AttributeValue>>();
        int counter = 0;
        for (CounterEntity eachItem : itemList) {
            HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
            key.put("ID", new AttributeValue().withS(eachItem.getCounterId()));
            keys.add(key);
            if (++counter < 24) continue;
            DynamoCommon.batchDelete(finalTableName, keys, token);
            counter = 0;
            keys = new ArrayList();
        }
        if (counter > 0) {
            DynamoCommon.batchDelete(finalTableName, keys, token);
        }
    }
}

