/*
 * Decompiled with CFR 0.152.
 */
package db.dynamo.manage;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import db.dynamo.manage.Dynamo;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoCommon {
    private static final Logger logger = LoggerFactory.getLogger(Dynamo.class);

    private static String printKeyMap(Map<String, AttributeValue> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (String eachKey : map.keySet()) {
            stringBuilder.append(eachKey);
            stringBuilder.append(" - ");
            AttributeValue value = map.get(eachKey);
            stringBuilder.append(value.getS());
            stringBuilder.append(" | ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String printKeyList(List<String> keys) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String eachKey : keys) {
            stringBuilder.append(eachKey);
            stringBuilder.append(" | ");
        }
        return stringBuilder.toString();
    }

    public static Map<String, AttributeValue> updateSetAttributes(String finalTableName, Map<String, AttributeValue> key, Map<String, AttributeValue> attributeValueMap, AttributeAction attributeAction, Token token) {
        Map result = null;
        try {
            logger.debug("Update set attributes into " + finalTableName + " with id : " + key.get("ID").getS());
            HashMap<String, AttributeValueUpdate> updateAttrMap = new HashMap<String, AttributeValueUpdate>();
            for (String eachAttributeName : attributeValueMap.keySet()) {
                AttributeValue attributeValue = attributeValueMap.get(eachAttributeName);
                AttributeValueUpdate setUpdate = new AttributeValueUpdate().withAction(attributeAction).withValue(attributeValue);
                updateAttrMap.put(eachAttributeName, setUpdate);
            }
            ReturnValue returnValue = ReturnValue.ALL_NEW;
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(finalTableName).withKey(key).withAttributeUpdates(updateAttrMap).withReturnValues(returnValue);
            UpdateItemResult updateItemResult = Dynamo.getDynamoDBClient().updateItem(updateItemRequest);
            result = updateItemResult.getAttributes();
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during updateSetAttribute", throwable, token);
        }
        return result;
    }

    public static Map<String, AttributeValue> updateMultipleAttributes(String finalTableName, Map<String, AttributeValue> key, Map<String, AttributeValue> attributeValueMap, Token token) {
        Map result = null;
        try {
            logger.debug("Update multiple attributes into " + finalTableName + " with id : " + key.get("ID").getS());
            HashMap<String, AttributeValueUpdate> updateAttrMap = new HashMap<String, AttributeValueUpdate>();
            for (String eachAttributeName : attributeValueMap.keySet()) {
                AttributeValueUpdate attributeValueUpdate;
                if (attributeValueMap.get(eachAttributeName) != null) {
                    attributeValueUpdate = new AttributeValueUpdate().withValue(attributeValueMap.get(eachAttributeName));
                    updateAttrMap.put(eachAttributeName, attributeValueUpdate);
                    continue;
                }
                attributeValueUpdate = new AttributeValueUpdate().withAction(AttributeAction.DELETE);
                updateAttrMap.put(eachAttributeName, attributeValueUpdate);
            }
            ReturnValue returnValue = ReturnValue.ALL_NEW;
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(finalTableName).withKey(key).withAttributeUpdates(updateAttrMap).withReturnValues(returnValue);
            UpdateItemResult updateItemResult = Dynamo.getDynamoDBClient().updateItem(updateItemRequest);
            result = updateItemResult.getAttributes();
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during updateMultipleAttributes", throwable, token);
        }
        return result;
    }

    public static void putItem(String finalTableName, Map<String, AttributeValue> valueMap, Token token) {
        try {
            logger.debug("Put item into " + finalTableName + " with id : " + valueMap.get("ID").getS());
            PutItemRequest putItemRequest = new PutItemRequest().withTableName(finalTableName).withItem(valueMap);
            Dynamo.getDynamoDBClient().putItem(putItemRequest);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during putItem", throwable, token);
        }
    }

    public static Map<String, AttributeValue> fetchItem(String finalTableName, Map<String, AttributeValue> key, Token token) {
        Map result = null;
        try {
            logger.debug("Fetch item from " + finalTableName + " with key : " + DynamoCommon.printKeyMap(key));
            GetItemRequest getItemRequest = new GetItemRequest().withTableName(finalTableName).withKey(key);
            GetItemResult getItemResult = Dynamo.getDynamoDBClient().getItem(getItemRequest);
            result = getItemResult.getItem();
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during fetchItem", throwable, token);
        }
        return result;
    }

    public static void deleteItem(String finalTableName, Map<String, AttributeValue> key, Token token) {
        try {
            logger.debug("deleteItem item from " + finalTableName + " with key : " + DynamoCommon.printKeyMap(key));
            DeleteItemRequest deleteItemRequest = new DeleteItemRequest().withTableName(finalTableName).withKey(key);
            DeleteItemResult result = Dynamo.getDynamoDBClient().deleteItem(deleteItemRequest);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during deleteItem", throwable, token);
        }
    }

    public static Map<String, List<Map<String, AttributeValue>>> scanTable(String finalTableName, List<String> attributeToGetList, int howMuch, Map<String, AttributeValue> lastEvaluatedKey, Token token) {
        HashMap<String, List<Map<String, AttributeValue>>> result = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map> itemsList = new ArrayList<Map>();
        ArrayList<Map> lastEvaluatedKeyList = new ArrayList<Map>();
        result.put("SCAN_RESULT_KEY", itemsList);
        result.put("SCAN_LAST_EVALUATED_KEY", lastEvaluatedKeyList);
        try {
            logger.debug("scanTable : " + finalTableName + " to fetchById keys : " + DynamoCommon.printKeyList(attributeToGetList));
            ScanRequest scanRequest = new ScanRequest().withTableName(finalTableName).withAttributesToGet(attributeToGetList).withExclusiveStartKey(lastEvaluatedKey).withLimit(Integer.valueOf(howMuch));
            ScanResult scanResult = Dynamo.getDynamoDBClient().scan(scanRequest);
            if (scanResult.getLastEvaluatedKey() != null) {
                lastEvaluatedKeyList.add(scanResult.getLastEvaluatedKey());
            }
            for (Map eachMap : scanResult.getItems()) {
                itemsList.add(eachMap);
            }
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during scanTable", throwable, token);
        }
        return result;
    }

    public static Map<String, List<Map<String, AttributeValue>>> scanTableBySegments(String finalTableName, List<String> attributeToGetList, int howMuch, Map<String, AttributeValue> lastEvaluatedKey, Integer segmentNumber, Integer totalSegments, Token token) {
        HashMap<String, List<Map<String, AttributeValue>>> result = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList<Map> itemsList = new ArrayList<Map>();
        ArrayList<Map> lastEvaluatedKeyList = new ArrayList<Map>();
        result.put("SCAN_RESULT_KEY", itemsList);
        result.put("SCAN_LAST_EVALUATED_KEY", lastEvaluatedKeyList);
        try {
            logger.debug("scanTableBySegments : " + finalTableName + " segment : " + segmentNumber + " total segment : " + totalSegments);
            ScanRequest scanRequest = new ScanRequest().withTableName(finalTableName).withSegment(segmentNumber).withTotalSegments(totalSegments).withAttributesToGet(attributeToGetList).withExclusiveStartKey(lastEvaluatedKey).withLimit(Integer.valueOf(howMuch));
            ScanResult scanResult = Dynamo.getDynamoDBClient().scan(scanRequest);
            if (scanResult.getLastEvaluatedKey() != null) {
                lastEvaluatedKeyList.add(scanResult.getLastEvaluatedKey());
            }
            for (Map eachMap : scanResult.getItems()) {
                itemsList.add(eachMap);
            }
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during scanTableBySegments", throwable, token);
        }
        return result;
    }

    public static Map<String, List<Map<String, AttributeValue>>> query(String finalTableName, Map<String, Condition> queryCondition, int limit, Map<String, AttributeValue> lastEvaluatedKey, boolean useNaturalOrder, Token token) {
        HashMap<String, List<Map<String, AttributeValue>>> result = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList itemsList = new ArrayList();
        ArrayList<Map> lastEvaluatedKeyList = new ArrayList<Map>();
        result.put("QUERY_RESULT_KEY", itemsList);
        result.put("QUERY_LAST_EVALUATED_KEY", lastEvaluatedKeyList);
        try {
            logger.debug("query item from " + finalTableName);
            QueryRequest queryRequest = new QueryRequest().withTableName(finalTableName).withKeyConditions(queryCondition).withLimit(Integer.valueOf(limit)).withScanIndexForward(Boolean.valueOf(useNaturalOrder)).withExclusiveStartKey(lastEvaluatedKey);
            QueryResult queryResult = Dynamo.getDynamoDBClient().query(queryRequest);
            itemsList.addAll(queryResult.getItems());
            Map lastEvaluated = queryResult.getLastEvaluatedKey();
            if (lastEvaluated != null) {
                lastEvaluatedKeyList.add(lastEvaluated);
            }
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during query", throwable, token);
        }
        return result;
    }

    public static Map<String, List<Map<String, AttributeValue>>> querySortedBySecondIndex(String finalTableName, Map<String, Condition> queryCondition, int limit, Map<String, AttributeValue> lastEvaluatedKey, String secondIndexName, boolean useNaturalOrder, Token token) {
        HashMap<String, List<Map<String, AttributeValue>>> result = new HashMap<String, List<Map<String, AttributeValue>>>();
        ArrayList itemsList = new ArrayList();
        ArrayList<Map> lastEvaluatedKeyList = new ArrayList<Map>();
        result.put("QUERY_RESULT_KEY", itemsList);
        result.put("QUERY_LAST_EVALUATED_KEY", lastEvaluatedKeyList);
        try {
            logger.debug("query item from " + finalTableName);
            QueryRequest queryRequest = new QueryRequest().withTableName(finalTableName).withKeyConditions(queryCondition).withLimit(Integer.valueOf(limit)).withExclusiveStartKey(lastEvaluatedKey).withScanIndexForward(Boolean.valueOf(useNaturalOrder)).withIndexName(secondIndexName);
            QueryResult queryResult = Dynamo.getDynamoDBClient().query(queryRequest);
            itemsList.addAll(queryResult.getItems());
            Map lastEvaluated = queryResult.getLastEvaluatedKey();
            if (lastEvaluated != null) {
                lastEvaluatedKeyList.add(lastEvaluated);
            }
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during query", throwable, token);
        }
        return result;
    }

    public static void batchDelete(Map<String, List<Map<String, AttributeValue>>> tableKeyMap, Token token) {
        try {
            BatchWriteItemResult batchResult;
            logger.debug("batchDelete item from different tabled");
            int allItemsCounter = 0;
            for (String eachTable : tableKeyMap.keySet()) {
                allItemsCounter += tableKeyMap.get(eachTable).size();
            }
            if (allItemsCounter > 25) {
                throw new IllegalArgumentException("Too much items in batchDelete request");
            }
            Map<String, ArrayList<Object>> writeRequests = new HashMap();
            for (String eachTable : tableKeyMap.keySet()) {
                ArrayList<WriteRequest> requestList = new ArrayList<WriteRequest>();
                writeRequests.put(eachTable, requestList);
                for (Map<String, AttributeValue> eachKeyMap : tableKeyMap.get(eachTable)) {
                    WriteRequest deleteRequest = new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(eachKeyMap));
                    requestList.add(deleteRequest);
                }
            }
            do {
                BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest().withRequestItems(writeRequests);
                batchResult = Dynamo.getDynamoDBClient().batchWriteItem(batchWriteItemRequest);
                writeRequests = batchResult.getUnprocessedItems();
            } while (batchResult.getUnprocessedItems().size() > 0);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during batchDelete", throwable, token);
        }
    }

    public static void batchDelete(String finalTableName, List<Map<String, AttributeValue>> keyList, Token token) {
        try {
            BatchWriteItemResult batchResult;
            logger.debug("batchDelete item from " + finalTableName + " with keyList : " + keyList.size());
            if (keyList.size() > 25) {
                throw new IllegalArgumentException("Too much ids in batchDelete request");
            }
            Map<String, ArrayList<Object>> writeRequests = new HashMap();
            ArrayList<WriteRequest> requestList = new ArrayList<WriteRequest>();
            writeRequests.put(finalTableName, requestList);
            for (Map<String, AttributeValue> eachKeyMap : keyList) {
                WriteRequest deleteRequest = new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(eachKeyMap));
                requestList.add(deleteRequest);
            }
            do {
                BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest().withRequestItems(writeRequests);
                batchResult = Dynamo.getDynamoDBClient().batchWriteItem(batchWriteItemRequest);
                writeRequests = batchResult.getUnprocessedItems();
            } while (batchResult.getUnprocessedItems().size() > 0);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during batchDelete", throwable, token);
        }
    }

    public static Map<String, List<Map<String, AttributeValue>>> batchGet(Map<String, List<Map<String, AttributeValue>>> tableKeyMap, Token token) {
        logger.debug("batchGet");
        int allItemsCounter = 0;
        for (String eachTable : tableKeyMap.keySet()) {
            allItemsCounter += tableKeyMap.get(eachTable).size();
        }
        if (allItemsCounter > 25) {
            throw new IllegalArgumentException("Too much items in batchGet request");
        }
        HashMap<String, List<Map<String, AttributeValue>>> result = new HashMap<String, List<Map<String, AttributeValue>>>();
        try {
            Map<String, Object> requestItems = new HashMap<String, KeysAndAttributes>();
            for (String eachTableName : tableKeyMap.keySet()) {
                List<Map<String, AttributeValue>> tableKeys = tableKeyMap.get(eachTableName);
                requestItems.put(eachTableName, new KeysAndAttributes().withKeys(tableKeys));
            }
            BatchGetItemResult batchGetItemResult = null;
            do {
                BatchGetItemRequest request = new BatchGetItemRequest().withRequestItems(requestItems);
                batchGetItemResult = Dynamo.getDynamoDBClient().batchGetItem(request);
                for (String eachTableName : batchGetItemResult.getResponses().keySet()) {
                    List responseFromEachTable = (List)batchGetItemResult.getResponses().get(eachTableName);
                    List listFromTheResult = (List)result.get(eachTableName);
                    if (listFromTheResult == null) {
                        result.put(eachTableName, responseFromEachTable);
                        continue;
                    }
                    listFromTheResult.addAll(responseFromEachTable);
                }
                requestItems = batchGetItemResult.getUnprocessedKeys();
            } while (batchGetItemResult.getUnprocessedKeys().size() > 0);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during batchGet", throwable, token);
        }
        return result;
    }

    public static void batchWrite(Map<String, List<Map<String, AttributeValue>>> itemsMap, Token token) {
        logger.debug("batchWrite");
        int allItemsCounter = 0;
        for (String eachTable : itemsMap.keySet()) {
            allItemsCounter += itemsMap.get(eachTable).size();
        }
        if (allItemsCounter > 25) {
            throw new IllegalArgumentException("Too much items in batchWrite request");
        }
        try {
            Map<String, ArrayList<Object>> requestItems = new HashMap();
            for (String eachFinalTableName : itemsMap.keySet()) {
                ArrayList<WriteRequest> writeRequestList = new ArrayList<WriteRequest>();
                requestItems.put(eachFinalTableName, writeRequestList);
                for (Map<String, AttributeValue> eachItem : itemsMap.get(eachFinalTableName)) {
                    writeRequestList.add(new WriteRequest().withPutRequest(new PutRequest().withItem(eachItem)));
                }
            }
            BatchWriteItemResult result = null;
            BatchWriteItemRequest batchWriteItemRequest = new BatchWriteItemRequest();
            do {
                batchWriteItemRequest.withRequestItems(requestItems);
                result = Dynamo.getDynamoDBClient().batchWriteItem(batchWriteItemRequest);
                requestItems = result.getUnprocessedItems();
            } while (result.getUnprocessedItems().size() > 0);
        }
        catch (Throwable throwable) {
            Dynamo.throwServiceException("Error during batchWrite", throwable, token);
        }
    }
}

