/*
 * Decompiled with CFR 0.152.
 */
package db.dynamo.manage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import db.annotation.DynamoEntity;
import db.dynamo.manage.conf.TableProperties;
import exceptions.ServiceException;
import identity.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dynamo {
    private static final Logger logger = LoggerFactory.getLogger(Dynamo.class);
    private static AmazonDynamoDBClient dynamoDB;
    private static String databaseName;
    private static List<TableProperties> confTableProperties;
    private static Map<String, Map<String, Long>> currentTablePropertieMap;
    private static Map<String, String> tableNameToFinalTableNameMap;
    private static Map<String, String> tableNameToRangeKeyNameMap;

    public static <T> void addEntityClass(Class<T> clazz) {
        logger.info("Add dynamo entity class : " + clazz.getName());
        Dynamo.isInitialized();
        if (clazz.getAnnotation(DynamoEntity.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the dynamo entity", null);
        }
        String tableName = clazz.getAnnotation(DynamoEntity.class).tableName();
        String finalTableName = databaseName + "-" + tableName;
        tableNameToFinalTableNameMap.put(tableName, finalTableName);
        String rangeKeyName = clazz.getAnnotation(DynamoEntity.class).rangeKeyName();
        tableNameToRangeKeyNameMap.put(tableName, rangeKeyName);
        String rangeKeyType = clazz.getAnnotation(DynamoEntity.class).rangeKeyType();
        String localIndexName = clazz.getAnnotation(DynamoEntity.class).localSecondaryIndex();
        String localIndexType = clazz.getAnnotation(DynamoEntity.class).localSecondaryIndexType();
        TableProperties currentTableProp = null;
        for (TableProperties eachProp : confTableProperties) {
            if (!eachProp.getTableName().equalsIgnoreCase(tableName)) continue;
            currentTableProp = eachProp;
            break;
        }
        if (currentTableProp == null) {
            throw new ServiceException("Dynamo has not been initialized correctly : there is no conf for table : " + finalTableName, null);
        }
        long initialReadCap = currentTableProp.getInitialReadCap();
        long initialWriteCap = currentTableProp.getInitialWriteCap();
        if (currentTablePropertieMap.get(finalTableName) != null) {
            long oldReadCap = currentTablePropertieMap.get(finalTableName).get("READ_CAP_NAME");
            long oldWriteCap = currentTablePropertieMap.get(finalTableName).get("WRITE_CAP_NAME");
            if (initialReadCap != oldReadCap || initialWriteCap != oldWriteCap) {
                logger.info("New values for throughput is better : update for table : " + finalTableName);
                Dynamo.updateTable(finalTableName, initialReadCap, initialWriteCap, oldReadCap, oldWriteCap);
            }
        } else if (currentTablePropertieMap.get(finalTableName) == null) {
            logger.info("Creating table with finalTableName : " + finalTableName);
            Dynamo.createTable(finalTableName, rangeKeyName, rangeKeyType, localIndexName, localIndexType, initialReadCap, initialWriteCap);
        }
    }

    public static <T> String getFinalTableName(Class<T> clazz) {
        Dynamo.isInitialized();
        if (clazz.getAnnotation(DynamoEntity.class) == null) {
            throw new ServiceException(clazz.getName() + " is not the dynamo entity", null);
        }
        String tableName = clazz.getAnnotation(DynamoEntity.class).tableName();
        String finalTableName = tableNameToFinalTableNameMap.get(tableName);
        if (finalTableName == null) {
            throw new ServiceException("Dynamo has not been initialized correctly", null);
        }
        return finalTableName;
    }

    public static void initialize(String nameOfDatabase, String regionName, int maxErrorRetry) {
        logger.info("Initialize Dynamo with databaseName : " + nameOfDatabase + " and region : " + regionName);
        try {
            ClientConfiguration configuration = new ClientConfiguration();
            configuration.setMaxErrorRetry(maxErrorRetry);
            dynamoDB = new AmazonDynamoDBClient((AWSCredentialsProvider)new ClasspathPropertiesFileCredentialsProvider(), configuration);
            Region region = Region.getRegion((Regions)Regions.valueOf((String)regionName));
            dynamoDB.setRegion(region);
            databaseName = nameOfDatabase;
        }
        catch (Throwable throwable) {
            throw new ServiceException("Dynamo has not been initialized correctly", throwable, null);
        }
        tableNameToFinalTableNameMap = new HashMap<String, String>();
        tableNameToRangeKeyNameMap = new HashMap<String, String>();
        currentTablePropertieMap = Dynamo.listTablesWithProperties();
        confTableProperties = TableProperties.findAllTablePropertiesForCurrentEnv(nameOfDatabase, Token.backGroundAccessToke());
    }

    public static void createTable(String finalTableName, String rangeKeyName, String rangeKeyType, String localSecondaryIndexName, String localSecondaryIndexType, long readCap, long writeCap) {
        Dynamo.isInitialized();
        logger.info("createTable() : table : " + finalTableName + " readCap : " + Long.toString(readCap) + " writeCap : " + Long.toString(writeCap) + " with local secondary index : " + localSecondaryIndexName);
        try {
            ArrayList<KeySchemaElement> keys = new ArrayList<KeySchemaElement>();
            ArrayList<AttributeDefinition> attributeDefinitionList = new ArrayList<AttributeDefinition>();
            KeySchemaElement keySchemaElement = new KeySchemaElement().withKeyType(KeyType.HASH).withAttributeName("ID");
            keys.add(keySchemaElement);
            AttributeDefinition attributeDefinition = new AttributeDefinition().withAttributeName("ID").withAttributeType(ScalarAttributeType.S);
            attributeDefinitionList.add(attributeDefinition);
            ArrayList<LocalSecondaryIndex> localSecondaryIndexes = null;
            if (!rangeKeyName.equals("WITHOUT_RANGE_KEY")) {
                KeySchemaElement rangeSchemaElement = new KeySchemaElement().withKeyType(KeyType.RANGE).withAttributeName(rangeKeyName);
                keys.add(rangeSchemaElement);
                ScalarAttributeType keyType = ScalarAttributeType.S;
                if (rangeKeyType.equals("RANGE_KEY_TYPE_NUMBER")) {
                    keyType = ScalarAttributeType.N;
                }
                AttributeDefinition rangeAttributeDefinition = new AttributeDefinition().withAttributeName(rangeKeyName).withAttributeType(keyType);
                attributeDefinitionList.add(rangeAttributeDefinition);
                if (!localSecondaryIndexName.equals("WITHOUT_LOCAL_SECONDARY_INDEX")) {
                    ScalarAttributeType indexType = ScalarAttributeType.S;
                    if (localSecondaryIndexType.equals("LOCAL_SECONDARY_INDEX_TYPE_NUMBER")) {
                        indexType = ScalarAttributeType.N;
                    }
                    AttributeDefinition localIndexDefinition = new AttributeDefinition().withAttributeName(localSecondaryIndexName).withAttributeType(indexType);
                    attributeDefinitionList.add(localIndexDefinition);
                    ArrayList<KeySchemaElement> indexKeySchema = new ArrayList<KeySchemaElement>();
                    indexKeySchema.add(keySchemaElement);
                    KeySchemaElement localIndex = new KeySchemaElement().withAttributeName(localSecondaryIndexName).withKeyType(KeyType.RANGE);
                    indexKeySchema.add(localIndex);
                    Projection projection = new Projection().withProjectionType(ProjectionType.ALL);
                    LocalSecondaryIndex localSecondaryIndex = new LocalSecondaryIndex().withIndexName(localSecondaryIndexName).withKeySchema(indexKeySchema).withProjection(projection);
                    localSecondaryIndexes = new ArrayList<LocalSecondaryIndex>();
                    localSecondaryIndexes.add(localSecondaryIndex);
                }
            }
            ProvisionedThroughput throughput = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(readCap)).withWriteCapacityUnits(Long.valueOf(writeCap));
            CreateTableRequest createTableRequest = null;
            createTableRequest = localSecondaryIndexes == null ? new CreateTableRequest().withTableName(finalTableName).withKeySchema(keys).withAttributeDefinitions(attributeDefinitionList).withProvisionedThroughput(throughput) : new CreateTableRequest().withTableName(finalTableName).withKeySchema(keys).withAttributeDefinitions(attributeDefinitionList).withProvisionedThroughput(throughput).withLocalSecondaryIndexes(localSecondaryIndexes);
            dynamoDB.createTable(createTableRequest).getTableDescription();
            Dynamo.waitForTableToBecomeAvailable(finalTableName);
        }
        catch (RuntimeException ex) {
            Dynamo.throwServiceException("Unable to create table", ex, null);
        }
    }

    public static void updateTable(String finalTableName, long readCap, long writeCap, long oldReadCap, long oldWriteCap) {
        Dynamo.isInitialized();
        long tmpReadCap = oldReadCap;
        long tmpWriteCap = oldWriteCap;
        do {
            tmpReadCap = 2L * tmpReadCap;
            tmpWriteCap = 2L * tmpWriteCap;
            if (tmpReadCap > readCap) {
                tmpReadCap = readCap;
            }
            if (tmpWriteCap > writeCap) {
                tmpWriteCap = writeCap;
            }
            logger.info("updateTable() : table : " + finalTableName + " : finalReadCap :" + readCap + " finalWriteCap : " + writeCap + " newReadCap : " + Long.toString(tmpReadCap) + " newWriteCap : " + Long.toString(tmpWriteCap));
            try {
                ProvisionedThroughput newThroughtput = new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(tmpReadCap)).withWriteCapacityUnits(Long.valueOf(tmpWriteCap));
                UpdateTableRequest updateTableRequest = new UpdateTableRequest().withTableName(finalTableName).withProvisionedThroughput(newThroughtput);
                TableDescription updateTableDescription = dynamoDB.updateTable(updateTableRequest).getTableDescription();
                Dynamo.waitForTableToBecomeAvailable(finalTableName);
            }
            catch (RuntimeException ex) {
                Dynamo.throwServiceException("Unable to update tables properties", ex, null);
            }
        } while (tmpReadCap < readCap || tmpWriteCap < writeCap);
    }

    public static void isInitialized() {
        if (dynamoDB == null || databaseName == null || databaseName.isEmpty() || tableNameToFinalTableNameMap == null) {
            throw new ServiceException("Dynamo has not been initialized correctly", null);
        }
    }

    public static Map<String, Map<String, Long>> listTablesWithProperties() {
        Dynamo.isInitialized();
        logger.info("listTablesWithProperties()");
        HashMap<String, Map<String, Long>> resultMap = new HashMap<String, Map<String, Long>>();
        try {
            String lastEvaluatedTable = null;
            do {
                ListTablesRequest listTablesRequest = new ListTablesRequest().withLimit(Integer.valueOf(10)).withExclusiveStartTableName(lastEvaluatedTable);
                ListTablesResult result = dynamoDB.listTables(listTablesRequest);
                lastEvaluatedTable = result.getLastEvaluatedTableName();
                for (String name : result.getTableNames()) {
                    DescribeTableRequest describeTableRequest = new DescribeTableRequest().withTableName(name);
                    TableDescription tableDescription = dynamoDB.describeTable(describeTableRequest).getTable();
                    Long readCap = tableDescription.getProvisionedThroughput().getReadCapacityUnits();
                    Long writeCap = tableDescription.getProvisionedThroughput().getWriteCapacityUnits();
                    HashMap<String, Long> capResult = new HashMap<String, Long>();
                    capResult.put("READ_CAP_NAME", readCap);
                    capResult.put("WRITE_CAP_NAME", writeCap);
                    resultMap.put(name, capResult);
                }
            } while (lastEvaluatedTable != null);
        }
        catch (RuntimeException ex) {
            Dynamo.throwServiceException("Unable to list tables properties", ex, null);
        }
        return resultMap;
    }

    private static void waitForTableToBecomeAvailable(String finalTableName) {
        Dynamo.isInitialized();
        logger.info("waitForTableToBecomeAvailable()");
        long endTime = System.currentTimeMillis() + 600000L;
        while (System.currentTimeMillis() < endTime) {
            try {
                DescribeTableRequest describeTableRequest = new DescribeTableRequest().withTableName(finalTableName);
                TableDescription tableDescription = dynamoDB.describeTable(describeTableRequest).getTable();
                String tableStatus = tableDescription.getTableStatus();
                logger.info("waitForTableToBecomeAvailable() : -- current  status : " + tableStatus);
                if (tableStatus.equalsIgnoreCase(TableStatus.ACTIVE.toString())) {
                    return;
                }
                try {
                    Thread.sleep(20000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (AmazonServiceException e) {
                if (e.getErrorCode().equalsIgnoreCase("ResourceNotFoundException")) continue;
                Dynamo.throwServiceException("Error during waiting ACTIVE status of table " + finalTableName, e, null);
            }
        }
    }

    public static AmazonDynamoDBClient getDynamoDBClient() {
        Dynamo.isInitialized();
        return dynamoDB;
    }

    public static void throwServiceException(String title, Throwable source, Token token) {
        if (source instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)source;
            StringBuilder errorBuilder = new StringBuilder(title);
            errorBuilder.append(" : ");
            errorBuilder.append("Caught an AmazonServiceException, which means your request made it ");
            errorBuilder.append("to AWS, but was rejected with an error response for some reason.");
            errorBuilder.append("Error Message:");
            errorBuilder.append(ase.getMessage());
            errorBuilder.append(" ");
            errorBuilder.append("HTTP Status Code:");
            errorBuilder.append(ase.getStatusCode());
            errorBuilder.append(" ");
            errorBuilder.append("AWS Error Code:");
            errorBuilder.append(ase.getErrorCode());
            errorBuilder.append(" ");
            errorBuilder.append("Error Type:");
            errorBuilder.append(ase.getErrorType());
            errorBuilder.append(" ");
            errorBuilder.append("Request ID:");
            errorBuilder.append(ase.getRequestId());
            throw new ServiceException(errorBuilder.toString(), (Throwable)ase, token != null ? token.getAccountId() : null);
        }
        if (source instanceof AmazonClientException) {
            AmazonClientException ace = (AmazonClientException)source;
            StringBuilder errorBuilder = new StringBuilder(title);
            errorBuilder.append(" : ");
            errorBuilder.append("aught an AmazonClientException, which means the client encountered ");
            errorBuilder.append("a serious internal problem while trying to communicate with AWS, ");
            errorBuilder.append("such as not being able to access the network.");
            errorBuilder.append("Error Message:");
            errorBuilder.append(ace.getMessage());
            throw new ServiceException(errorBuilder.toString(), (Throwable)ace, token != null ? token.getAccountId() : null);
        }
        throw new ServiceException("", source, null);
    }
}

