/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import db.model.fb.FacebookFormulaArgumentsEntity;
import db.model.fb.FacebookInfluenceEntity;
import db.model.fb.FacebookProfileMetaInfo;
import db.model.vk.VkontakteFormulaArgumentsEntity;
import db.model.vk.VkontakteInfluenceEntity;
import db.model.vk.VkontakteProfileMetaInfo;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworksScoreCalculator {
    private static final Logger logger = LoggerFactory.getLogger(NetworksScoreCalculator.class);

    public static FacebookInfluenceEntity calculateFbInfluence(FacebookProfileMetaInfo metaInfo, FacebookFormulaArgumentsEntity formulaArguments) {
        logger.debug("calculateFbInfluence : start");
        double numberOfFriends = metaInfo.getNumberOfFriends() < 1 ? formulaArguments.getFriendsInsteadZero() : (double)metaInfo.getNumberOfFriends().intValue();
        LogNormalDistribution friendLogNormalDistribution = new LogNormalDistribution(formulaArguments.getFriendsMean().doubleValue(), formulaArguments.getFriendsStandartDeviation().doubleValue());
        logger.debug("calculateFbInfluence : numberOfFriends : " + numberOfFriends);
        double numberOfSubscribers = metaInfo.getNumberOfSubscribers() < 1 ? formulaArguments.getSubscribersInsteadZero() : (double)metaInfo.getNumberOfSubscribers().intValue();
        LogNormalDistribution subscribersLogNormalDistribution = new LogNormalDistribution(formulaArguments.getSubscribersMean().doubleValue(), formulaArguments.getSubscribersStandartDeviation().doubleValue());
        logger.debug("calculateFbInfluence : numberOfSubscribers : " + numberOfSubscribers);
        double friendsCumulativeProbability = friendLogNormalDistribution.cumulativeProbability(numberOfFriends);
        double subscribersCumulativeProbability = subscribersLogNormalDistribution.cumulativeProbability(numberOfSubscribers);
        double breadthSubScore = formulaArguments.getKfBreadthSubScoreFriends() * friendsCumulativeProbability + formulaArguments.getKfBreadthSubScoreSubscribers() * subscribersCumulativeProbability;
        logger.debug("calculateFbInfluence : friendsCumulativeProbability : " + friendsCumulativeProbability);
        logger.debug("calculateFbInfluence : subscribersCumulativeProbability : " + subscribersCumulativeProbability);
        logger.debug("calculateFbInfluence : breadthSubScore : " + breadthSubScore);
        double numberOfPost = metaInfo.getNumberOfPost() < 1 ? formulaArguments.getPostsInsteadZero() : (double)metaInfo.getNumberOfPost().intValue();
        logger.debug("calculateFbInfluence : numberOfPost : " + numberOfPost);
        LogNormalDistribution numberOfPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getPostsMean().doubleValue(), formulaArguments.getPostsStandartDeviation().doubleValue());
        double activitySubScore = numberOfPostLogNormalDistribution.cumulativeProbability(numberOfPost);
        logger.debug("calculateFbInfluence : activityScore : " + activitySubScore);
        double othersCommentOnUserPost = metaInfo.getOthersCommentOnUserPost() < 1 ? formulaArguments.getOtherCommentsUserPostsInsteadZero() : (double)metaInfo.getOthersCommentOnUserPost().intValue();
        double othersLikesOnUserPost = metaInfo.getOthersLikesOnUserPost() < 1 ? formulaArguments.getOtherLikesUserPostsInsteadZero() : (double)metaInfo.getOthersLikesOnUserPost().intValue();
        double othersLikesOnUserComment = metaInfo.getOthersLikesOnUserComment() < 1 ? formulaArguments.getOtherLikesUsersCommentsInsteadZero() : (double)metaInfo.getOthersLikesOnUserComment().intValue();
        LogNormalDistribution othersCommentOnUserPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherCommentsOnUserPostMean().doubleValue(), formulaArguments.getOtherCommentsOnUserPostStandartDeviation().doubleValue());
        LogNormalDistribution othersLikesOnUserPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherLikesOnUserPostMean().doubleValue(), formulaArguments.getOtherLikesOnUserPostStandartDeviation().doubleValue());
        LogNormalDistribution othersLikesOnUserCommentLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherLikesOnUserCommentsMean().doubleValue(), formulaArguments.getOtherLikesOnUserCommentsStandartDeviation().doubleValue());
        logger.debug("calculateFbInfluence : othersLikesOnUserPost : " + othersLikesOnUserPost);
        logger.debug("calculateFbInfluence : othersCommentOnUserPost : " + othersCommentOnUserPost);
        logger.debug("calculateFbInfluence : othersLikesOnUserComment : " + othersLikesOnUserComment);
        double othersCommentOnUserPostCumulativeProbability = othersCommentOnUserPostLogNormalDistribution.cumulativeProbability(othersCommentOnUserPost);
        double othersLikesOnUserPostCumulativeProbability = othersLikesOnUserPostLogNormalDistribution.cumulativeProbability(othersLikesOnUserPost);
        double othersLikesOnUserCommentCumulativeProbability = othersLikesOnUserCommentLogNormalDistribution.cumulativeProbability(othersLikesOnUserComment);
        double authoritySubScore = formulaArguments.getKfAuthoritySubScoreOthersCommentOnUserPost() * othersCommentOnUserPostCumulativeProbability + formulaArguments.getKfAuthoritySubScoreOthersLikesOnUserPost() * othersLikesOnUserPostCumulativeProbability + formulaArguments.getKfAuthoritySubScoreOthersLikesOnUserComment() * othersLikesOnUserCommentCumulativeProbability;
        logger.debug("calculateFbInfluence : othersCommentOnUserPostCumulativeProbability : " + othersCommentOnUserPostCumulativeProbability);
        logger.debug("calculateFbInfluence : othersLikesOnUserPostCumulativeProbability : " + othersLikesOnUserPostCumulativeProbability);
        logger.debug("calculateFbInfluence : othersLikesOnUserCommentCumulativeProbability : " + othersLikesOnUserCommentCumulativeProbability);
        logger.debug("calculateFbInfluence : authoritySubScore : " + authoritySubScore);
        double dnaInfluence = formulaArguments.getKfFinalBreadthSubScore() * (breadthSubScore * 100.0) + formulaArguments.getKfFinalActivitySubScore() * (activitySubScore * 100.0) + formulaArguments.getKfFinalAuthoritySubScore() * (authoritySubScore * 100.0);
        logger.debug("calculateFbInfluence : Calculate dnaInfluence using : 0.3 * (breadthSubScore * 100) + 0.3 * (activitySubScore * 100) + 0.4 * (authoritySubScore * 100)");
        logger.debug("calculateFbInfluence : dnaInfluence : " + dnaInfluence);
        return new FacebookInfluenceEntity(metaInfo.getAccountId(), friendsCumulativeProbability, subscribersCumulativeProbability, breadthSubScore, activitySubScore, othersCommentOnUserPostCumulativeProbability, othersLikesOnUserPostCumulativeProbability, othersLikesOnUserCommentCumulativeProbability, authoritySubScore, dnaInfluence);
    }

    public static VkontakteInfluenceEntity calculateVkInfluence(VkontakteProfileMetaInfo metaInfo, VkontakteFormulaArgumentsEntity formulaArguments) {
        logger.debug("calculateVkInfluence : start");
        double numberOfFriends = metaInfo.getNumberOfFriends() < 1 ? formulaArguments.getFriendsInsteadZero() : (double)metaInfo.getNumberOfFriends().intValue();
        LogNormalDistribution friendLogNormalDistribution = new LogNormalDistribution(formulaArguments.getFriendsMean().doubleValue(), formulaArguments.getFriendsStandartDeviation().doubleValue());
        logger.debug("calculateVkInfluence : numberOfFriends : " + numberOfFriends);
        double numberOfSubscribers = metaInfo.getNumberOfSubscribers() < 1 ? formulaArguments.getSubscribersInsteadZero() : (double)metaInfo.getNumberOfSubscribers().intValue();
        LogNormalDistribution subscribersLogNormalDistribution = new LogNormalDistribution(formulaArguments.getSubscribersMean().doubleValue(), formulaArguments.getSubscribersStandartDeviation().doubleValue());
        logger.debug("calculateVkInfluence : numberOfSubscribers : " + numberOfSubscribers);
        double friendsCumulativeProbability = friendLogNormalDistribution.cumulativeProbability(numberOfFriends);
        double subscribersCumulativeProbability = subscribersLogNormalDistribution.cumulativeProbability(numberOfSubscribers);
        double breadthSubScore = formulaArguments.getKfBreadthSubScoreFriends() * friendsCumulativeProbability + formulaArguments.getKfBreadthSubScoreSubscribers() * subscribersCumulativeProbability;
        logger.debug("calculateVkInfluence : friendsCumulativeProbability : " + friendsCumulativeProbability);
        logger.debug("calculateVkInfluence : subscribersCumulativeProbability : " + subscribersCumulativeProbability);
        logger.debug("calculateVkInfluence : breadthSubScore : " + breadthSubScore);
        double numberOfPost = metaInfo.getNumberOfPost() < 1 ? formulaArguments.getPostsInsteadZero() : (double)metaInfo.getNumberOfPost().intValue();
        logger.debug("calculateVkInfluence : numberOfPost : " + numberOfPost);
        LogNormalDistribution numberOfPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getPostsMean().doubleValue(), formulaArguments.getPostsStandartDeviation().doubleValue());
        double activitySubScore = numberOfPostLogNormalDistribution.cumulativeProbability(numberOfPost);
        logger.debug("calculateVkInfluence : activityScore : " + activitySubScore);
        double othersCommentOnUserPost = metaInfo.getOthersCommentOnUserPost() < 1 ? formulaArguments.getOtherCommentsUserPostsInsteadZero() : (double)metaInfo.getOthersCommentOnUserPost().intValue();
        double othersLikesOnUserPost = metaInfo.getOthersLikesOnUserPost() < 1 ? formulaArguments.getOtherLikesUserPostsInsteadZero() : (double)metaInfo.getOthersLikesOnUserPost().intValue();
        double othersLikesOnUserComment = metaInfo.getOthersLikesOnUserComment() < 1 ? formulaArguments.getOtherLikesUsersCommentsInsteadZero() : (double)metaInfo.getOthersLikesOnUserComment().intValue();
        LogNormalDistribution othersCommentOnUserPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherCommentsOnUserPostMean().doubleValue(), formulaArguments.getOtherCommentsOnUserPostStandartDeviation().doubleValue());
        LogNormalDistribution othersLikesOnUserPostLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherLikesOnUserPostMean().doubleValue(), formulaArguments.getOtherLikesOnUserPostStandartDeviation().doubleValue());
        LogNormalDistribution othersLikesOnUserCommentLogNormalDistribution = new LogNormalDistribution(formulaArguments.getOtherLikesOnUserCommentsMean().doubleValue(), formulaArguments.getOtherLikesOnUserCommentsStandartDeviation().doubleValue());
        logger.debug("calculateVkInfluence : othersLikesOnUserPost : " + othersLikesOnUserPost);
        logger.debug("calculateVkInfluence : othersCommentOnUserPost : " + othersCommentOnUserPost);
        logger.debug("calculateVkInfluence : othersLikesOnUserComment : " + othersLikesOnUserComment);
        double othersCommentOnUserPostCumulativeProbability = othersCommentOnUserPostLogNormalDistribution.cumulativeProbability(othersCommentOnUserPost);
        double othersLikesOnUserPostCumulativeProbability = othersLikesOnUserPostLogNormalDistribution.cumulativeProbability(othersLikesOnUserPost);
        double othersLikesOnUserCommentCumulativeProbability = othersLikesOnUserCommentLogNormalDistribution.cumulativeProbability(othersLikesOnUserComment);
        double authoritySubScore = formulaArguments.getKfAuthoritySubScoreOthersCommentOnUserPost() * othersCommentOnUserPostCumulativeProbability + formulaArguments.getKfAuthoritySubScoreOthersLikesOnUserPost() * othersLikesOnUserPostCumulativeProbability + formulaArguments.getKfAuthoritySubScoreOthersLikesOnUserComment() * othersLikesOnUserCommentCumulativeProbability;
        logger.debug("calculateVkInfluence : othersCommentOnUserPostCumulativeProbability : " + othersCommentOnUserPostCumulativeProbability);
        logger.debug("calculateVkInfluence : othersLikesOnUserPostCumulativeProbability : " + othersLikesOnUserPostCumulativeProbability);
        logger.debug("calculateVkInfluence : othersLikesOnUserCommentCumulativeProbability : " + othersLikesOnUserCommentCumulativeProbability);
        logger.debug("calculateVkInfluence : authoritySubScore : " + authoritySubScore);
        double dnaInfluence = formulaArguments.getKfFinalBreadthSubScore() * (breadthSubScore * 100.0) + formulaArguments.getKfFinalActivitySubScore() * (activitySubScore * 100.0) + formulaArguments.getKfFinalAuthoritySubScore() * (authoritySubScore * 100.0);
        logger.debug("calculateVkInfluence : Calculate dnaInfluence using : 0.3 * (breadthSubScore * 100) + 0.3 * (activitySubScore * 100) + 0.4 * (authoritySubScore * 100)");
        logger.debug("calculateVkInfluence : dnaInfluence : " + dnaInfluence);
        return new VkontakteInfluenceEntity(metaInfo.getAccountId(), friendsCumulativeProbability, subscribersCumulativeProbability, breadthSubScore, activitySubScore, othersCommentOnUserPostCumulativeProbability, othersLikesOnUserPostCumulativeProbability, othersLikesOnUserCommentCumulativeProbability, authoritySubScore, dnaInfluence);
    }
}

