/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import constants.SocialNetworks;
import db.model.fb.FacebookInfluenceEntity;
import db.model.vk.VkontakteInfluenceEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaScoreCalculator {
    private static final Logger logger = LoggerFactory.getLogger(DnaScoreCalculator.class);
    private static final int RANGE = 100;
    private static final Map<String, Integer> networkOrder = new HashMap<String, Integer>();

    public static Double calculateDnaScores(List<Object> influenceList) {
        boolean enablePenalty;
        if (influenceList.isEmpty()) {
            return 0.0;
        }
        Double[] scoreArray = new Double[]{0.0, 0.0};
        double penalty = 1.0;
        boolean bl = enablePenalty = influenceList.size() <= 1;
        if (enablePenalty) {
            penalty = 0.25;
        }
        logger.debug("penalty will be : " + penalty);
        for (Object eachInflu : influenceList) {
            Double vkontakteScore;
            if (eachInflu instanceof FacebookInfluenceEntity) {
                Double facebookScore;
                int facebookIndex = networkOrder.get(SocialNetworks.Facebook.name());
                scoreArray[facebookIndex] = facebookScore = ((FacebookInfluenceEntity)eachInflu).getDnaInfluence();
                continue;
            }
            if (!(eachInflu instanceof VkontakteInfluenceEntity)) continue;
            int vkontakteIndex = networkOrder.get(SocialNetworks.Vkontakte.name());
            scoreArray[vkontakteIndex] = vkontakteScore = ((VkontakteInfluenceEntity)eachInflu).getDnaInfluence();
        }
        double finalScore = 0.0;
        for (int i = 0; i < scoreArray.length; ++i) {
            if (i == 0) {
                finalScore += scoreArray[i].doubleValue();
                continue;
            }
            finalScore += (100.0 - finalScore) / 100.0 * scoreArray[i];
        }
        if (penalty == 1.0) {
            return finalScore;
        }
        return (1.0 - penalty) * finalScore;
    }

    static {
        networkOrder.put(SocialNetworks.Vkontakte.name(), 0);
        networkOrder.put(SocialNetworks.Facebook.name(), 1);
    }
}

