/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.unity.yamlParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.yaml.snakeyaml.Yaml;
import ru.quadcom.unity.scheme.UnityResourceId;
import ru.quadcom.unity.yamlParser.DeserializationHelper;
import ru.quadcom.unity.yamlParser.YamlDocument;

public class YamlLoaderHelper {
    public static List<YamlDocument> loadYamlFromResource(String resourcePath) throws IOException {
        InputStream prefabIS = ClassLoader.getSystemResourceAsStream(resourcePath);
        InputStream metaIS = ClassLoader.getSystemResourceAsStream(resourcePath + ".meta");
        if (prefabIS == null || metaIS == null) {
            return new ArrayList<YamlDocument>();
        }
        return YamlLoaderHelper.loadYamlDocuments(resourcePath, prefabIS, metaIS);
    }

    /*
     * Exception decompiling
     */
    public static List<YamlDocument> loadYamlFromFile(String filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<YamlDocument> loadYamlDocuments(String filePath, InputStream prefabIS, InputStream metaIS) throws IOException {
        UUID prefabGuid = YamlLoaderHelper.loadPrefabGUID(metaIS);
        if (prefabGuid == null) {
            return new ArrayList<YamlDocument>();
        }
        BufferedReader ir = new BufferedReader(new InputStreamReader(prefabIS));
        String currLine = null;
        ir.readLine();
        ir.readLine();
        ArrayList<YamlDocument> props = new ArrayList<YamlDocument>();
        StringBuffer sb = new StringBuffer();
        UnityResourceId unityObjId = null;
        while ((currLine = ir.readLine()) != null) {
            if (currLine.startsWith("---")) {
                if (sb.length() > 0) {
                    YamlLoaderHelper.parseYamlDocument(props, sb, unityObjId, filePath);
                    sb = new StringBuffer();
                }
                unityObjId = YamlLoaderHelper.parseHeaderLine(prefabGuid, currLine);
                continue;
            }
            sb.append(currLine).append("\n");
        }
        return props;
    }

    private static UnityResourceId parseHeaderLine(UUID prefabId, String currLine) {
        int ampIndex = currLine.indexOf(38);
        if (ampIndex > 0) {
            String subLine = currLine.substring(ampIndex + 1);
            int objId = Integer.parseInt(subLine);
            return new UnityResourceId(prefabId, objId);
        }
        return null;
    }

    private static UUID loadPrefabGUID(InputStream inputStream) {
        Yaml yaml = new Yaml();
        Properties properties = (Properties)yaml.loadAs(inputStream, Properties.class);
        if (properties == null || properties.get("guid") == null) {
            return null;
        }
        return DeserializationHelper.unity3dToJavaUUID((String)properties.get("guid"));
    }

    private static void parseYamlDocument(List<YamlDocument> props, StringBuffer sb, UnityResourceId prefabGuid, String fileURL) {
        Yaml yaml = new Yaml();
        Properties properties = (Properties)yaml.loadAs(sb.toString(), Properties.class);
        if (properties != null) {
            props.add(new YamlDocument(fileURL, prefabGuid, properties));
        }
    }
}

