/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.unity.yamlParser;

import com.google.common.primitives.Longs;
import java.util.UUID;

public class DeserializationHelper {
    public static UUID unity3dToJavaUUID(String guidStr) {
        int i;
        byte[] bytes = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            bytes[i2] = (byte)Integer.parseInt(guidStr.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        DeserializationHelper.bytesReverse(bytes, 0, 4);
        DeserializationHelper.bytesReverse(bytes, 4, 2);
        DeserializationHelper.bytesReverse(bytes, 6, 2);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static String javaUUIDToUnityString(UUID javaUUID) {
        byte[] bytes = new byte[16];
        System.arraycopy(Longs.toByteArray((long)javaUUID.getMostSignificantBits()), 0, bytes, 0, 8);
        System.arraycopy(Longs.toByteArray((long)javaUUID.getLeastSignificantBits()), 0, bytes, 8, 8);
        DeserializationHelper.bytesReverse(bytes, 6, 2);
        DeserializationHelper.bytesReverse(bytes, 4, 2);
        DeserializationHelper.bytesReverse(bytes, 0, 4);
        StringBuilder stringBuffer = new StringBuilder();
        for (byte b : bytes) {
            stringBuffer.append(String.format("%02x", b & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static void bytesReverse(byte[] bytes, int offset, int size) {
        for (int i = 0; i < size / 2; ++i) {
            byte t = bytes[offset + i];
            bytes[offset + i] = bytes[offset + size - 1 - i];
            bytes[offset + size - 1 - i] = t;
        }
    }
}

