/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.unity.scheme;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import ru.quadcom.unity.scheme.ComponentId;
import ru.quadcom.unity.scheme.Transform;
import ru.quadcom.unity.scheme.UnityObject;

public class GameObject
extends UnityObject {
    private ComponentId[] m_Component;
    private String m_Name;

    public List<UnityObject> getComponents() {
        ArrayList<UnityObject> components = new ArrayList<UnityObject>();
        for (ComponentId componentId : this.m_Component) {
            UnityObject mb = componentId.getComponentAs(this.getObjectsRoot(), UnityObject.class);
            if (mb == null) continue;
            components.add(mb);
        }
        return components;
    }

    public <T extends UnityObject> T getComponent(Class<T> tClass) {
        for (UnityObject unityObject : this.getComponents()) {
            if (!tClass.isInstance(unityObject)) continue;
            return (T)unityObject;
        }
        return null;
    }

    public <T extends UnityObject> ImmutableList<T> getComponents(Class<T> tClass) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (UnityObject unityObject : this.getComponents()) {
            if (!tClass.isInstance(unityObject)) continue;
            resultBuilder.add((Object)unityObject);
        }
        return resultBuilder.build();
    }

    public Transform getTransform() {
        return this.getComponent(Transform.class);
    }

    public ComponentId[] getM_Component() {
        return this.m_Component;
    }

    public void setM_Component(ComponentId[] m_Component) {
        this.m_Component = m_Component;
    }

    public String getM_Name() {
        return this.m_Name;
    }

    public void setM_Name(String m_Name) {
        this.m_Name = m_Name;
    }
}

