/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.unity.impl;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.unity.impl.UnityObjectsFactory;
import ru.quadcom.unity.interfaces.IUnityObjectsRoot;
import ru.quadcom.unity.scheme.IIdentifiable;
import ru.quadcom.unity.scheme.MonoBehaviour;
import ru.quadcom.unity.scheme.UnityObject;
import ru.quadcom.unity.scheme.UnityResourceId;
import ru.quadcom.unity.yamlParser.YamlDocument;
import ru.quadcom.unity.yamlParser.YamlLoaderHelper;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class UnityObjectsRoot
implements IUnityObjectsRoot {
    private static final Logger logger = LoggerFactory.getLogger(UnityObjectsRoot.class);
    private final THashMap<UnityResourceId, UnityObject> id2object = new THashMap();
    private final THashMap<Class<?>, THashMap<UnityResourceId, UnityObject>> class2Objects = new THashMap();
    private final UnityObjectsFactory objectsFactory;
    private final THashMap<IdentifiableKey, UnityObject> identifiableObjects = new THashMap();

    @Inject
    public UnityObjectsRoot(Injector injector, @Named(value="UnityResourceClasses") String[] resourcePackages, @Named(value="ScriptClass") Class classSample) throws IOException {
        this.objectsFactory = new UnityObjectsFactory(resourcePackages, injector, this, classSample);
    }

    public void registerObject(UnityObject object) {
        if (this.id2object.containsKey((Object)object.getResourceId())) {
            logger.error("Attempt to register second object with id " + object.getResourceId());
            return;
        }
        this.id2object.put((Object)object.getResourceId(), (Object)object);
        this.registerObjectForClass(object, object.getClass());
        this.registerIdentifiableForClass(object, object.getClass());
    }

    private void registerIdentifiableForClass(UnityObject object, Class<?> clazz) {
        if (!(object instanceof IIdentifiable)) {
            return;
        }
        IIdentifiable identObj = (IIdentifiable)((Object)object);
        IdentifiableKey identifiableKey = new IdentifiableKey(identObj.getGuid(), clazz);
        if (this.identifiableObjects.get((Object)identifiableKey) == null) {
            this.identifiableObjects.put((Object)identifiableKey, (Object)object);
        } else {
            logger.error("Attempt to register second identifiable object with guid " + identObj.getGuid());
        }
        if (!clazz.getSuperclass().equals(MonoBehaviour.class)) {
            this.registerIdentifiableForClass(object, clazz.getSuperclass());
        }
    }

    private void registerObjectForClass(UnityObject object, Class<?> objClass) {
        THashMap classObjects = (THashMap)this.class2Objects.get(object.getClass());
        if (classObjects == null) {
            classObjects = new THashMap();
            this.class2Objects.put(objClass, (Object)classObjects);
        }
        classObjects.put((Object)object.getResourceId(), (Object)object);
        if (!objClass.getSuperclass().equals(UnityObject.class)) {
            this.registerObjectForClass(object, objClass.getSuperclass());
        }
    }

    @Override
    public void loadFromResources(List<String> resourcesPaths) {
        for (String resourcePath : resourcesPaths) {
            try {
                List<YamlDocument> yamlDocuments = YamlLoaderHelper.loadYamlFromResource(resourcePath);
                this.objectsFactory.instantiateObjects(yamlDocuments);
            }
            catch (IOException ex) {
                logger.warn("Exception " + ex.getMessage() + " in loading prefab from " + resourcePath);
            }
        }
    }

    @Override
    public void loadFromDirectory(String dirPath) {
        String currentDir = System.getProperty("user.dir");
        String dirToLoad = currentDir + dirPath;
        this.loadFromDirectoryAbs(dirToLoad);
    }

    @Override
    public void loadFromDirectoryAbs(String dirPath) {
        if (!new File(dirPath).exists()) {
            logger.error("Can't find unity3d resources directory " + dirPath);
        }
        this.loadFromDirectoryImpl(dirPath);
    }

    private void loadFromDirectoryImpl(String dirToLoad) {
        PrefabFilesIterator prefabFiles = new PrefabFilesIterator(dirToLoad);
        while (prefabFiles.hasNext()) {
            File prefabFile = prefabFiles.next();
            try {
                logger.info("Loading prefab: " + prefabFile.getPath());
                List<YamlDocument> yamlDocuments = YamlLoaderHelper.loadYamlFromFile(prefabFile.getPath());
                this.objectsFactory.instantiateObjects(yamlDocuments);
            }
            catch (IOException ex) {
                logger.warn("Exception " + ex.getMessage() + " in loading prefab from " + prefabFile.getPath());
            }
        }
        logger.info("Loading unity3d resources from: " + dirToLoad);
    }

    @Override
    public void loadFromS3(final AWSCredentials awsCredentials, final String bucketName) {
        ObjectListing objectListing;
        AmazonS3Client s3Client = new AmazonS3Client(awsCredentials);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName);
        THashSet prefabKeys = new THashSet();
        do {
            objectListing = s3Client.listObjects(listObjectsRequest);
            for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                if (!objectSummary.getKey().endsWith(".prefab")) continue;
                prefabKeys.add((Object)objectSummary.getKey());
            }
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
        prefabKeys.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String prefabKey) {
                try {
                    logger.info("Loading prefab: " + prefabKey);
                    AmazonS3Client s3Loader = new AmazonS3Client(awsCredentials);
                    S3Object s3ObjPrefab = s3Loader.getObject(new GetObjectRequest(bucketName, prefabKey));
                    S3Object s3PrefabMeta = s3Loader.getObject(new GetObjectRequest(bucketName, prefabKey + ".meta"));
                    List<YamlDocument> yamlDocuments = YamlLoaderHelper.loadYamlDocuments(prefabKey, (InputStream)s3ObjPrefab.getObjectContent(), (InputStream)s3PrefabMeta.getObjectContent());
                    UnityObjectsRoot.this.objectsFactory.instantiateObjects(yamlDocuments);
                }
                catch (AmazonClientException | IOException ex) {
                    logger.error("Error loading prefab: " + prefabKey + " cause " + ex);
                }
                return true;
            }
        });
    }

    @Override
    public void loadFromS3WithRegion(final AWSCredentials awsCredentials, final String bucketName, String region) {
        ObjectListing objectListing;
        AmazonS3Client s3Client = new AmazonS3Client(awsCredentials);
        final Region regionObj = Region.getRegion((Regions)Regions.fromName((String)region));
        s3Client.setRegion(regionObj);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName);
        THashSet prefabKeys = new THashSet();
        do {
            objectListing = s3Client.listObjects(listObjectsRequest);
            for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                if (!objectSummary.getKey().endsWith(".prefab")) continue;
                prefabKeys.add((Object)objectSummary.getKey());
            }
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
        prefabKeys.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String prefabKey) {
                try {
                    logger.info("Loading prefab: " + prefabKey);
                    AmazonS3 s3Loader = (AmazonS3)new AmazonS3Client(awsCredentials).withRegion(regionObj);
                    S3Object s3ObjPrefab = s3Loader.getObject(new GetObjectRequest(bucketName, prefabKey));
                    S3Object s3PrefabMeta = s3Loader.getObject(new GetObjectRequest(bucketName, prefabKey + ".meta"));
                    List<YamlDocument> yamlDocuments = YamlLoaderHelper.loadYamlDocuments(prefabKey, (InputStream)s3ObjPrefab.getObjectContent(), (InputStream)s3PrefabMeta.getObjectContent());
                    UnityObjectsRoot.this.objectsFactory.instantiateObjects(yamlDocuments);
                }
                catch (AmazonClientException | IOException ex) {
                    logger.error("Error loading prefab: " + prefabKey + " cause " + ex);
                }
                return true;
            }
        });
    }

    @Override
    public <T extends UnityObject> T getObjectAs(UnityResourceId resourceId, Class<T> tClass) {
        UnityObject unityObject = this.getObject(resourceId);
        if (unityObject == null) {
            return null;
        }
        return (T)(tClass.isInstance(unityObject) ? unityObject : null);
    }

    @Override
    public <T extends UnityObject> T getObjectAs(UUID guid, Class<T> tClass) {
        IdentifiableKey identifiableKey = new IdentifiableKey(guid, tClass);
        UnityObject unityObject = (UnityObject)this.identifiableObjects.get((Object)identifiableKey);
        if (unityObject == null) {
            return null;
        }
        return (T)(tClass.isInstance(unityObject) ? unityObject : null);
    }

    @Override
    public UnityObject getObject(UnityResourceId resourceId) {
        if (resourceId == null) {
            return null;
        }
        return (UnityObject)this.id2object.get((Object)resourceId);
    }

    @Override
    public THashMap<UnityResourceId, UnityObject> getObjectsForClass(Class<?> objClass) {
        THashMap classObjects = (THashMap)this.class2Objects.get(objClass);
        return classObjects != null ? classObjects : new THashMap();
    }

    @Override
    public void clear() {
        this.id2object.clear();
        this.class2Objects.clear();
        this.identifiableObjects.clear();
    }

    private static class PrefabFilesIterator
    implements Iterator<File> {
        private Deque<File> files = new ArrayDeque<File>();

        public PrefabFilesIterator(String rootPath) {
            this.files.add(new File(rootPath));
            this.moveToNextFile();
        }

        @Override
        public boolean hasNext() {
            return !this.files.isEmpty();
        }

        @Override
        public File next() {
            File result = this.files.isEmpty() ? null : this.files.getFirst();
            this.moveToNextFile();
            return result;
        }

        private void moveToNextFile() {
            if (this.files.isEmpty()) {
                return;
            }
            File head = this.files.removeFirst();
            if (head.isDirectory()) {
                File[] newFiles = head.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File filepath) {
                        return filepath.isDirectory() || filepath.getAbsolutePath().endsWith(".prefab");
                    }
                });
                this.files.addAll(Arrays.asList(newFiles));
            }
            if (!this.files.isEmpty() && this.files.getFirst().isDirectory()) {
                this.moveToNextFile();
            }
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }
    }

    private static class IdentifiableKey {
        private final UUID uuid;
        private final Class<?> type;

        private IdentifiableKey(UUID uuid, Class<?> type) {
            this.uuid = uuid;
            this.type = type;
        }

        public int hashCode() {
            return this.uuid.hashCode() * 31 + this.type.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof IdentifiableKey)) {
                return false;
            }
            IdentifiableKey otherIdentifiable = (IdentifiableKey)other;
            return otherIdentifiable.type.equals(this.type) && otherIdentifiable.uuid.equals(this.uuid);
        }
    }
}

