/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.unity.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.inject.Injector;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.unity.annotations.Unity3dSerializable;
import ru.quadcom.unity.impl.UnityObjectsRoot;
import ru.quadcom.unity.interfaces.IUnityObjectsRoot;
import ru.quadcom.unity.scheme.ComponentId;
import ru.quadcom.unity.scheme.GameObject;
import ru.quadcom.unity.scheme.IIdentifiable;
import ru.quadcom.unity.scheme.MonoBehaviour;
import ru.quadcom.unity.scheme.Transform;
import ru.quadcom.unity.scheme.UnityObject;
import ru.quadcom.unity.scheme.UnityResourceId;
import ru.quadcom.unity.yamlParser.DeserializationHelper;
import ru.quadcom.unity.yamlParser.YamlDocument;

public class UnityObjectsFactory {
    private static final Logger logger = LoggerFactory.getLogger(UnityObjectsFactory.class);
    private final ObjectMapper mapper;
    private final THashMap<UUID, Class<?>> scriptClasses = new THashMap();
    private final UnityObjectsRoot objectsRoot;
    private final Injector injector;

    public UnityObjectsFactory(String[] scriptsPackages, Injector injector, Class<?> classSample) throws IOException {
        this(scriptsPackages, injector, (UnityObjectsRoot)injector.getInstance(IUnityObjectsRoot.class), classSample);
    }

    public UnityObjectsFactory(String[] scriptsPackages, Injector injector, UnityObjectsRoot objectsRoot, Class classSample) throws IOException {
        this.injector = injector;
        this.objectsRoot = objectsRoot;
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        SimpleModule unity3dTypes = new SimpleModule("Unity3dTypes", new Version(1, 0, 0, null)).addDeserializer(UUID.class, (JsonDeserializer)new UUIDDeserializer());
        unity3dTypes.addDeserializer(UnityResourceId.class, (JsonDeserializer)new ResourceIdDeserializer());
        unity3dTypes.addDeserializer(ComponentId.class, (JsonDeserializer)new ComponentIdDeserializer());
        this.mapper.registerModule((Module)unity3dTypes);
        this.parseScriptsPackages(scriptsPackages, classSample);
    }

    public void instantiateObjects(List<YamlDocument> yamlDocuments) {
        for (YamlDocument document : yamlDocuments) {
            Object monoBehaviourProp;
            Object transformProp;
            HashMap<String, UUID> stdValues = new HashMap<String, UUID>();
            stdValues.put("RootObjectGUID", document.getId().getGuid());
            this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std(stdValues));
            Object gameObjectProp = document.getProperties().get("GameObject");
            UnityObject documentObject = null;
            if (gameObjectProp != null) {
                documentObject = (UnityObject)this.mapper.convertValue(gameObjectProp, GameObject.class);
            }
            if ((transformProp = document.getProperties().get("Transform")) != null) {
                documentObject = (UnityObject)this.mapper.convertValue(transformProp, Transform.class);
            }
            if ((monoBehaviourProp = document.getProperties().get("MonoBehaviour")) != null) {
                documentObject = this.instantiateMonoBehaviour(monoBehaviourProp);
            }
            if (documentObject == null) continue;
            this.injector.injectMembers((Object)documentObject);
            documentObject.setResourceId(document.getId());
            this.injectIdentifiableGuid(documentObject, document.getId(), document.getFileURL());
            this.objectsRoot.registerObject(documentObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectIdentifiableGuid(UnityObject docObj, UnityResourceId id, String fileURL) {
        if (!(docObj instanceof IIdentifiable)) {
            return;
        }
        IIdentifiable identifiable = (IIdentifiable)((Object)docObj);
        if (identifiable.getGuid() == null) {
            Method guidSetter = this.getGuidSetter(docObj);
            if (guidSetter != null) {
                boolean prevAccessible = guidSetter.isAccessible();
                guidSetter.setAccessible(true);
                try {
                    guidSetter.invoke((Object)docObj, id.getGuid());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("Can't set guid cause: " + e.getMessage());
                }
                finally {
                    guidSetter.setAccessible(prevAccessible);
                }
            }
        } else if (!id.getGuid().equals(identifiable.getGuid())) {
            logger.error("Object guid is not equal to prefab guid at prefab " + fileURL);
        }
    }

    private Method getGuidSetter(UnityObject docObj) {
        Set setGuidMethods = ReflectionUtils.getAllMethods(docObj.getClass(), (Predicate[])new Predicate[]{Predicates.and((Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)4), ReflectionUtils.withParameters((Class[])new Class[]{UUID.class}), ReflectionUtils.withName((String)"setGuid")})});
        if (setGuidMethods.size() > 0) {
            return (Method)setGuidMethods.iterator().next();
        }
        return null;
    }

    private MonoBehaviour instantiateMonoBehaviour(Object monoBehaviourProp) {
        if (!(monoBehaviourProp instanceof Map)) {
            return null;
        }
        Map propsMap = (Map)monoBehaviourProp;
        Map scriptProps = (Map)propsMap.get("m_Script");
        if (scriptProps == null) {
            return null;
        }
        String guidStr = (String)scriptProps.get("guid");
        if (guidStr == null) {
            return null;
        }
        Class scriptClass = (Class)this.scriptClasses.get((Object)DeserializationHelper.unity3dToJavaUUID(guidStr));
        return scriptClass != null ? (MonoBehaviour)this.mapper.convertValue(monoBehaviourProp, scriptClass) : null;
    }

    private void parseScriptsPackages(String[] scriptsPackages, Class classSample) throws IOException {
        LinkedList<String> packagesToVisit = new LinkedList<String>();
        packagesToVisit.addAll(Arrays.asList(scriptsPackages));
        while (!packagesToVisit.isEmpty()) {
            String packageName = (String)packagesToVisit.poll();
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[]{classSample.getClassLoader()})).addClassLoader(classSample.getClassLoader()));
            Set unity3dSerializableClasses = reflections.getTypesAnnotatedWith(Unity3dSerializable.class);
            logger.info("Found " + unity3dSerializableClasses.size() + " unity3d classes at package " + packageName);
            for (Class clazz : unity3dSerializableClasses) {
                Unity3dSerializable unity3dSerializable = clazz.getAnnotation(Unity3dSerializable.class);
                if (unity3dSerializable == null) continue;
                if (!MonoBehaviour.class.isAssignableFrom(clazz)) {
                    logger.error("Class " + clazz.getCanonicalName() + " annotated with " + Unity3dSerializable.class.getCanonicalName() + " must inherit " + MonoBehaviour.class.getCanonicalName());
                    continue;
                }
                for (String scriptId : unity3dSerializable.guids()) {
                    UUID scriptUUID = DeserializationHelper.unity3dToJavaUUID(scriptId);
                    if (!this.scriptClasses.containsKey((Object)scriptUUID)) {
                        this.scriptClasses.put((Object)scriptUUID, (Object)clazz);
                        continue;
                    }
                    Class registeredClass = (Class)this.scriptClasses.get((Object)scriptUUID);
                    logger.error("Dublicate UUIDs in script classes " + registeredClass.getCanonicalName() + " and " + clazz.getCanonicalName());
                }
            }
        }
    }

    private static class ResourceIdDeserializer
    extends JsonDeserializer<UnityResourceId> {
        private ResourceIdDeserializer() {
        }

        public static UnityResourceId deserializeImpl(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonParseException("Expected object start", jp.getCurrentLocation());
            }
            jp.nextToken();
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME || !jp.getText().equals("fileID")) {
                throw new JsonParseException("Expected fileID here", jp.getCurrentLocation());
            }
            jp.nextToken();
            if (jp.getCurrentToken() != JsonToken.VALUE_NUMBER_INT) {
                throw new JsonParseException("Expected fileID int ", jp.getCurrentLocation());
            }
            int fileID = jp.getIntValue();
            jp.nextToken();
            if (jp.getCurrentToken() == JsonToken.END_OBJECT) {
                UUID rootObjUUID = (UUID)ctxt.findInjectableValue((Object)"RootObjectGUID", null, null);
                if (rootObjUUID == null) {
                    throw new JsonParseException("RootObjectGUID is not set", jp.getCurrentLocation());
                }
                return new UnityResourceId(rootObjUUID, fileID);
            }
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME || !jp.getText().equals("guid")) {
                throw new JsonParseException("Expected guid here", jp.getCurrentLocation());
            }
            jp.nextToken();
            if (jp.getCurrentToken() != JsonToken.VALUE_STRING) {
                throw new JsonParseException("Expected guid string ", jp.getCurrentLocation());
            }
            UUID objectId = DeserializationHelper.unity3dToJavaUUID(jp.getText());
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                jp.nextToken();
            }
            return new UnityResourceId(objectId, fileID);
        }

        public UnityResourceId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ResourceIdDeserializer.deserializeImpl(jp, ctxt);
        }
    }

    private static class ComponentIdDeserializer
    extends JsonDeserializer<ComponentId> {
        private ComponentIdDeserializer() {
        }

        public ComponentId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonParseException("Expected object start", jp.getCurrentLocation());
            }
            jp.nextToken();
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new JsonParseException("Expected typeId here ", jp.getCurrentLocation());
            }
            String typeId = jp.getText();
            jp.nextToken();
            ComponentId componentId = new ComponentId(typeId, ResourceIdDeserializer.deserializeImpl(jp, ctxt));
            jp.nextToken();
            return componentId;
        }
    }

    private static class UUIDDeserializer
    extends JsonDeserializer<UUID> {
        private UUIDDeserializer() {
        }

        public UUID deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String str = null;
            for (int i = 0; i < 3; ++i) {
                if (jp.getCurrentToken().equals((Object)JsonToken.VALUE_STRING)) {
                    str = jp.getText();
                }
                jp.nextToken();
            }
            return str == null ? new UUID(0L, 0L) : DeserializationHelper.unity3dToJavaUUID(str);
        }
    }
}

