/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.IOpenleadService;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;
import ru.quadcom.prototool.gateway.impl.openlead.OpenleadXmlConverter;

@Singleton
public class OpenleadService
implements IOpenleadService {
    private final IOpenleadGateway gateway;
    private final Executor executorSendXml = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final List<BuilderMessageOpenlead.MessageOpenlead> listMessage = new ArrayList<BuilderMessageOpenlead.MessageOpenlead>();
    private final ReentrantLock listMessageLock = new ReentrantLock();

    @Inject
    public OpenleadService(IOpenleadGateway gateway) {
        this.gateway = gateway;
        this.scheduler.scheduleAtFixedRate(() -> {
            List<BuilderMessageOpenlead.MessageOpenlead> listCopy = this.copyAndClearMessageList();
            if (listCopy.size() > 0) {
                this.processMessageList(listCopy);
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    @Deprecated
    public void registration(String userId, String ip) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).registration();
        if (Strings.isNullOrEmpty((String)ip)) {
            ip = "0.0.0.0";
        }
        message.addParam("UserIP", ip).addParam("OpenleadID", "0").addParam("platform", "pc");
        this.addMessage(message);
    }

    @Override
    public void registration(String userId, String openleadID, String platform, String ip) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).registration();
        if (Strings.isNullOrEmpty((String)ip)) {
            ip = "0.0.0.0";
        }
        message.addParam("UserIP", ip).addParam("OpenleadID", openleadID).addParam("platform", platform);
        this.addMessage(message);
    }

    @Override
    public void logout(String userId) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).logout();
        this.addMessage(message);
    }

    @Override
    @Deprecated
    public void authorization(String userId, String dateReg) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).login();
        message.addParam("dateReg", dateReg).addParam("platform", "pc");
        this.addMessage(message);
    }

    @Override
    public void authorization(String userId, String dateReg, String platform) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).login();
        message.addParam("dateReg", dateReg).addParam("platform", platform);
        this.addMessage(message);
    }

    @Override
    public void send(BuilderMessageOpenlead.MessageOpenlead message) {
        this.addMessage(message);
    }

    @Override
    public void battleCompleted(String userId, boolean isWin) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("battle_completed");
        message.addParam("result", isWin ? "1" : "0");
        this.addMessage(message);
    }

    @Override
    @Deprecated
    public void userUpLevel(String userId, int level) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("level");
        message.addParam("level", Integer.valueOf(level).toString()).addParam("platform", "pc");
        this.addMessage(message);
    }

    @Override
    public void userUpLevel(String userId, int level, String platform) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("level");
        message.addParam("level", Integer.valueOf(level).toString()).addParam("platform", platform);
        this.addMessage(message);
    }

    @Override
    public CompletionStage<String> getOpenleadID(String code) {
        return this.gateway.getOpenLeadID(code);
    }

    private void addMessage(BuilderMessageOpenlead.MessageOpenlead message) {
        this.listMessageLock.lock();
        try {
            this.listMessage.add(message);
        }
        finally {
            this.listMessageLock.unlock();
        }
    }

    private List<BuilderMessageOpenlead.MessageOpenlead> copyAndClearMessageList() {
        this.listMessageLock.lock();
        try {
            ArrayList<BuilderMessageOpenlead.MessageOpenlead> listCopy = new ArrayList<BuilderMessageOpenlead.MessageOpenlead>(this.listMessage);
            this.listMessage.clear();
            ArrayList<BuilderMessageOpenlead.MessageOpenlead> arrayList = listCopy;
            return arrayList;
        }
        finally {
            this.listMessageLock.unlock();
        }
    }

    private void processMessageList(List<BuilderMessageOpenlead.MessageOpenlead> list) {
        String xml = OpenleadXmlConverter.convertMessageList(list);
        CompletableFuture.runAsync(() -> this.gateway.sendXml(xml), this.executorSendXml);
    }
}

