/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.achievement.AchievementCounter;
import ru.quadcom.datapack.domains.item.AttachedSlot;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.item.ItemOwnerType;
import ru.quadcom.datapack.domains.operator.OperatorType;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.datapack.templates.achievement.CounterType;
import ru.quadcom.datapack.templates.common.DecorationType;
import ru.quadcom.datapack.templates.common.UnitSkinColor;
import ru.quadcom.prototool.gateway.messages.sts.common.EquipmentContainer;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipmentMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.DivisionStatusMessage;
import ru.quadcom.prototool.gateway.messages.sts.profile.MainRatingBattleStatusMessage;
import ru.quadcom.tactics.typeproto.Achievement;
import ru.quadcom.tactics.typeproto.Contract;
import ru.quadcom.tactics.typeproto.Equipment;
import ru.quadcom.tactics.typeproto.EquipmentItem;
import ru.quadcom.tactics.typeproto.Item;
import ru.quadcom.tactics.typeproto.ItemType;
import ru.quadcom.tactics.typeproto.MainRatingBattleStatus;
import ru.quadcom.tactics.typeproto.Operator;
import ru.quadcom.tactics.typeproto.RatingBattlePlayerInGetDivisionStatus;
import ru.quadcom.tactics.typeproto.StatInfo;
import ru.quadcom.tactics.typeproto.UnitSkinPart;
import ru.quadcom.tactics.typeproto.UnitTraitType;

public class Transformer {
    public static Profile fromProto(ru.quadcom.tactics.typeproto.Profile protoProfile) {
        Profile profile = new Profile();
        profile.setId(protoProfile.getId());
        profile.setAccountId(protoProfile.getAccountId());
        profile.setNickname(protoProfile.getNickname());
        profile.setCash(protoProfile.getCash());
        profile.setAvatar(protoProfile.getAvatar());
        profile.setFractionId(protoProfile.getFractionId());
        profile.setRankId(protoProfile.getRankId());
        profile.setRating(protoProfile.getRating());
        profile.setExperience(protoProfile.getExperience());
        profile.setLevel(protoProfile.getLevel());
        return profile;
    }

    public static ru.quadcom.tactics.typeproto.Profile toProto(Profile profile) {
        return ru.quadcom.tactics.typeproto.Profile.newBuilder().setId(profile.getId()).setAccountId(profile.getAccountId()).setNickname(profile.getNickname()).setCash(profile.getCash()).setAvatar(profile.getAvatar()).setFractionId(profile.getFractionId()).setRankId(profile.getRankId()).setRating(profile.getRating()).setExperience(profile.getExperience()).setLevel(profile.getLevel()).build();
    }

    public static ru.quadcom.datapack.domains.operator.Operator fromProto(Operator protoOperator) {
        ru.quadcom.datapack.domains.operator.Operator operator = new ru.quadcom.datapack.domains.operator.Operator();
        operator.setId(protoOperator.getId());
        operator.setProfileId(protoOperator.getProfileId());
        operator.setName(protoOperator.getName());
        operator.setNationalityId(protoOperator.getNationalityId());
        operator.setGenderId(protoOperator.getGenderId());
        operator.setRaceId(protoOperator.getRaceId());
        operator.setRarityId(protoOperator.getRarityId());
        operator.setRankId(protoOperator.getRankId());
        operator.setExperience(protoOperator.getExperience());
        operator.setStrength(protoOperator.getStrength());
        operator.setPerception(protoOperator.getPerception());
        operator.setIntelligence(protoOperator.getIntelligence());
        operator.setKnack(protoOperator.getKnack());
        operator.setEndurance(protoOperator.getEndurance());
        operator.addClasses(protoOperator.getClassIdsList());
        operator.setAvatarName(protoOperator.getAvatarName());
        operator.addAvatarLayers(protoOperator.getAvatarLayersMap());
        operator.setPlace(protoOperator.getPlace());
        operator.setSkinParts(StreamEx.of((Collection)protoOperator.getSkinPartsList()).map(Transformer::fromProto).toList());
        operator.setSkillPoints(protoOperator.getSkillPoints());
        operator.setSkinColors(Transformer.fromProto(protoOperator.getSkinColors()));
        operator.setNeedHealingHP(protoOperator.getNeedHealingHP());
        operator.setStartTimeHealingHP(protoOperator.getStartTimeHealingHP());
        operator.addAllTraits((Collection)StreamEx.of((Collection)protoOperator.getUnitTraitTypeList()).map(type -> ru.quadcom.datapack.domains.operator.UnitTraitType.valueOf((String)type.name())).toList());
        operator.setBodyKitSetId(protoOperator.getBodyKitSetId());
        operator.setHeadKitIdList((Set)Sets.newHashSet((Iterable)protoOperator.getHeadKitIdList()));
        operator.setVoiceId(protoOperator.getVoiceId());
        operator.setType(OperatorType.getById((int)protoOperator.getType()));
        operator.setDead(protoOperator.getDead());
        operator.addAvailableClasses(protoOperator.getAvailableClassIdList());
        return operator;
    }

    private static UnitSkinColor fromProto(ru.quadcom.tactics.typeproto.UnitSkinColor protoSkinColors) {
        return new UnitSkinColor(protoSkinColors.getCamouflageIndex(), protoSkinColors.getLutIndex(), protoSkinColors.getSolidIndex(), protoSkinColors.getSkinIndex());
    }

    private static ru.quadcom.datapack.templates.common.UnitSkinPart fromProto(UnitSkinPart protoSkinPart) {
        return new ru.quadcom.datapack.templates.common.UnitSkinPart(DecorationType.valueOf((String)protoSkinPart.getSlotId().name()), protoSkinPart.getGuid(), protoSkinPart.getPriority());
    }

    public static Operator toProto(ru.quadcom.datapack.domains.operator.Operator operator) {
        return Operator.newBuilder().setId(operator.getId()).setProfileId(operator.getProfileId()).setName(operator.getName()).setNationalityId(operator.getNationalityId()).setGenderId(operator.getGenderId()).setRaceId(operator.getRaceId()).setRarityId(operator.getRarityId()).setRankId(operator.getRankId()).setExperience(operator.getExperience()).setStrength(operator.getStrength()).setPerception(operator.getPerception()).setIntelligence(operator.getIntelligence()).setKnack(operator.getKnack()).setEndurance(operator.getEndurance()).addAllClassIds((Iterable)operator.getClassIds()).setAvatarName(operator.getAvatarName()).putAllAvatarLayers(operator.getAvatarLayers()).setPlace(operator.getPlace()).addAllSkinParts((Iterable)StreamEx.of((Collection)operator.getSkinParts()).map(Transformer::toProto).toList()).setSkillPoints(operator.getSkillPoints()).setSkinColors(Transformer.toProto(operator.getSkinColors())).setNeedHealingHP(operator.getNeedHealingHP()).setStartTimeHealingHP(operator.getStartTimeHealingHP()).addAllUnitTraitType((Iterable)StreamEx.of((Collection)operator.getTraits()).map(type -> UnitTraitType.valueOf((String)type.name())).toList()).setBodyKitSetId(operator.getBodyKitSetId()).addAllHeadKitId((Iterable)operator.getHeadKitIdList()).setVoiceId(operator.getVoiceId()).setType(operator.getType().getId()).setDead(operator.isDead()).addAllAvailableClassId((Iterable)operator.getAvailableClassIds()).build();
    }

    private static ru.quadcom.tactics.typeproto.UnitSkinColor toProto(UnitSkinColor skinColors) {
        return ru.quadcom.tactics.typeproto.UnitSkinColor.newBuilder().setCamouflageIndex(skinColors.getCamouflageIndex()).setLutIndex(skinColors.getLutIndex()).setSolidIndex(skinColors.getSolidIndex()).setSkinIndex(skinColors.getSkinIndex()).build();
    }

    private static UnitSkinPart toProto(ru.quadcom.datapack.templates.common.UnitSkinPart skinPart) {
        return UnitSkinPart.newBuilder().setSlotId(UnitSkinPart.DecorationType.valueOf((String)skinPart.getSlotId().name())).setGuid(skinPart.getGuid()).setPriority(skinPart.getPriority()).build();
    }

    public static Item fromProto(ru.quadcom.tactics.typeproto.Item protoItem) {
        Item item = new Item();
        item.setId(protoItem.getId());
        item.setProfileId(protoItem.getProfileId());
        item.setOwnerInstanceId(protoItem.getOwnerInstanceId());
        item.setItemOwnerType(ItemOwnerType.valueOf((String)protoItem.getItemOwnerType().name()));
        item.setItemTemplateId(protoItem.getItemTemplateId());
        item.setCount(protoItem.getCount());
        item.setDurability(protoItem.getDurability());
        item.setSlotNumber(protoItem.getSlotNumber());
        item.setLife(protoItem.getLife());
        protoItem.getAttachedItemsList().forEach(attached -> item.setAttachedItem(AttachedSlot.valueOf((String)attached.getAttachedSlot().name()), Transformer.fromProto(attached.getItem())));
        return item;
    }

    public static ru.quadcom.tactics.typeproto.Item toProto(Item item) {
        return ru.quadcom.tactics.typeproto.Item.newBuilder().setId(item.getId()).setProfileId(item.getProfileId()).setOwnerInstanceId(item.getOwnerInstanceId()).setItemOwnerType(Item.ItemOwnerType.valueOf((String)item.getItemOwnerType().name())).setItemTemplateId(item.getItemTemplateId()).setCount(item.getCount()).setDurability(item.getDurability()).setSlotNumber(item.getSlotNumber()).setLife(item.getLife()).addAllAttachedItems((Iterable)StreamEx.of(item.getAttachedItems().entrySet()).map(entry -> Item.AttachedItem.newBuilder().setAttachedSlot(Item.AttachedItem.AttachedSlot.valueOf((String)((AttachedSlot)entry.getKey()).name())).setItem(Transformer.toProto((Item)entry.getValue())).build()).toList()).build();
    }

    public static Contract toProto(ru.quadcom.datapack.domains.contracts.Contract contract) {
        return Contract.newBuilder().setId(contract.getId()).setProfileId(contract.getProfileId()).setTemplateId(contract.getTemplateId()).setComplete(contract.isComplete()).setMapCellId(contract.getMapCellId()).setLock(contract.isLock()).setIsNew(contract.isNew()).setData(contract.getData()).build();
    }

    public static ru.quadcom.datapack.domains.contracts.Contract fromProto(Contract protoContract) {
        ru.quadcom.datapack.domains.contracts.Contract contract = new ru.quadcom.datapack.domains.contracts.Contract();
        contract.setId(protoContract.getId());
        contract.setProfileId(protoContract.getProfileId());
        contract.setTemplateId(protoContract.getTemplateId());
        contract.setComplete(protoContract.getComplete());
        contract.setMapCellId(protoContract.getMapCellId());
        contract.setLock(protoContract.getLock());
        contract.setNew(protoContract.getIsNew());
        contract.setData(protoContract.getData());
        return contract;
    }

    public static Achievement toProto(ru.quadcom.datapack.domains.achievement.Achievement achievement) {
        return Achievement.newBuilder().setId(achievement.getId()).setTemplateId(achievement.getAchievementTemplateId()).setLevel(achievement.getLevel()).build();
    }

    public static ru.quadcom.datapack.domains.achievement.Achievement fromProto(Achievement protoAchievement) {
        ru.quadcom.datapack.domains.achievement.Achievement achievement = new ru.quadcom.datapack.domains.achievement.Achievement();
        achievement.setAchievementTemplateId(protoAchievement.getTemplateId());
        achievement.setId(protoAchievement.getId());
        achievement.setLevel(protoAchievement.getLevel());
        return achievement;
    }

    public static ru.quadcom.tactics.typeproto.AchievementCounter toProto(AchievementCounter achievementCounter) {
        return ru.quadcom.tactics.typeproto.AchievementCounter.newBuilder().setId(achievementCounter.getId()).setType(achievementCounter.getType().getId()).setValue(achievementCounter.getValue()).build();
    }

    public static AchievementCounter fromProto(ru.quadcom.tactics.typeproto.AchievementCounter protoAchievementCounter) {
        AchievementCounter achievementCounter = new AchievementCounter();
        achievementCounter.setId(protoAchievementCounter.getId());
        achievementCounter.setType(CounterType.valueOfId((int)protoAchievementCounter.getType()));
        achievementCounter.setValue(protoAchievementCounter.getValue());
        return achievementCounter;
    }

    public static Map<Long, EquipmentMessage> convertEquipmentMapToEquipmentMessageMap(Map<Long, Equipment> equipmentMap) {
        return StreamEx.of(equipmentMap.entrySet()).toMap(Map.Entry::getKey, entry -> {
            Equipment equipment = (Equipment)entry.getValue();
            return Transformer.toEquipmentMessage(equipment);
        });
    }

    public static EquipmentMessage toEquipmentMessage(Equipment equipment) {
        return new EquipmentMessage(StreamEx.of((Collection)equipment.getEquipmentItemList()).toMap(EquipmentItem::getSlot, equipmentItem -> new EquipmentContainer(StreamEx.of((Collection)equipmentItem.getItemList()).map(Transformer::fromProto).toList(), StreamEx.of((Collection)equipmentItem.getEquipmentItemTypeList()).toMap(equipmentItemType -> ru.quadcom.datapack.domains.item.ItemType.valueOf((String)equipmentItemType.getItemType().name()), EquipmentItem.EquipmentItemType::getCount), equipmentItem.hasDefaultItem() ? Transformer.fromProto(equipmentItem.getDefaultItem()) : null)), equipment.getStatInfo().getHp(), equipment.getStatInfo().getArmor(), equipment.getStatInfo().getCurrentHp());
    }

    public static Equipment toProto(EquipmentMessage equipment) {
        StatInfo.Builder statInfoBuilder = StatInfo.newBuilder();
        statInfoBuilder.setArmor(equipment.getArmor());
        statInfoBuilder.setCurrentHp(equipment.getCurrentHp());
        statInfoBuilder.setHp(equipment.getHp());
        Equipment.Builder equipmentBuilder = Equipment.newBuilder().setStatInfo(statInfoBuilder.build());
        for (Map.Entry<Integer, EquipmentContainer> slotTypeSlotEntry : equipment.getEquipment().entrySet()) {
            EquipmentContainer slot = slotTypeSlotEntry.getValue();
            EquipmentItem.Builder equipmentItemBuilder = EquipmentItem.newBuilder().setSlot(slotTypeSlotEntry.getKey().intValue()).addAllItem((Iterable)StreamEx.of(slot.getItems()).map(Transformer::toProto).toList()).addAllEquipmentItemType((Iterable)StreamEx.of(slot.getConfig().entrySet()).map(entry -> EquipmentItem.EquipmentItemType.newBuilder().setItemType(ItemType.valueOf((String)((ru.quadcom.datapack.domains.item.ItemType)entry.getKey()).name())).setCount(((Integer)entry.getValue()).intValue()).build()).toList());
            if (slot.getDefaultItem() != null) {
                equipmentItemBuilder.setDefaultItem(Transformer.toProto(slot.getDefaultItem()));
            }
            equipmentBuilder.addEquipmentItem(equipmentItemBuilder.build());
        }
        return equipmentBuilder.build();
    }

    public static EquipmentMessage fromProto(Equipment protoEquipment) {
        return new EquipmentMessage(StreamEx.of((Collection)protoEquipment.getEquipmentItemList()).toMap(EquipmentItem::getSlot, equipmentItem -> new EquipmentContainer(StreamEx.of((Collection)equipmentItem.getItemList()).map(Transformer::fromProto).toList(), StreamEx.of((Collection)equipmentItem.getEquipmentItemTypeList()).toMap(equipmentItemType -> ru.quadcom.datapack.domains.item.ItemType.valueOf((String)equipmentItemType.getItemType().name()), EquipmentItem.EquipmentItemType::getCount), equipmentItem.hasDefaultItem() ? Transformer.fromProto(equipmentItem.getDefaultItem()) : null)), protoEquipment.getStatInfo().getHp(), protoEquipment.getStatInfo().getArmor(), protoEquipment.getStatInfo().getCurrentHp());
    }

    public static MainRatingBattleStatus toProto(MainRatingBattleStatusMessage message) {
        MainRatingBattleStatus.Builder builder = MainRatingBattleStatus.newBuilder();
        return builder.setCalibrationBattlesLeft(message.calibrationBattlesLeft).setDivisionLevel(message.divisionLevel).setRating(message.rating).setRatingMax(message.ratingMax).setSeasonRemainedSeconds(message.seasonRemainedSeconds).setSeasonNumber(message.seasonNumber).setIsRatingBattlesAvailable(message.isRatingBattlesAvailable).setNeedShowMessageRewardedShopRefreshCount(message.needShowMessageRewardedShopRefreshCount).setShopRefreshCount(message.shopRefreshCount).build();
    }

    public static MainRatingBattleStatusMessage fromProto(MainRatingBattleStatus proto) {
        return new MainRatingBattleStatusMessage(proto.getCalibrationBattlesLeft(), proto.getDivisionLevel(), proto.getRating(), proto.getRatingMax(), proto.getSeasonRemainedSeconds(), proto.getSeasonNumber(), proto.getIsRatingBattlesAvailable(), proto.getNeedShowMessageRewardedShopRefreshCount(), proto.getShopRefreshCount());
    }

    public static List<DivisionStatusMessage.RatingBattlePlayerInGetDivisionStatus> fromProto(List<RatingBattlePlayerInGetDivisionStatus> protoList) {
        ArrayList<DivisionStatusMessage.RatingBattlePlayerInGetDivisionStatus> result = new ArrayList<DivisionStatusMessage.RatingBattlePlayerInGetDivisionStatus>();
        for (RatingBattlePlayerInGetDivisionStatus proto : protoList) {
            result.add(new DivisionStatusMessage.RatingBattlePlayerInGetDivisionStatus(proto.getProfileId(), proto.getRating(), proto.getRatingMax(), proto.getWinCount(), proto.getLoseCount(), proto.getWinSeries(), proto.getWinSeriesMax(), proto.getLastRatingDeltaSign(), proto.getNickname(), proto.getAvatar(), proto.getFractionId(), proto.getProfileLevel()));
        }
        return result;
    }

    public static RatingBattlePlayerInGetDivisionStatus toProto(DivisionStatusMessage.RatingBattlePlayerInGetDivisionStatus message) {
        RatingBattlePlayerInGetDivisionStatus.Builder builder = RatingBattlePlayerInGetDivisionStatus.newBuilder();
        return builder.setProfileId(message.profileId).setRating(message.rating).setRatingMax(message.ratingMax).setWinCount(message.winCount).setLoseCount(message.loseCount).setWinSeries(message.winSeries).setWinSeriesMax(message.winSeriesMax).setLastRatingDeltaSign(message.lastRatingDeltaSign).setNickname(message.nickname).setAvatar(message.avatar).setFractionId(message.fractionId).setProfileLevel(message.profileLevel).build();
    }
}

