/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IShopProtoGateway;
import ru.quadcom.prototool.gateway.messages.sts.common.ShopContainer;
import ru.quadcom.prototool.gateway.messages.sts.common.ShopOperatorContainer;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipmentMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.BuyMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.BuyOperatorMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.GetOperatorsOnSaleMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.PriceListMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.SellMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.shopproto.RQ_ShopBuy;
import ru.quadcom.tactics.shopproto.RQ_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RQ_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RQ_ShopPriceList;
import ru.quadcom.tactics.shopproto.RQ_ShopSell;
import ru.quadcom.tactics.shopproto.RS_ShopBuy;
import ru.quadcom.tactics.shopproto.RS_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RS_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RS_ShopPriceList;
import ru.quadcom.tactics.shopproto.RS_ShopSell;
import ru.quadcom.tactics.typeproto.ShopType;

public abstract class AbstractShopProtoGateway
extends AbstractProtoGateway
implements IShopProtoGateway {
    public AbstractShopProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<PriceListMessage> priceList(Profile profile) {
        RQ_ShopPriceList request = RQ_ShopPriceList.newBuilder().setProfile(Transformer.toProto(profile)).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_PRICE_LIST, Packet.PacketType.RS_SHOP_PRICE_LIST, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopPriceList.parseFrom((ByteString)bytes))).thenApply(message -> new PriceListMessage(null, null, message.getRefreshInterval(), StreamEx.of((Collection)message.getCommonList()).map(position -> new ShopContainer(position.getTemplateId(), position.getPrice(), position.getBuyOne())).toList(), StreamEx.of((Collection)message.getSpecialList()).map(position -> new ShopContainer(position.getTemplateId(), position.getPrice(), position.getBuyOne())).toList()));
    }

    @Override
    public CompletionStage<BuyMessage> buy(long accountId, long profileId, ru.quadcom.datapack.domains.shop.ShopType shopType, int itemTemplateId, int count) {
        RQ_ShopBuy request = RQ_ShopBuy.newBuilder().setAccountId(accountId).setProfileId(profileId).setItemTemplateId(itemTemplateId).setShopType(ShopType.valueOf((String)shopType.name())).setCount(count).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SHOP_BUY, Packet.PacketType.RS_SHOP_BUY, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_ShopBuy.parseFrom((ByteString)packet.getBody()))).thenApply(message -> new BuyMessage(message.getChangeCash(), StreamEx.of((Collection)message.getItemList()).map(Transformer::fromProto).toList()));
    }

    @Override
    public CompletionStage<SellMessage> sell(long accountId, long profileId, List<Long> itemIds) {
        RQ_ShopSell request = RQ_ShopSell.newBuilder().setAccountId(accountId).setProfileId(profileId).addAllItemId(itemIds).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SHOP_SELL, Packet.PacketType.RS_SHOP_SELL, (GeneratedMessageV3)request, false).thenApply(packet -> {
            RS_ShopSell message = this.parse(() -> RS_ShopSell.parseFrom((ByteString)packet.getBody()));
            Map<Long, EquipmentMessage> changeEquipment = Transformer.convertEquipmentMapToEquipmentMessageMap(message.getChangeEquipmentMap());
            return new SellMessage(message.getChangeCash(), changeEquipment);
        });
    }

    @Override
    public CompletionStage<GetOperatorsOnSaleMessage> getOperatorsOnSale(Profile profile, boolean refreshWithScores) {
        RQ_ShopGetOperatorsOnSale request = RQ_ShopGetOperatorsOnSale.newBuilder().setProfile(Transformer.toProto(profile)).setRefreshWithScores(refreshWithScores).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SHOP_GET_OPERATORS_ONSALE, Packet.PacketType.RS_SHOP_GET_OPERATORS_ONSALE, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_ShopGetOperatorsOnSale.parseFrom((ByteString)packet.getBody()))).thenApply(response -> new GetOperatorsOnSaleMessage(StreamEx.of((Collection)response.getShopOperatorList()).map(shopOperator -> new ShopOperatorContainer(Transformer.fromProto(shopOperator.getOperator()), shopOperator.getPrice(), StreamEx.of((Collection)shopOperator.getItemList()).map(Transformer::fromProto).toList())).toList(), response.getRefreshInterval()));
    }

    @Override
    public CompletionStage<BuyOperatorMessage> buyOperator(Profile profile, long operatorId) {
        RQ_ShopBuyOperator request = RQ_ShopBuyOperator.newBuilder().setProfile(Transformer.toProto(profile)).setOperatorId(operatorId).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_BUY_OPERATOR, Packet.PacketType.RS_SHOP_BUY_OPERATOR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopBuyOperator.parseFrom((ByteString)bytes))).thenApply(response -> new BuyOperatorMessage(Transformer.fromProto(response.getOperator()), response.getChangeCash()));
    }
}

