/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;

public class OpenleadServiceGateway
extends AbstractHttpGateway
implements IOpenleadGateway {
    private static final Logger logger = LoggerFactory.getLogger(OpenleadServiceGateway.class);
    private final String COOKIE_NAME = "_openlead";
    private final String OPENLEAD_URL = "http://openlead.net";
    private final String apiKey;
    private final boolean sendStats;
    private static final String OPENLEAD_API_KEY = "openLead.apiKey";
    private static final String OPENLEAD_SEND_STATS = "openLead.sendStats";

    @Inject
    public OpenleadServiceGateway(WSClient wsClient, Config config) {
        super("http://openlead.net/data/load/post/", wsClient);
        if (config.hasPath(OPENLEAD_API_KEY)) {
            this.apiKey = config.getString(OPENLEAD_API_KEY);
            this.sendStats = config.hasPath(OPENLEAD_SEND_STATS) && config.getBoolean(OPENLEAD_SEND_STATS);
        } else {
            this.apiKey = "";
            this.sendStats = false;
        }
    }

    @Override
    @Deprecated
    public void registration(BuilderMessageOpenlead.MessageOpenlead message) {
        if (!this.sendStats) {
            return;
        }
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", "registration").addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    @Override
    @Deprecated
    public void send(BuilderMessageOpenlead.MessageOpenlead message) {
        if (!this.sendStats) {
            return;
        }
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", message.getEvent()).addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    @Deprecated
    private AbstractHttpGateway.RequestWrapper getRequestWrapper() {
        return this.getRequest("", false).addQueryParameter("api_key", this.apiKey).addQueryParameter("time", String.valueOf(System.currentTimeMillis() / 1000L));
    }

    @Override
    @Deprecated
    public void getOpenLeadIdAndRegistration(BuilderMessageOpenlead.MessageOpenlead message, String adv_id) {
        if (!this.sendStats) {
            return;
        }
        this.getUrlRequest("https://rampressure.game/openleadid", false).addQueryParameter("code", adv_id).get(r -> {
            JsonNode jsonNode = Json.toJson((Object)r.getBody());
            String code = jsonNode.get("openleadId").asText();
            message.addParam("OpenleadID", code);
            this.registration(message);
            return r.getBody();
        });
    }

    @Override
    public CompletionStage<String> getOpenLeadID(String adv_id) {
        if (!this.sendStats) {
            return CompletableFuture.completedFuture("1");
        }
        return this.getUrlRequest("https://rampressure.game/openleadid", false).addQueryParameter("code", adv_id).get(r -> {
            String code = "?";
            try {
                Gson gson = new Gson();
                HashMap m = (HashMap)gson.fromJson(r.getBody(), HashMap.class);
                code = (String)m.get("openleadId");
                return code;
            }
            catch (Exception e) {
                logger.error("error get openLeadID" + e.getMessage());
                return code;
            }
        }).handle((r, e) -> r != null ? r : "");
    }

    @Override
    public void sendXml(String xml) {
        if (!this.sendStats) {
            return;
        }
        this.getUrlRequest("http://openlead.net/data/load/xml/", false).addQueryParameter("xml", String.format(xml, false)).addQueryParameter("api_key", this.apiKey).postUrlencoded(wsResponse -> {
            String response = wsResponse.getBody();
            logger.debug("ol send xml response " + response);
            return response;
        });
    }

    @Override
    protected String getToken() {
        return null;
    }
}

