/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool;

import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.AbstractProtoService;
import ru.quadcom.prototool.ProtoSyncHandler;
import ru.quadcom.tactics.baseproto.Packet;

public class AbstractProtoSyncService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProtoService.class);
    private final Map<Packet.PacketType, Pair<Packet.PacketType, ProtoSyncHandler>> map = Maps.newHashMap();

    protected void registrationHandler(Packet.PacketType requestType, Packet.PacketType responseType, ProtoSyncHandler handler) {
        this.map.put(requestType, (Pair<Packet.PacketType, ProtoSyncHandler>)ImmutablePair.of((Object)responseType, (Object)handler));
    }

    public byte[] handleRequest(Http.RequestBody body) {
        try {
            long startTimeMs = System.currentTimeMillis();
            Packet request = Packet.parseFrom((byte[])body.asBytes().toArray());
            Packet.PacketType requestType = request.getType();
            Pair<Packet.PacketType, ProtoSyncHandler> pair = this.map.get(requestType);
            Packet.PacketType responseType = (Packet.PacketType)pair.getKey();
            ProtoSyncHandler protoHandler = (ProtoSyncHandler)pair.getValue();
            try {
                long unlockedByAccountIdTimeMs = System.currentTimeMillis();
                Object response = protoHandler.process0(request.getBody());
                if (logger.isTraceEnabled()) {
                    logger.trace("response " + responseType + "\n" + response.toString());
                }
                long processedTimeMs = System.currentTimeMillis();
                long totalDelayMs = processedTimeMs - startTimeMs;
                long processedDelayMs = processedTimeMs - unlockedByAccountIdTimeMs;
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("TIMINGS: total = ").append(totalDelayMs);
                stringBuilder.append("; requestType = ").append(request.getType());
                stringBuilder.append("; processed = ").append(processedDelayMs);
                if (totalDelayMs > 1000L) {
                    logger.warn(stringBuilder.toString());
                } else {
                    logger.info(stringBuilder.toString());
                }
                Packet.Builder builder = Packet.newBuilder().setType(responseType).setBody(response.toByteString());
                return builder.build().toByteArray();
            }
            catch (InvalidProtocolBufferException e) {
                throw new WarningException("Proto handled error", 1);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new WarningException("Proto handled error", 1);
        }
    }
}

