/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.ILoggerService;

public class AbstractLoggerServiceGateway
extends AbstractHttpGateway
implements ILoggerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoggerServiceGateway.class);
    private final Executor executor = Executors.newSingleThreadExecutor();

    @Inject
    public AbstractLoggerServiceGateway(WSClient wsClient, String url) {
        super(url, wsClient);
    }

    @Override
    public void changeCache(long accountId, long profileId, long oldCash, long newCash, String cause) {
        CompletableFuture.runAsync(() -> this.getRequest("/loggerservice/user/1.0/transaction/create", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("oldCash", String.valueOf(oldCash)).addQueryParameter("newCash", String.valueOf(newCash)).addQueryParameter("cause", cause).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        }), this.executor);
    }

    @Override
    public void changeItems(long accountId, long profileId, int idItemTemplate, int status, String source, long itemId) {
        CompletableFuture.runAsync(() -> this.getRequest("/loggerservice/user/1.0/item/transaction/create", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("idItemTemplate", String.valueOf(idItemTemplate)).addQueryParameter("status", String.valueOf(status)).addQueryParameter("source", String.valueOf(source)).addQueryParameter("itemId", String.valueOf(itemId)).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        }), this.executor);
    }

    @Override
    public void addEventLoginUser(long accountId, String version, String session) {
        CompletableFuture.runAsync(() -> this.getRequest("/loggerservice/user/1.0/event/user/login", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("version", version).addQueryParameter("session", session).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        }), this.executor);
    }

    @Override
    public void addCustomEvent(long accountId, long profileId, String action, Map data) {
        CompletableFuture.runAsync(() -> this.getRequest("/loggerservice/user/1.0/event/custom/create", false).addQueryObjectParameter("accountId", accountId).addQueryObjectParameter("profileId", profileId).addQueryObjectParameter("action", action).addQueryObjectParameter("data", data).put(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        }), this.executor);
    }

    @Override
    public void addEventLogoutUser(long accountId, String session) {
        CompletableFuture.runAsync(() -> this.getRequest("/loggerservice/user/1.0/event/user/logout", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("session", session).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        }), this.executor);
    }

    @Override
    protected String getToken() {
        return null;
    }
}

