/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.IOpenleadService;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;
import ru.quadcom.prototool.gateway.impl.openlead.TaskOpenLeadService;

@Singleton
public class OpenleadService
implements IOpenleadService {
    private static Executor executor;
    private static IOpenleadGateway gateway;
    private List<BuilderMessageOpenlead.MessageOpenlead> listMessage = new CopyOnWriteArrayList<BuilderMessageOpenlead.MessageOpenlead>();
    private ScheduledExecutorService thread = Executors.newSingleThreadScheduledExecutor();

    @Inject
    public OpenleadService(IOpenleadGateway gateway) {
        OpenleadService.gateway = gateway;
        executor = Executors.newSingleThreadExecutor();
        this.thread.scheduleAtFixedRate(new TaskOpenLeadService(this.listMessage, OpenleadService::sendXml), 60L, 60L, TimeUnit.SECONDS);
    }

    private static Void sendXml(final String xml) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                gateway.sendXml(xml);
            }
        }, executor);
        return null;
    }

    @Override
    public void registration(String userId) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).registration();
        String ip = "0.0.0.0";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        message.addParam("UserIP", ip).addParam("OpenleadID", "0").addParam("platform", "pc");
        this.listMessage.add(message);
    }

    @Override
    public void registration(String userId, String openleadID, String platform) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).registration();
        String ip = "0.0.0.0";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        message.addParam("UserIP", ip).addParam("OpenleadID", openleadID).addParam("platform", platform);
        this.listMessage.add(message);
    }

    @Override
    public void authorization(String userId, String dateReg) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).login();
        message.addParam("dateReg", dateReg).addParam("platform", "pc");
        this.listMessage.add(message);
    }

    @Override
    public void send(BuilderMessageOpenlead.MessageOpenlead messageOpenlead) {
        this.listMessage.add(messageOpenlead);
    }

    @Override
    public void entryIntoBattle(String userId) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("toBattle");
        message.addParam("platform", "pc").addParam("time", String.valueOf(System.currentTimeMillis() / 1000L));
        this.listMessage.add(message);
    }

    @Override
    public void userUpLevel(String userId, int level) {
        BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("level");
        message.addParam("level", Integer.valueOf(level).toString()).addParam("platform", "pc");
        this.listMessage.add(message);
    }

    @Override
    public CompletionStage<String> getOpenleadID(String code) {
        return gateway.getOpenLeadID(code);
    }
}

