/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;

public class OpenleadServiceGateway
extends AbstractHttpGateway
implements IOpenleadGateway {
    private static final Logger logger = LoggerFactory.getLogger(OpenleadServiceGateway.class);
    private String COOKIE_NAME = "_openlead";
    private String OPENLEAD_URL = "http://openlead.net";
    private String API_KEY = "OL064-ZNTZ2UVW3G";
    private String OPENLEAD;
    private WSClient wsClient;

    @Inject
    public OpenleadServiceGateway(WSClient wsClient, Config config) {
        super("http://openlead.net/data/load/post/", wsClient);
    }

    @Override
    public void registration(BuilderMessageOpenlead.MessageOpenlead message) {
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", "registration").addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    @Override
    public void send(BuilderMessageOpenlead.MessageOpenlead message) {
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", message.getEvent()).addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    private AbstractHttpGateway.RequestWrapper getRequestWrapper() {
        return this.getRequest("", false).addQueryParameter("api_key", this.API_KEY).addQueryParameter("time", String.valueOf(System.currentTimeMillis() / 1000L));
    }

    @Override
    public void getOpenLeadIdAndRegistration(BuilderMessageOpenlead.MessageOpenlead message, String adv_id) {
        this.getRequest("https://rampressure.game/openleadid", "", false).addQueryParameter("code", adv_id).get(r -> {
            JsonNode jsonNode = Json.toJson((Object)r.getBody());
            String code = jsonNode.get("openleadId").asText();
            message.addParam("OpenleadID", code);
            this.registration(message);
            return r.getBody();
        });
    }

    @Override
    public CompletionStage<String> getOpenLeadID(String adv_id) {
        return this.getRequest("https://rampressure.game/openleadid", "", false).addQueryParameter("code", adv_id).get(r -> {
            String code = "?";
            try {
                Gson gson = new Gson();
                HashMap m = (HashMap)gson.fromJson(r.getBody(), HashMap.class);
                code = (String)m.get("openleadId");
                return code;
            }
            catch (Exception e) {
                logger.error("error get openLeadID" + e.getMessage());
                return code;
            }
        });
    }

    @Override
    public void sendXml(String xml) {
        this.getRequest("http://openlead.net/data/load/xml/", "", false).addQueryParameter("xml", String.format(xml, false)).addQueryParameter("api_key", this.API_KEY).postUrlencoded(wsResponse -> wsResponse.getBody());
    }

    @Override
    protected String getToken() {
        return null;
    }
}

