/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.ILoggerService;

public class AbstractLoggerServiceGateway
extends AbstractHttpGateway
implements ILoggerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoggerServiceGateway.class);
    private final Executor executor = Executors.newSingleThreadExecutor();

    @Inject
    public AbstractLoggerServiceGateway(WSClient wsClient, String url) {
        super(url, wsClient);
    }

    @Override
    public void changeCache(final long accountId, final long profileId, final long oldCash, final long newCash, final String cause) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                AbstractLoggerServiceGateway.this.getRequest("/loggerservice/user/1.0/transaction/create", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("oldCash", String.valueOf(oldCash)).addQueryParameter("newCash", String.valueOf(newCash)).addQueryParameter("cause", cause).postUrlencoded(wsResponse -> {
                    logger.info(wsResponse.getBody());
                    return wsResponse.getBody();
                });
            }
        }, this.executor);
    }

    @Override
    public void changeItems(final long accountId, final long profileId, final int idItemTemplate, final int status, final String source, final long itemId) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                AbstractLoggerServiceGateway.this.getRequest("/loggerservice/user/1.0/item/transaction/create", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("idItemTemplate", String.valueOf(idItemTemplate)).addQueryParameter("status", String.valueOf(status)).addQueryParameter("source", String.valueOf(source)).addQueryParameter("itemId", String.valueOf(itemId)).postUrlencoded(wsResponse -> {
                    logger.info(wsResponse.getBody());
                    return wsResponse.getBody();
                });
            }
        }, this.executor);
    }

    @Override
    public void addEventLoginUser(final long accountId, final String version, final String session) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                AbstractLoggerServiceGateway.this.getRequest("/loggerservice/user/1.0/event/user/login", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("version", version).addQueryParameter("session", session).postUrlencoded(wsResponse -> {
                    logger.info(wsResponse.getBody());
                    return wsResponse.getBody();
                });
            }
        }, this.executor);
    }

    @Override
    public void addCustomEvent(final long accountId, final long profileId, final String action, final Map data) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                AbstractLoggerServiceGateway.this.getRequest("/loggerservice/user/1.0/event/custom/create", false).addQueryObjectParameter("accountId", accountId).addQueryObjectParameter("profileId", profileId).addQueryObjectParameter("action", action).addQueryObjectParameter("data", data).put(wsResponse -> {
                    logger.info(wsResponse.getBody());
                    return wsResponse.getBody();
                });
            }
        }, this.executor);
    }

    @Override
    public void addEventLogoutUser(final long accountId, final String session) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                AbstractLoggerServiceGateway.this.getRequest("/loggerservice/user/1.0/event/user/logout", false).addQueryParameter("accountId", String.valueOf(accountId)).addQueryParameter("session", session).postUrlencoded(wsResponse -> {
                    logger.info(wsResponse.getBody());
                    return wsResponse.getBody();
                });
            }
        }, this.executor);
    }

    @Override
    protected String getToken() {
        return null;
    }
}

