/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.domains.profile.Profile;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IShopProtoGateway;
import ru.quadcom.prototool.gateway.messages.sts.common.EquipmentContainer;
import ru.quadcom.prototool.gateway.messages.sts.common.ShopOperatorContainer;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipmentMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.BuyOperatorMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.GetOperatorsOnSaleMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.PriceListMessage;
import ru.quadcom.prototool.gateway.messages.sts.shop.SellMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.shopproto.RQ_ShopBuy;
import ru.quadcom.tactics.shopproto.RQ_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RQ_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RQ_ShopPriceList;
import ru.quadcom.tactics.shopproto.RQ_ShopSell;
import ru.quadcom.tactics.shopproto.RS_ShopBuy;
import ru.quadcom.tactics.shopproto.RS_ShopBuyOperator;
import ru.quadcom.tactics.shopproto.RS_ShopGetOperatorsOnSale;
import ru.quadcom.tactics.shopproto.RS_ShopPriceList;
import ru.quadcom.tactics.shopproto.RS_ShopSell;
import ru.quadcom.tactics.typeproto.Equipment;
import ru.quadcom.tactics.typeproto.EquipmentItem;
import ru.quadcom.tactics.typeproto.ShopType;

public abstract class AbstractShopProtoGateway
extends AbstractProtoGateway
implements IShopProtoGateway {
    public AbstractShopProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<PriceListMessage> priceList(Profile profile) {
        RQ_ShopPriceList request = RQ_ShopPriceList.newBuilder().setProfile(Transformer.toProto(profile)).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_PRICE_LIST, Packet.PacketType.RS_SHOP_PRICE_LIST, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopPriceList.parseFrom((ByteString)bytes))).thenApply(message -> new PriceListMessage(message.getCommonPriceListMap(), message.getSpecialPriceListMap(), message.getRefreshInterval()));
    }

    @Override
    public CompletionStage<Long> buy(Profile profile, ru.quadcom.datapack.domains.shop.ShopType shopType, int itemTemplateId) {
        RQ_ShopBuy request = RQ_ShopBuy.newBuilder().setProfile(Transformer.toProto(profile)).setItemTemplateId(itemTemplateId).setShopType(ShopType.valueOf((String)shopType.name())).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_BUY, Packet.PacketType.RS_SHOP_BUY, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopBuy.parseFrom((ByteString)bytes))).thenApply(RS_ShopBuy::getChangeCash);
    }

    @Override
    public CompletionStage<SellMessage> sell(long accountId, long profileId, int itemId) {
        RQ_ShopSell request = RQ_ShopSell.newBuilder().setAccountId(accountId).setProfileId(profileId).setItemId((long)itemId).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SHOP_SELL, Packet.PacketType.RS_SHOP_SELL, (GeneratedMessageV3)request, false).thenApply(packet -> {
            RS_ShopSell message = this.parse(() -> RS_ShopSell.parseFrom((ByteString)packet.getBody()));
            Map changeEquipmentMap = message.getChangeEquipmentMap();
            Map equipmentMessageMap = StreamEx.of(changeEquipmentMap.entrySet()).toMap(Map.Entry::getKey, entry -> {
                Equipment equipment = (Equipment)entry.getValue();
                return new EquipmentMessage(StreamEx.of((Collection)equipment.getEquipmentItemList()).toMap(EquipmentItem::getSlot, equipmentItem -> new EquipmentContainer(StreamEx.of((Collection)equipmentItem.getItemList()).map(Transformer::fromProto).toList(), StreamEx.of((Collection)equipmentItem.getEquipmentItemTypeList()).toMap(equipmentItemType -> ItemType.valueOf((String)equipmentItemType.getItemType().name()), EquipmentItem.EquipmentItemType::getCount), equipmentItem.hasDefaultItem() ? Transformer.fromProto(equipmentItem.getDefaultItem()) : null)), equipment.getHp(), equipment.getArmor(), equipment.getCurrentHp());
            });
            return new SellMessage(message.getChangeCash(), equipmentMessageMap);
        });
    }

    @Override
    public CompletionStage<GetOperatorsOnSaleMessage> getOperatorsOnSale(Profile profile) {
        RQ_ShopGetOperatorsOnSale request = RQ_ShopGetOperatorsOnSale.newBuilder().setProfile(Transformer.toProto(profile)).build();
        return this.sendProtoGetResponse(Packet.PacketType.RQ_SHOP_GET_OPERATORS_ONSALE, Packet.PacketType.RS_SHOP_GET_OPERATORS_ONSALE, (GeneratedMessageV3)request, false).thenApply(packet -> this.parse(() -> RS_ShopGetOperatorsOnSale.parseFrom((ByteString)packet.getBody()))).thenApply(response -> new GetOperatorsOnSaleMessage(StreamEx.of((Collection)response.getShopOperatorList()).map(shopOperator -> new ShopOperatorContainer(Transformer.fromProto(shopOperator.getOperator()), shopOperator.getPrice(), StreamEx.of((Collection)shopOperator.getItemList()).map(Transformer::fromProto).toList())).toList(), response.getRefreshInterval()));
    }

    @Override
    public CompletionStage<BuyOperatorMessage> buyOperator(Profile profile, long operatorId) {
        RQ_ShopBuyOperator request = RQ_ShopBuyOperator.newBuilder().setProfile(Transformer.toProto(profile)).setOperatorId(operatorId).build();
        return this.sendProto(Packet.PacketType.RQ_SHOP_BUY_OPERATOR, Packet.PacketType.RS_SHOP_BUY_OPERATOR, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ShopBuyOperator.parseFrom((ByteString)bytes))).thenApply(response -> new BuyOperatorMessage(Transformer.fromProto(response.getOperator()), response.getChangeCash()));
    }
}

