/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.google.inject.Inject;
import com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;

public class OpenleadServiceGateway
extends AbstractHttpGateway
implements IOpenleadGateway {
    private static final Logger logger = LoggerFactory.getLogger(OpenleadServiceGateway.class);
    private String COOKIE_NAME = "_openlead";
    private String OPENLEAD_URL = "http://openlead.net";
    private String API_KEY = "OL064-ZNTZ2UVW3G";
    private String OPENLEAD;
    private WSClient wsClient;

    @Inject
    public OpenleadServiceGateway(WSClient wsClient, Config config) {
        super("http://openlead.net/data/load/post/", wsClient);
    }

    @Override
    public void register(BuilderMessageOpenlead.MessageOpenlead message) {
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", "registration").addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    @Override
    public void send(BuilderMessageOpenlead.MessageOpenlead message) {
        this.getRequestWrapper().addQueryParameter("user_id", message.getUserId()).addQueryParameter("event", message.getEvent()).addQueryParameter("value", message.getValue()).postUrlencoded(wsResponse -> {
            logger.info(wsResponse.getBody());
            return wsResponse.getBody();
        });
    }

    private AbstractHttpGateway.RequestWrapper getRequestWrapper() {
        return this.getRequest("", false).addQueryParameter("api_key", this.API_KEY).addQueryParameter("time", String.valueOf(System.currentTimeMillis() / 1000L));
    }

    @Override
    protected String getToken() {
        return null;
    }
}

