/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.IOpenleadService;
import ru.quadcom.prototool.gateway.impl.openlead.BuilderMessageOpenlead;

@Singleton
public class OpenleadService
implements IOpenleadService {
    private final Executor executor;
    private final IOpenleadGateway gateway;

    @Inject
    public OpenleadService(IOpenleadGateway gateway) {
        this.gateway = gateway;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void registration(String userId) {
        final BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).registration();
        String ip = "0.0.0.0";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        message.addParam("UserIP", ip).addParam("OpenleadID", "0").addParam("platform", "pc").addParam("time", String.valueOf(System.currentTimeMillis())).addParam("event", "registration");
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                OpenleadService.this.gateway.register(message);
            }
        }, this.executor);
    }

    @Override
    public void authorization(String userId) {
        final BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).login();
        message.addParam("platform", "pc").addParam("time", String.valueOf(System.currentTimeMillis() / 1000L)).addParam("event", "login").addParam("RegDate", String.valueOf(System.currentTimeMillis() / 1000L));
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                OpenleadService.this.gateway.send(message);
            }
        }, this.executor);
    }

    @Override
    public void send(final BuilderMessageOpenlead.MessageOpenlead messageOpenlead) {
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                OpenleadService.this.gateway.register(messageOpenlead);
            }
        }, this.executor);
    }

    @Override
    public void entryIntoBattle(String userId) {
        final BuilderMessageOpenlead.MessageOpenlead message = BuilderMessageOpenlead.build(userId).event("toBattle");
        message.addParam("platform", "pc").addParam("time", String.valueOf(System.currentTimeMillis()));
        CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                OpenleadService.this.gateway.send(message);
            }
        }, this.executor);
    }
}

