/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.openlead;

import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;

public class BuilderMessageOpenlead {
    private String profileId;
    public MessageOpenlead message;

    public static BuilderMessageOpenlead build(String profileId) {
        return new BuilderMessageOpenlead(profileId);
    }

    public MessageOpenlead registration() {
        this.message.event = "registration";
        this.message.addParam("OpenleadID", "0");
        return this.message;
    }

    public MessageOpenlead login() {
        this.message.event = "login";
        this.message.addParam("RegDate", String.valueOf(System.currentTimeMillis() / 1000L));
        return this.message;
    }

    public MessageOpenlead event(String event) {
        this.message.event = event;
        return this.message;
    }

    private BuilderMessageOpenlead(String profileId) {
        this.profileId = profileId;
        this.message = new MessageOpenlead(profileId);
    }

    public class MessageOpenlead {
        private Map<String, String> options = new HashMap<String, String>();
        private String userId;
        private String event;
        private String value;

        private MessageOpenlead(String userId, String event, String value) {
            this.userId = userId;
            this.event = event;
            this.value = value;
        }

        private MessageOpenlead(String userId) {
            this.userId = userId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getEvent() {
            return this.event;
        }

        public MessageOpenlead setEvent(String event) {
            this.event = event;
            return this;
        }

        public MessageOpenlead setUserId(String userId) {
            this.addParam("UserIP", userId);
            return this;
        }

        public MessageOpenlead setPlatformID(String platformId) {
            this.addParam("PlatformID", platformId);
            return this;
        }

        public MessageOpenlead setSocialID(String socialId) {
            this.addParam("SocialID", socialId);
            return this;
        }

        public MessageOpenlead addParam(String name, String value) {
            this.options.put(name, value);
            return this;
        }

        public String getValue() {
            this.value = StreamEx.of(this.options.entrySet()).map(entry -> (String)entry.getValue()).joining((CharSequence)";");
            return this.value;
        }

        private final class Event {
            public static final String REGISTRATION = "registration";
            public static final String LOGIN = "login";

            private Event() {
            }
        }

        private final class Options {
            public static final String UserIP = "UserIP";
            public static final String OpenleadID = "OpenleadID";
            public static final String PlatformID = "PlatformID";
            public static final String SocialID = "SocialID";
            public static final String QueryString = "QueryString";

            private Options() {
            }
        }
    }
}

