/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import play.libs.ws.WSClient;
import play.libs.ws.WSCookie;
import play.libs.ws.WSRequest;
import ru.quadcom.prototool.gateway.IOpenleadGateway;
import ru.quadcom.prototool.gateway.IOpenleadService;

@Singleton
public class OpenleadService
implements IOpenleadService {
    private final WSClient wsClient;
    private final String SEPARATOR = ";";
    private final int THREADS_COUNT = 10;
    private final String OPENLEAD_ID_URL = "https://openlead.net/s/ol.js?id=ol64";
    private final IOpenleadGateway gateway;
    private final Executor executor;

    @Inject
    public OpenleadService(WSClient wsClient, IOpenleadGateway gateway) {
        this.wsClient = wsClient;
        this.gateway = gateway;
        this.executor = Executors.newFixedThreadPool(10);
    }

    @Override
    public void sendRegistration(long accountId, long profileId) {
        String ip = "0.0.0.0";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
        }
        catch (UnknownHostException inetAddress) {
            // empty catch block
        }
        String ipAddress = ip;
        WSRequest request = this.wsClient.url("https://openlead.net/s/ol.js?id=ol64");
        request.get().thenApply(response -> {
            String oledId = ((WSCookie)response.getCookie("openleadId").get()).getValue();
            this.sendMessage(new Message(profileId + "", "registration", ipAddress + ";" + oledId + ";" + "pc"));
            return oledId;
        });
    }

    @Override
    public void sendAuthorization(long accountId, long profileId) {
        this.sendMessage(new Message(profileId + "", "login", "0;pc"));
    }

    @Override
    public void sendGoToFight(long profileId) {
        this.sendMessage(new Message(profileId + "", "userGoToFight", ""));
    }

    private void sendMessage(Message message) {
        CompletableFuture.runAsync(message, this.executor);
    }

    private class Message
    implements Runnable {
        String user_id;
        String event;
        String message;

        public Message(String user_id, String event, String message) {
            this.user_id = user_id;
            this.event = event;
            this.message = message;
        }

        @Override
        public void run() {
            OpenleadService.this.gateway.sendData(this.user_id, this.event, this.message);
        }
    }
}

