/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl.proto;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import one.util.streamex.StreamEx;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.operator.EquipmentSlot;
import ru.quadcom.prototool.gateway.AbstractProtoGateway;
import ru.quadcom.prototool.gateway.IItemProtoGateway;
import ru.quadcom.prototool.gateway.messages.sts.item.AddEnhancementMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipmentMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.SkillLearnMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.UnequipMessage;
import ru.quadcom.prototool.util.Transformer;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.itemproto.RQ_ItemEnhancementAdd;
import ru.quadcom.tactics.itemproto.RQ_ItemEnhancementRemove;
import ru.quadcom.tactics.itemproto.RQ_ItemEquipments;
import ru.quadcom.tactics.itemproto.RQ_ItemInventory;
import ru.quadcom.tactics.itemproto.RQ_ItemItemAdd;
import ru.quadcom.tactics.itemproto.RQ_ItemItemEquip;
import ru.quadcom.tactics.itemproto.RQ_ItemItemGet;
import ru.quadcom.tactics.itemproto.RQ_ItemItemRemove;
import ru.quadcom.tactics.itemproto.RQ_ItemItemUnequip;
import ru.quadcom.tactics.itemproto.RQ_ItemSkillLearn;
import ru.quadcom.tactics.itemproto.RQ_ItemSkillList;
import ru.quadcom.tactics.itemproto.RS_ItemEnhancementAdd;
import ru.quadcom.tactics.itemproto.RS_ItemEnhancementRemove;
import ru.quadcom.tactics.itemproto.RS_ItemEquipments;
import ru.quadcom.tactics.itemproto.RS_ItemInventory;
import ru.quadcom.tactics.itemproto.RS_ItemItemAdd;
import ru.quadcom.tactics.itemproto.RS_ItemItemEquip;
import ru.quadcom.tactics.itemproto.RS_ItemItemGet;
import ru.quadcom.tactics.itemproto.RS_ItemItemRemove;
import ru.quadcom.tactics.itemproto.RS_ItemItemUnequip;
import ru.quadcom.tactics.itemproto.RS_ItemSkillLearn;
import ru.quadcom.tactics.itemproto.RS_ItemSkillList;
import ru.quadcom.tactics.typeproto.Equipment;

public abstract class AbstractItemProtoGateway
extends AbstractProtoGateway
implements IItemProtoGateway {
    public AbstractItemProtoGateway(WSClient wsClient, String url) {
        super(wsClient, url + "/proto");
    }

    @Override
    public CompletionStage<List<Item>> inventory(long profileId) {
        RQ_ItemInventory request = RQ_ItemInventory.newBuilder().setProfileId(profileId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_INVENTORY, Packet.PacketType.RS_ITEM_INVENTORY, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemInventory.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getItemsList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<Map<Long, EquipmentMessage>> equipments(long profileId, Set<Long> profileIds) {
        RQ_ItemEquipments request = RQ_ItemEquipments.newBuilder().setProfileId(profileId).addAllOperatorId(profileIds).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_EQUIPMENTS, Packet.PacketType.RS_ITEM_EQUIPMENTS, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemEquipments.parseFrom((ByteString)bytes))).thenApply(message -> {
            Map protoEquipments = message.getEquipmentMap();
            HashMap equipments = Maps.newHashMap();
            protoEquipments.forEach((operatorId, equipment) -> equipments.put(operatorId, new EquipmentMessage(StreamEx.of((Collection)equipment.getEquipmentItemList()).toMap(equipmentItem -> EquipmentSlot.valueOf((String)equipmentItem.getEquipmentSlot().name()), equipmentItem -> Transformer.fromProto(equipmentItem.getItem())), equipment.getHp(), equipment.getArmor())));
            return equipments;
        });
    }

    @Override
    public CompletionStage<EquipMessage> itemEquip(long profileId, long operatorId, long itemId) {
        RQ_ItemItemEquip request = RQ_ItemItemEquip.newBuilder().setProfileId(profileId).setOperatorId(operatorId).setItemId(itemId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ITEM_EQUIP, Packet.PacketType.RS_ITEM_ITEM_EQUIP, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemItemEquip.parseFrom((ByteString)bytes))).thenApply(message -> {
            Equipment protoChangeEquipment = message.getChangeEquipment();
            EquipmentMessage changeEquipment = new EquipmentMessage(StreamEx.of((Collection)protoChangeEquipment.getEquipmentItemList()).toMap(equipmentItem -> EquipmentSlot.valueOf((String)equipmentItem.getEquipmentSlot().name()), equipmentItem -> Transformer.fromProto(equipmentItem.getItem())), protoChangeEquipment.getHp(), protoChangeEquipment.getArmor());
            return new EquipMessage(changeEquipment, StreamEx.of((Collection)message.getAddItemsList()).map(Transformer::fromProto).toList(), StreamEx.of((Collection)message.getRemoveItemsList()).toList());
        });
    }

    @Override
    public CompletionStage<UnequipMessage> itemUnequip(long profileId, long operatorId, long itemId) {
        RQ_ItemItemUnequip request = RQ_ItemItemUnequip.newBuilder().setProfileId(profileId).setOperatorId(operatorId).setItemId(itemId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ITEM_UNEQUIP, Packet.PacketType.RS_ITEM_ITEM_UNEQUIP, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemItemUnequip.parseFrom((ByteString)bytes))).thenApply(message -> {
            List protoChangeEquipment = message.getChangeEquipmentList();
            return new UnequipMessage(StreamEx.of((Collection)protoChangeEquipment).toMap(equipmentItem -> EquipmentSlot.valueOf((String)equipmentItem.getEquipmentSlot().name()), equipmentItem -> equipmentItem.hasItem() ? Transformer.fromProto(equipmentItem.getItem()) : null), StreamEx.of((Collection)message.getAddItemsList()).map(Transformer::fromProto).toList());
        });
    }

    @Override
    public CompletionStage<SkillLearnMessage> skillLearn(long profileId, long operatorId, int skillTemplateId) {
        RQ_ItemSkillLearn request = RQ_ItemSkillLearn.newBuilder().setProfileId(profileId).setOperatorId(operatorId).setSkillTemplateId(skillTemplateId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_SKILL_LEARN, Packet.PacketType.RS_ITEM_SKILL_LEARN, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemSkillLearn.parseFrom((ByteString)bytes))).thenApply(message -> new SkillLearnMessage(Transformer.fromProto(message.getSkill()), message.getSkillPoints()));
    }

    @Override
    public CompletionStage<List<Item>> skillList(long profileId, Set<Long> operatorIds) {
        RQ_ItemSkillList request = RQ_ItemSkillList.newBuilder().setProfileId(profileId).addAllOperatorId(operatorIds).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_SKILL_LIST, Packet.PacketType.RS_ITEM_SKILL_LIST, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemSkillList.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getSkillList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<AddEnhancementMessage> enhancementAdd(long profileId, long itemId, long upgradeId) {
        RQ_ItemEnhancementAdd request = RQ_ItemEnhancementAdd.newBuilder().setProfileId(profileId).setItemId(itemId).setUpgradeId(upgradeId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ENHANCEMENT_ADD, Packet.PacketType.RS_ITEM_ENHANCEMENT_ADD, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemEnhancementAdd.parseFrom((ByteString)bytes))).thenApply(message -> new AddEnhancementMessage(StreamEx.of((Collection)message.getUpdateItemList()).map(Transformer::fromProto).toList(), StreamEx.of((Collection)message.getRemoveItemList()).map(Transformer::fromProto).toList()));
    }

    @Override
    public CompletionStage<List<Item>> enhancementRemove(long profileId, long itemId, long upgradeId) {
        RQ_ItemEnhancementRemove request = RQ_ItemEnhancementRemove.newBuilder().setProfileId(profileId).setItemId(itemId).setUpgradeId(upgradeId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ENHANCEMENT_REMOVE, Packet.PacketType.RS_ITEM_ENHANCEMENT_REMOVE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemEnhancementRemove.parseFrom((ByteString)bytes))).thenApply(message -> StreamEx.of((Collection)message.getUpdateItemList()).map(Transformer::fromProto).toList());
    }

    @Override
    public CompletionStage<Item> itemAdd(long profileId, int itemTemplateId) {
        RQ_ItemItemAdd request = RQ_ItemItemAdd.newBuilder().setProfileId(profileId).setItemTemplateId(itemTemplateId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ITEM_ADD, Packet.PacketType.RS_ITEM_ITEM_ADD, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemItemAdd.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getItem()));
    }

    @Override
    public CompletionStage<Void> itemRemove(long profileId, long itemId) {
        RQ_ItemItemRemove request = RQ_ItemItemRemove.newBuilder().setProfileId(profileId).setItemId(itemId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ITEM_REMOVE, Packet.PacketType.RS_ITEM_ITEM_REMOVE, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemItemRemove.parseFrom((ByteString)bytes))).thenApply(message -> null);
    }

    @Override
    public CompletionStage<Item> itemGet(long profileId, long itemId) {
        RQ_ItemItemGet request = RQ_ItemItemGet.newBuilder().setProfileId(profileId).setItemId(itemId).build();
        return this.sendProto(Packet.PacketType.RQ_ITEM_ITEM_GET, Packet.PacketType.RS_ITEM_ITEM_GET, (GeneratedMessageV3)request, false).thenApply(bytes -> this.parse(() -> RS_ItemItemGet.parseFrom((ByteString)bytes))).thenApply(message -> Transformer.fromProto(message.getItem()));
    }
}

