/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.messages.stc;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import ru.quadcom.prototool.gateway.messages.AbstractMessage;
import ru.quadcom.prototool.gateway.messages.stc.CommandMessage;
import ru.quadcom.prototool.gateway.messages.stc.CommandType;
import ru.quadcom.prototool.gateway.messages.stc.StatusCode;
import ru.quadcom.tactics.baseproto.Packet;

public abstract class AbstractSTCMessage
extends AbstractMessage {
    private final int statusCode;
    private final String errorMessage;
    private final List<CommandMessage> commands = Lists.newArrayList();

    public AbstractSTCMessage(int statusCode, String errorMessage) {
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    public AbstractSTCMessage(StatusCode statusCode, String errorMessage) {
        this(statusCode.getCode(), errorMessage);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void addCommand(Packet.ProtoCommand command) {
        CommandType commandType = CommandType.valueOf(command.getType().name());
        this.commands.add(new CommandMessage(commandType, commandType.fromProto(command.getBody())));
    }

    public void addAllCommands(Collection<Packet.ProtoCommand> commands) {
        for (Packet.ProtoCommand command : commands) {
            this.addCommand(command);
        }
    }

    public List<CommandMessage> getCommands() {
        return this.commands;
    }
}

