/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import java.util.UUID;
import org.slf4j.LoggerFactory;
import ru.quadcom.prototool.gateway.impl.AbstractLoggerService;

@Singleton
public final class LoggerCustomEventWithFileExternalSync
extends AbstractLoggerService {
    private final Logger forwardedLog;
    private final String staging;

    @Inject
    public LoggerCustomEventWithFileExternalSync(Config config) {
        this.staging = config.getString("configuration.env_name");
        String directory = config.getString("customEventForwardedLogDirectory");
        this.forwardedLog = this.programmaticallyConfigLogger(directory);
    }

    private Logger programmaticallyConfigLogger(String directory) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger result = (Logger)LoggerFactory.getLogger((String)"custom_event_forwarded");
        if (result.iteratorForAppenders().hasNext()) {
            throw new RuntimeException("config is created programmatically, thus must not be set in logback.xml");
        }
        result.setAdditive(false);
        result.setLevel(Level.TRACE);
        RollingFileAppender rollingFileAppender = new RollingFileAppender();
        rollingFileAppender.setContext((Context)loggerContext);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%msg%n");
        encoder.start();
        rollingFileAppender.setEncoder((Encoder)encoder);
        SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
        policy.setContext((Context)loggerContext);
        policy.setFileNamePattern(directory + "/custom-event-forwarded-%d{yyyy-MM-dd-HH}.%i.log");
        policy.setParent((FileAppender)rollingFileAppender);
        policy.setMaxFileSize(FileSize.valueOf((String)"100mb"));
        policy.start();
        rollingFileAppender.setRollingPolicy((RollingPolicy)policy);
        rollingFileAppender.start();
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setContext((Context)loggerContext);
        asyncAppender.setQueueSize(500);
        asyncAppender.setDiscardingThreshold(0);
        asyncAppender.addAppender((Appender)rollingFileAppender);
        asyncAppender.start();
        result.addAppender((Appender)asyncAppender);
        return result;
    }

    @Override
    public void addCustomEvent(String json) {
        String modifiedJson = this.modifyJsonAddParams(json);
        this.forwardedLog.info(modifiedJson);
    }

    private String modifyJsonAddParams(String inputJson) {
        StringBuilder stringBuilder = new StringBuilder(inputJson.length() + 100);
        stringBuilder.append("{\"guid\":\"");
        stringBuilder.append(UUID.randomUUID().toString());
        stringBuilder.append("\",\"timestamp\":");
        long unixTime = System.currentTimeMillis() / 1000L;
        stringBuilder.append(unixTime);
        stringBuilder.append(",\"staging\":\"");
        stringBuilder.append(this.staging);
        stringBuilder.append("\",");
        stringBuilder.append(inputJson.substring(1));
        return stringBuilder.toString();
    }
}

