/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool;

import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.prototool.ProtoHandler;
import ru.quadcom.tactics.baseproto.Packet;

public abstract class AbstractProtoService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProtoService.class);
    private final Map<Packet.PacketType, Pair<Packet.PacketType, ProtoHandler>> map = Maps.newHashMap();

    protected void registrationHandler(Packet.PacketType requestType, Packet.PacketType responseType, ProtoHandler handler) {
        this.map.put(requestType, (Pair<Packet.PacketType, ProtoHandler>)ImmutablePair.of((Object)responseType, (Object)handler));
    }

    public CompletionStage<byte[]> handleRequest(Http.RequestBody body) {
        try {
            long startTimeMs = System.currentTimeMillis();
            Packet request = Packet.parseFrom((byte[])body.asBytes().toArray());
            Pair<Packet.PacketType, ProtoHandler> pair = this.map.get(request.getType());
            ProtoHandler protoHandler = (ProtoHandler)pair.getValue();
            return CompletableFuture.supplyAsync(() -> null).thenCompose(Void2 -> {
                try {
                    long unlockedByAccountIdTimeMs = System.currentTimeMillis();
                    return protoHandler.process0(request.getType(), request.getBody()).thenApply(response -> {
                        if (logger.isTraceEnabled()) {
                            logger.trace("response " + pair.getKey() + "\n" + response.toString());
                        }
                        long processedTimeMs = System.currentTimeMillis();
                        long totalDelayMs = processedTimeMs - startTimeMs;
                        long processedDelayMs = processedTimeMs - unlockedByAccountIdTimeMs;
                        StringBuilder stringBuilder = new StringBuilder(512);
                        stringBuilder.append("TIMINGS: total = ").append(totalDelayMs);
                        stringBuilder.append("; requestType = ").append(request.getType());
                        stringBuilder.append("; processed = ").append(processedDelayMs);
                        if (totalDelayMs > 1000L) {
                            logger.warn(stringBuilder.toString());
                        } else {
                            logger.info(stringBuilder.toString());
                        }
                        return Packet.newBuilder().setType((Packet.PacketType)pair.getKey()).setBody(((GeneratedMessageV3)response).toByteString()).build().toByteArray();
                    });
                }
                catch (InvalidProtocolBufferException e) {
                    throw new WarningException("Proto handled error", 1);
                }
            });
        }
        catch (InvalidProtocolBufferException e) {
            throw new WarningException("Proto handled error", 1);
        }
    }
}

