/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IIdentityServiceGateway;
import ru.quadcom.prototool.gateway.messages.sts.AccountIdSteamIdPair;

public abstract class AbstractIdentityServiceGateway
extends AbstractHttpGateway
implements IIdentityServiceGateway {
    private static final Gson gson = new GsonBuilder().create();
    private static final Type AccountIdSteamIdPairListType = new TypeToken<ArrayList<AccountIdSteamIdPair>>(){}.getType();

    public AbstractIdentityServiceGateway(String url, WSClient wsClient) {
        super(url, wsClient);
    }

    @Override
    public CompletionStage<Session> getSession(String sessionId) {
        return this.getRequest("/session/find", false).addQueryParameter("sessionId", sessionId).get(response -> (Session)gson.fromJson(response.getBody(), Session.class));
    }

    @Override
    public CompletionStage<Void> updateSession(Session session) {
        return this.getRequest("/session/update", true).addQueryParameter("session", gson.toJson((Object)session)).postUrlencoded(response -> null);
    }

    @Override
    public CompletionStage<Long> resolveLogin(String login) {
        return this.getRequest("/identity/sts/resolveLogin", true).addQueryParameter("login", login).postUrlencoded(response -> (Long)gson.fromJson(response.getBody(), Long.class));
    }

    @Override
    public CompletionStage<List<AccountIdSteamIdPair>> resolveSteamIdsBatch(Long[] steamIds) {
        return this.getRequest("/identity/sts/resolveSteamIdsBatch", true).addQueryParameter("steamIds", gson.toJson((Object)steamIds)).postUrlencoded(response -> (List)gson.fromJson(response.getBody(), AccountIdSteamIdPairListType));
    }
}

