/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import java.util.concurrent.CompletionStage;
import play.libs.ws.WSClient;
import ru.quadcom.prototool.gateway.AbstractHttpGateway;
import ru.quadcom.prototool.gateway.IItemServiceGateway;
import ru.quadcom.prototool.gateway.messages.sts.item.AddMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.EquipmentMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.ItemMessage;
import ru.quadcom.prototool.gateway.messages.sts.item.RemoveMessage;
import ru.quadcom.prototool.util.GsonUtil;

public abstract class AbstractItemServiceGateway
extends AbstractHttpGateway
implements IItemServiceGateway {
    public AbstractItemServiceGateway(String url, WSClient wsClient) {
        super(url, wsClient);
    }

    @Override
    public CompletionStage<EquipmentMessage> getEquipment(long profileId, long operatorId) {
        return this.getRequest("/itemservice/sts/1.0/items/equipment", true).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("operatorId", String.valueOf(operatorId)).get(response -> GsonUtil.fromJson(response.getBody(), EquipmentMessage.class));
    }

    @Override
    public CompletionStage<AddMessage> addItem(long profileId, int itemTemplateId) {
        return this.getRequest("/itemservice/sts/1.0/items/add", true).addQueryParameter("itemTemplateId", String.valueOf(itemTemplateId)).addQueryParameter("profileId", String.valueOf(profileId)).get(response -> GsonUtil.fromJson(response.getBody(), AddMessage.class));
    }

    @Override
    public CompletionStage<RemoveMessage> removeItem(long profileId, int itemId) {
        return this.getRequest("/itemservice/sts/1.0/items/removeItem ", true).addQueryParameter("itemId", String.valueOf(itemId)).addQueryParameter("profileId", String.valueOf(profileId)).get(response -> GsonUtil.fromJson(response.getBody(), RemoveMessage.class));
    }

    @Override
    public CompletionStage<ItemMessage> getItemFromInventory(long profileId, int itemId) {
        return this.getRequest("/itemservice/sts/1.0/items/getItemFromInventory ", true).addQueryParameter("itemId", String.valueOf(itemId)).addQueryParameter("profileId", String.valueOf(profileId)).get(response -> GsonUtil.fromJson(response.getBody(), ItemMessage.class));
    }
}

