/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import java.util.List;
import java.util.concurrent.CompletionStage;
import play.libs.ws.WSClient;
import ru.quadcom.datapack.domains.operator.Operator;
import ru.quadcom.prototool.gateway.ISquadServiceGateway;
import ru.quadcom.prototool.gateway.impl.AbstractServiceGateway;
import ru.quadcom.prototool.gateway.messages.sts.squad.BattleResultMessage;
import ru.quadcom.prototool.gateway.messages.sts.squad.OperatorMessage;
import ru.quadcom.prototool.gateway.messages.sts.squad.OperatorsMessage;
import ru.quadcom.prototool.gateway.messages.sts.squad.SquadMessage;
import ru.quadcom.prototool.gateway.util.GsonUtil;

public abstract class AbstractSquadServiceGateway
extends AbstractServiceGateway
implements ISquadServiceGateway {
    public AbstractSquadServiceGateway(String url, WSClient wsClient) {
        super(url, wsClient);
    }

    @Override
    public CompletionStage<List<Operator>> getSquad(long profileId) {
        return this.getRequest("/sts/getSquad", true).addQueryParameter("profileId", String.valueOf(profileId)).get(response -> GsonUtil.fromJson(response.getBody(), SquadMessage.class).getOperators());
    }

    @Override
    public CompletionStage<Operator> getOperator(long profileId, long operatorId) {
        return this.getRequest("/sts/getOperator", true).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("operatorId", String.valueOf(operatorId)).get(response -> GsonUtil.fromJson(response.getBody(), OperatorMessage.class).getOperator());
    }

    @Override
    public CompletionStage<Void> postBattleResult(BattleResultMessage message) {
        return this.getRequest("/sts/battleResult", true).post(() -> GsonUtil.toJson(message), response -> null);
    }

    @Override
    public CompletionStage<List<Operator>> getOperators(long profileId) {
        return this.getRequest("/sts/getOperators", true).addQueryParameter("profileId", String.valueOf(profileId)).get(response -> GsonUtil.fromJson(response.getBody(), OperatorsMessage.class).getOperators());
    }

    @Override
    public CompletionStage<Operator> changeOperatorSkillPoints(long profileId, long operatorId, int skillPointsDelta) {
        return this.getRequest("/sts/changeOperatorSkillPoits", true).addQueryParameter("profileId", String.valueOf(profileId)).addQueryParameter("operatorId", String.valueOf(operatorId)).addQueryParameter("skillPointsDelta", String.valueOf(skillPointsDelta)).post(response -> GsonUtil.fromJson(response.getBody(), OperatorMessage.class).getOperator());
    }
}

