/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.prototool.gateway.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.concurrent.CompletionStage;
import play.libs.ws.WSClient;
import ru.quadcom.commons.identity.service.to.service.ServicesSecrets;
import ru.quadcom.prototool.gateway.IStaticProtoGateway;
import ru.quadcom.prototool.gateway.ProtoGateway;
import ru.quadcom.tactics.baseproto.PacketType;
import ru.quadcom.tactics.staticproto.RQ_Appearances;
import ru.quadcom.tactics.staticproto.RQ_ClassSkillMaps;
import ru.quadcom.tactics.staticproto.RQ_Classes;
import ru.quadcom.tactics.staticproto.RQ_Experiences;
import ru.quadcom.tactics.staticproto.RQ_Fractions;
import ru.quadcom.tactics.staticproto.RQ_Genders;
import ru.quadcom.tactics.staticproto.RQ_Properties;
import ru.quadcom.tactics.staticproto.RQ_Races;
import ru.quadcom.tactics.staticproto.RQ_Ranks;
import ru.quadcom.tactics.staticproto.RQ_Skills;
import ru.quadcom.tactics.staticproto.RS_Appearances;
import ru.quadcom.tactics.staticproto.RS_ClassSkillMaps;
import ru.quadcom.tactics.staticproto.RS_Classes;
import ru.quadcom.tactics.staticproto.RS_Experiences;
import ru.quadcom.tactics.staticproto.RS_Fractions;
import ru.quadcom.tactics.staticproto.RS_Genders;
import ru.quadcom.tactics.staticproto.RS_Properties;
import ru.quadcom.tactics.staticproto.RS_Races;
import ru.quadcom.tactics.staticproto.RS_Ranks;
import ru.quadcom.tactics.staticproto.RS_Skills;

@Singleton
public class StaticProtoGateway
extends ProtoGateway
implements IStaticProtoGateway {
    @Inject
    public StaticProtoGateway(WSClient wsClient, String url, ServicesSecrets clientSecret) {
        super(wsClient, url, clientSecret);
    }

    @Override
    protected ServicesSecrets getServerSecret() {
        return ServicesSecrets.STATIC;
    }

    @Override
    public CompletionStage<RS_Properties> getProperties(RQ_Properties.PropertyType type) {
        RQ_Properties response = RQ_Properties.newBuilder().setType(type).build();
        return this.sendProto(PacketType.RQ_STATIC_PROPERTY, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Properties.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Appearances> getAppearances() {
        RQ_Appearances response = RQ_Appearances.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_APPEARANCES, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Appearances.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Classes> getClasses() {
        RQ_Classes response = RQ_Classes.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_CLASSES, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Classes.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_ClassSkillMaps> getClassSkillMaps() {
        RQ_ClassSkillMaps response = RQ_ClassSkillMaps.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_CLASS_SKILL_MAPS, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_ClassSkillMaps.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Experiences> getExperience() {
        RQ_Experiences response = RQ_Experiences.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_EXPERIENCE, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Experiences.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Fractions> getFractions() {
        RQ_Fractions response = RQ_Fractions.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_FRACTIONS, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Fractions.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Genders> getGenders() {
        RQ_Genders response = RQ_Genders.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_GENDERS, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Genders.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Races> getRaces() {
        RQ_Races response = RQ_Races.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_RACES, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Races.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Ranks> getRanks() {
        RQ_Ranks response = RQ_Ranks.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_RANKS, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Ranks.parseFrom((ByteString)bytes)));
    }

    @Override
    public CompletionStage<RS_Skills> getSkills() {
        RQ_Skills response = RQ_Skills.newBuilder().build();
        return this.sendProto(PacketType.RQ_STATIC_RANKS, (GeneratedMessageV3)response).thenApply(bytes -> this.parse(() -> RS_Skills.parseFrom((ByteString)bytes)));
    }
}

