/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.filehasher2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import ru.quadcom.filehasher2.Crc32C;

public class Main {
    private static final Crc32C ReusableCrcCalculator = new Crc32C();
    private static final StringBuilder ReusableStringBuilderForHash = new StringBuilder(8);
    private static final byte[] ReusableByteArrayForHash = new byte[4];

    public static void main(String[] args) {
        String inputPathName = args[0];
        String outputPathName = args[1];
        Path inputPath = new File(inputPathName).toPath();
        long start = System.currentTimeMillis();
        try (BufferedWriter resultBufferedWriter = Files.newBufferedWriter(Paths.get(outputPathName, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
             Stream<Path> paths = Files.walk(Paths.get(inputPathName, new String[0]), 100, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.toString().endsWith(".crc")).filter(path -> !path.toString().equals(outputPathName)).forEach(path -> {
                File file = path.toFile();
                String id = file.getName().replaceFirst("\\.[^.]*$", "");
                String relativePath = inputPath.relativize((Path)path).toString();
                long size = file.length();
                try {
                    String hash = Main.CalculateFileHash(path.toString());
                    System.out.println("relativePath = " + relativePath + "; hash = " + hash);
                    resultBufferedWriter.append(id);
                    resultBufferedWriter.append(",");
                    resultBufferedWriter.append(relativePath);
                    resultBufferedWriter.append(",");
                    resultBufferedWriter.append(hash);
                    resultBufferedWriter.append(",");
                    resultBufferedWriter.append(String.valueOf(size));
                    resultBufferedWriter.append("\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("TOTAL Elapsed " + (System.currentTimeMillis() - start) + " ms");
    }

    private static String CalculateFileHash(String inputFileName) throws IOException {
        int crc32 = ReusableCrcCalculator.ReadFileAndCalculate(inputFileName);
        Main.ReusableByteArrayForHash[0] = (byte)(crc32 >>> 24);
        Main.ReusableByteArrayForHash[1] = (byte)(crc32 >>> 16);
        Main.ReusableByteArrayForHash[2] = (byte)(crc32 >>> 8);
        Main.ReusableByteArrayForHash[3] = (byte)crc32;
        ReusableStringBuilderForHash.setLength(0);
        for (int i = 0; i < 4; ++i) {
            if ((0xFF & ReusableByteArrayForHash[i]) < 16) {
                ReusableStringBuilderForHash.append('0');
            }
            ReusableStringBuilderForHash.append(Integer.toHexString(0xFF & ReusableByteArrayForHash[i]));
        }
        return ReusableStringBuilderForHash.toString();
    }
}

