/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.filecleaner;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.FileUtils;

public class Main {
    public static void main(String[] args) {
        int leaveCount = Integer.parseInt(args[1]);
        long start = System.currentTimeMillis();
        ArrayList<Path> listToDelete = new ArrayList<Path>();
        System.out.println("= FOUND ==============================");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(args[0], new String[0]));){
            for (Path file : stream) {
                if (!file.toFile().isDirectory()) continue;
                BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                System.out.println(file.getFileName() + "; creationTime: " + attr.creationTime());
                listToDelete.add(file);
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println(x);
        }
        Collections.sort(listToDelete, (o1, o2) -> {
            try {
                BasicFileAttributes attr1 = Files.readAttributes((Path)o1, BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes attr2 = Files.readAttributes((Path)o2, BasicFileAttributes.class, new LinkOption[0]);
                return attr1.creationTime().compareTo(attr2.creationTime());
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        });
        System.out.println("= SORTED ==============================");
        try {
            for (Path path : listToDelete) {
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                System.out.println(path.getFileName() + "; creationTime: " + attr.creationTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 1; i <= leaveCount && !listToDelete.isEmpty(); ++i) {
            listToDelete.remove(listToDelete.size() - 1);
        }
        System.out.println("= DELETED ==============================");
        try {
            for (Path path : listToDelete) {
                System.out.println(path.getFileName());
                FileUtils.deleteDirectory((File)path.toFile());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("TOTAL Elapsed " + (System.currentTimeMillis() - start) + " ms");
    }
}

